/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scheduler;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.scheduler.SchedulerComponent;
import org.apache.camel.component.scheduler.SchedulerConsumer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ScheduledPollEndpoint;

@UriEndpoint(firstVersion="2.15.0", scheme="scheduler", title="Scheduler", syntax="scheduler:name", consumerOnly=true, category={Category.CORE, Category.SCHEDULING})
public class SchedulerEndpoint
extends ScheduledPollEndpoint {
    @UriPath
    @Metadata(required=true)
    private String name;
    @UriParam(defaultValue="1", label="scheduler")
    private int poolSize = 1;
    @UriParam(defaultValue="false", label="advanced", description="Sets whether synchronous processing should be strictly used")
    private boolean synchronous;

    public SchedulerEndpoint(String uri, SchedulerComponent component, String remaining) {
        super(uri, component);
        this.name = remaining;
    }

    @Override
    public SchedulerComponent getComponent() {
        return (SchedulerComponent)super.getComponent();
    }

    @Override
    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Scheduler cannot be used as a producer");
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        SchedulerConsumer consumer = new SchedulerConsumer(this, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public void onConsumerStart(SchedulerConsumer consumer) {
        if (consumer.getScheduler() == null && consumer.getScheduledExecutorService() == null) {
            ScheduledExecutorService scheduler = this.getComponent().addConsumer(consumer);
            consumer.setScheduledExecutorService(scheduler);
        }
    }

    public void onConsumerStop(SchedulerConsumer consumer) {
        this.getComponent().removeConsumer(consumer);
    }
}

