/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import org.apache.camel.CamelContext;
import org.apache.camel.component.validator.ValidatorComponent;
import org.apache.camel.component.validator.ValidatorResourceResolverFactory;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class ValidatorComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        ValidatorComponent target = (ValidatorComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(ValidatorComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(ValidatorComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "resourceresolverfactory": 
            case "resourceResolverFactory": {
                target.setResourceResolverFactory(ValidatorComponentConfigurer.property(camelContext, ValidatorResourceResolverFactory.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "resourceresolverfactory": 
            case "resourceResolverFactory": {
                return ValidatorResourceResolverFactory.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        ValidatorComponent target = (ValidatorComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "resourceresolverfactory": 
            case "resourceResolverFactory": {
                return target.getResourceResolverFactory();
            }
        }
        return null;
    }
}

