/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.constant;

import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.builder.ExpressionBuilder;

@Language(value="constant")
public class ConstantLanguage
extends LanguageSupport {
    public static Expression constant(Object value) {
        return ExpressionBuilder.constantExpression(value);
    }

    @Override
    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate(this.createExpression(expression));
    }

    @Override
    public Expression createExpression(String expression) {
        return ConstantLanguage.constant(expression);
    }

    @Override
    public Predicate createPredicate(String expression, Object[] properties) {
        Expression exp = this.createExpression(expression, properties);
        return ExpressionToPredicateAdapter.toPredicate(exp);
    }

    @Override
    public Expression createExpression(String expression, Object[] properties) {
        Class resultType = this.property(Class.class, properties, 0, null);
        if (resultType != null) {
            try {
                Object value = this.getCamelContext().getTypeConverter().mandatoryConvertTo(resultType, expression);
                return ExpressionBuilder.constantExpression(value);
            }
            catch (NoTypeConversionAvailableException e) {
                throw RuntimeCamelException.wrapRuntimeException(e);
            }
        }
        return ConstantLanguage.constant(expression);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

