/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.Language;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.processor.DefaultExchangeFormatter;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;
import org.apache.camel.util.SkipIterator;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;

public final class SimpleExpressionBuilder {
    private static final Pattern OFFSET_PATTERN = Pattern.compile("([+-])([^+-]+)");

    private SimpleExpressionBuilder() {
    }

    public static Expression headersOgnlExpression(String ognl) {
        return new KeyedOgnlExpressionAdapter(ognl, "headerOgnl(" + ognl + ")", (exchange, exp) -> {
            String text = exp.evaluate(exchange, String.class);
            return exchange.getIn().getHeader(text);
        });
    }

    public static Expression messageHistoryExpression(final boolean detailed) {
        return new ExpressionAdapter(){
            private ExchangeFormatter formatter;

            @Override
            public void init(CamelContext context) {
                if (detailed) {
                    this.formatter = this.getOrCreateExchangeFormatter(context);
                }
            }

            @Override
            public Object evaluate(Exchange exchange) {
                return MessageHelper.dumpMessageHistoryStacktrace(exchange, this.formatter, false);
            }

            private ExchangeFormatter getOrCreateExchangeFormatter(CamelContext camelContext) {
                if (this.formatter == null) {
                    Set<ExchangeFormatter> formatters = camelContext.getRegistry().findByType(ExchangeFormatter.class);
                    if (formatters != null && formatters.size() == 1) {
                        this.formatter = formatters.iterator().next();
                    } else {
                        DefaultExchangeFormatter def = new DefaultExchangeFormatter();
                        def.setShowExchangeId(true);
                        def.setMultiline(true);
                        def.setShowHeaders(true);
                        def.setStyle(DefaultExchangeFormatter.OutputStyle.Fixed);
                        try {
                            Integer maxChars = CamelContextHelper.parseInteger(camelContext, camelContext.getGlobalOption("CamelLogDebugBodyMaxChars"));
                            if (maxChars != null) {
                                def.setMaxChars(maxChars);
                            }
                        }
                        catch (Exception e) {
                            throw RuntimeCamelException.wrapRuntimeCamelException(e);
                        }
                        this.formatter = def;
                    }
                }
                return this.formatter;
            }

            public String toString() {
                return "messageHistory(" + detailed + ")";
            }
        };
    }

    public static Expression collateExpression(final String expression, final int group) {
        return new ExpressionAdapter(){
            private Expression exp;

            @Override
            public void init(CamelContext context) {
                this.exp = context.resolveLanguage("simple").createExpression(expression);
                this.exp.init(context);
                this.exp = ExpressionBuilder.groupIteratorExpression(this.exp, null, "" + group, false);
                this.exp.init(context);
            }

            @Override
            public Object evaluate(Exchange exchange) {
                return this.exp.evaluate(exchange, Object.class);
            }

            public String toString() {
                return "collate(" + expression + "," + group + ")";
            }
        };
    }

    public static Expression skipExpression(final String expression, final int number) {
        return new ExpressionAdapter(){
            private Expression exp;

            @Override
            public void init(CamelContext context) {
                this.exp = context.resolveLanguage("simple").createExpression(expression);
                this.exp.init(context);
            }

            @Override
            public Object evaluate(Exchange exchange) {
                return SimpleExpressionBuilder.skipIteratorExpression(this.exp, number).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "skip(" + expression + "," + number + ")";
            }
        };
    }

    public static Expression randomExpression(final String min, final String max) {
        return new ExpressionAdapter(){
            private Expression exp1;
            private Expression exp2;

            @Override
            public Object evaluate(Exchange exchange) {
                int num1 = this.exp1.evaluate(exchange, Integer.class);
                int num2 = this.exp2.evaluate(exchange, Integer.class);
                Random random = new Random();
                int randomNum = random.nextInt(num2 - num1) + num1;
                return randomNum;
            }

            @Override
            public void init(CamelContext context) {
                this.exp1 = ExpressionBuilder.simpleExpression(min);
                this.exp1.init(context);
                this.exp2 = ExpressionBuilder.simpleExpression(max);
                this.exp2.init(context);
            }

            public String toString() {
                return "random(" + min + "," + max + ")";
            }
        };
    }

    public static Expression randomExpression(int max) {
        return SimpleExpressionBuilder.randomExpression(0, max);
    }

    public static Expression randomExpression(final int min, final int max) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Random random = new Random();
                int randomNum = random.nextInt(max - min) + min;
                return randomNum;
            }

            public String toString() {
                return "random(" + min + "," + max + ")";
            }
        };
    }

    public static Expression fileNameExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileName", String.class);
            }

            public String toString() {
                return "file:name";
            }
        };
    }

    public static Expression fileOnlyNameExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String answer = exchange.getIn().getHeader("CamelFileNameOnly", String.class);
                if (answer == null) {
                    answer = exchange.getIn().getHeader("CamelFileName", String.class);
                    answer = FileUtil.stripPath(answer);
                }
                return answer;
            }

            public String toString() {
                return "file:onlyname";
            }
        };
    }

    public static Expression fileNameNoExtensionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.stripExt(name);
            }

            public String toString() {
                return "file:name.noext";
            }
        };
    }

    public static Expression fileNameNoExtensionSingleExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.stripExt(name, true);
            }

            public String toString() {
                return "file:name.noext.single";
            }
        };
    }

    public static Expression fileOnlyNameNoExtensionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = SimpleExpressionBuilder.fileOnlyNameExpression().evaluate(exchange, String.class);
                return FileUtil.stripExt(name);
            }

            public String toString() {
                return "file:onlyname.noext";
            }
        };
    }

    public static Expression fileOnlyNameNoExtensionSingleExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = SimpleExpressionBuilder.fileOnlyNameExpression().evaluate(exchange, String.class);
                return FileUtil.stripExt(name, true);
            }

            public String toString() {
                return "file:onlyname.noext.single";
            }
        };
    }

    public static Expression fileExtensionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.onlyExt(name);
            }

            public String toString() {
                return "file:ext";
            }
        };
    }

    public static Expression fileExtensionSingleExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.onlyExt(name, true);
            }

            public String toString() {
                return "file:ext.single";
            }
        };
    }

    public static Expression fileParentExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileParent", String.class);
            }

            public String toString() {
                return "file:parent";
            }
        };
    }

    public static Expression filePathExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFilePath", String.class);
            }

            public String toString() {
                return "file:path";
            }
        };
    }

    public static Expression fileAbsolutePathExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileAbsolutePath", String.class);
            }

            public String toString() {
                return "file:absolute.path";
            }
        };
    }

    public static Expression fileAbsoluteExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileAbsolute", Boolean.class);
            }

            public String toString() {
                return "file:absolute";
            }
        };
    }

    public static Expression fileSizeExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileLength", Long.class);
            }

            public String toString() {
                return "file:length";
            }
        };
    }

    public static Expression fileLastModifiedExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileLastModified", Long.class);
            }

            public String toString() {
                return "file:modified";
            }
        };
    }

    public static Expression dateExpression(String command) {
        return SimpleExpressionBuilder.dateExpression(command, null, null);
    }

    public static Expression dateExpression(String command, String pattern) {
        return SimpleExpressionBuilder.dateExpression(command, null, pattern);
    }

    public static Expression dateExpression(final String commandWithOffsets, final String timezone, final String pattern) {
        final String command = commandWithOffsets.split("[+-]", 2)[0].trim();
        final ArrayList<Long> offsets = new ArrayList<Long>();
        Matcher offsetMatcher = OFFSET_PATTERN.matcher(commandWithOffsets);
        while (offsetMatcher.find()) {
            String time = offsetMatcher.group(2).trim();
            long value = TimeUtils.toMilliSeconds(time);
            offsets.add(offsetMatcher.group(1).equals("+") ? value : -value);
        }
        return new ExpressionAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object evaluate(Exchange exchange) {
                Object obj;
                Date date;
                if ("now".equals(command)) {
                    date = new Date();
                } else if ("exchangeCreated".equals(command)) {
                    long num = exchange.getCreated();
                    date = new Date(num);
                } else if (command.startsWith("header.")) {
                    String key = command.substring(command.lastIndexOf(46) + 1);
                    obj = exchange.getMessage().getHeader(key);
                    if (obj instanceof Date) {
                        date = (Date)obj;
                    } else {
                        if (!(obj instanceof Long)) throw new IllegalArgumentException("Cannot find Date/long object at command: " + command);
                        date = new Date((Long)obj);
                    }
                } else if (command.startsWith("exchangeProperty.")) {
                    String key = command.substring(command.lastIndexOf(46) + 1);
                    obj = exchange.getProperty(key);
                    if (obj instanceof Date) {
                        date = (Date)obj;
                    } else {
                        if (!(obj instanceof Long)) throw new IllegalArgumentException("Cannot find Date/long object at command: " + command);
                        date = new Date((Long)obj);
                    }
                } else {
                    if (!"file".equals(command)) throw new IllegalArgumentException("Command not supported for dateExpression: " + command);
                    Long num = exchange.getIn().getHeader("CamelFileLastModified", Long.class);
                    if (num != null && num > 0L) {
                        date = new Date(num);
                    } else {
                        date = exchange.getIn().getHeader("CamelFileLastModified", Date.class);
                        if (date == null) {
                            throw new IllegalArgumentException("Cannot find CamelFileLastModified header at command: " + command);
                        }
                    }
                }
                long dateAsLong = date.getTime();
                Iterator iterator = offsets.iterator();
                while (iterator.hasNext()) {
                    long offset = (Long)iterator.next();
                    dateAsLong += offset;
                }
                date = new Date(dateAsLong);
                if (pattern == null || pattern.isEmpty()) return date;
                SimpleDateFormat df = new SimpleDateFormat(pattern);
                if (timezone == null || timezone.isEmpty()) return df.format(date);
                df.setTimeZone(TimeZone.getTimeZone(timezone));
                return df.format(date);
            }

            public String toString() {
                if (timezone != null && pattern != null) {
                    return "date(" + commandWithOffsets + ":" + timezone + ":" + pattern + ")";
                }
                if (pattern != null) {
                    return "date(" + commandWithOffsets + ":" + pattern + ")";
                }
                return "date(" + commandWithOffsets + ")";
            }
        };
    }

    public static Expression skipIteratorExpression(final Expression expression, final int skip) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Iterator it = expression.evaluate(exchange, Iterator.class);
                ObjectHelper.notNull(it, "expression: " + expression + " evaluated on " + exchange + " must return an java.util.Iterator");
                return new SkipIterator(it, skip);
            }

            public String toString() {
                return "skip " + expression + " " + skip + " times";
            }
        };
    }

    public static Expression nullExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return null;
            }

            public String toString() {
                return "null";
            }
        };
    }

    public static Expression mandatoryBodyOgnlExpression(final String name, final String ognl) {
        return new ExpressionAdapter(){
            private ClassResolver classResolver;
            private Expression exp;
            private Language bean;

            @Override
            public Object evaluate(Exchange exchange) {
                Object body;
                Class<?> type;
                String text = this.exp.evaluate(exchange, String.class);
                try {
                    type = this.classResolver.resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
                try {
                    body = exchange.getIn().getMandatoryBody(type);
                }
                catch (InvalidPayloadException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
                Expression ognlExp = this.bean.createExpression(null, new Object[]{body, ognl});
                ognlExp.init(exchange.getContext());
                return ognlExp.evaluate(exchange, Object.class);
            }

            @Override
            public void init(CamelContext context) {
                this.classResolver = context.getClassResolver();
                this.exp = ExpressionBuilder.simpleExpression(name);
                this.exp.init(context);
                this.bean = context.resolveLanguage("bean");
            }

            public String toString() {
                return "mandatoryBodyAs[" + name + "](" + ognl + ")";
            }
        };
    }

    public static Expression mandatoryBodyExpression(final String name) {
        return new ExpressionAdapter(){
            private ClassResolver classResolver;
            private Expression exp;

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                String text = this.exp.evaluate(exchange, String.class);
                try {
                    type = this.classResolver.resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
                try {
                    return exchange.getIn().getMandatoryBody(type);
                }
                catch (InvalidPayloadException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
            }

            @Override
            public void init(CamelContext context) {
                this.classResolver = context.getClassResolver();
                this.exp = ExpressionBuilder.simpleExpression(name);
                this.exp.init(context);
            }

            public String toString() {
                return "mandatoryBodyAs[" + name + "]";
            }
        };
    }

    public static Expression bodyOgnlExpression(final String name, final String ognl) {
        return new ExpressionAdapter(){
            private ClassResolver classResolver;
            private Expression exp;
            private Language bean;

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                String text = this.exp.evaluate(exchange, String.class);
                try {
                    type = this.classResolver.resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
                Object body = exchange.getIn().getBody(type);
                if (body != null) {
                    Expression ognlExp = this.bean.createExpression(null, new Object[]{body, ognl});
                    ognlExp.init(exchange.getContext());
                    return ognlExp.evaluate(exchange, Object.class);
                }
                return null;
            }

            @Override
            public void init(CamelContext context) {
                this.classResolver = context.getClassResolver();
                this.exp = ExpressionBuilder.simpleExpression(name);
                this.exp.init(context);
                this.bean = context.resolveLanguage("bean");
            }

            public String toString() {
                return "bodyOgnlAs[" + name + "](" + ognl + ")";
            }
        };
    }

    public static Expression exchangeOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){
            private Language bean;

            @Override
            public Object evaluate(Exchange exchange) {
                Expression ognlExp = this.bean.createExpression(null, new Object[]{exchange, ognl});
                ognlExp.init(exchange.getContext());
                return ognlExp.evaluate(exchange, Object.class);
            }

            @Override
            public void init(CamelContext context) {
                this.bean = context.resolveLanguage("bean");
            }

            public String toString() {
                return "exchangeOgnl(" + ognl + ")";
            }
        };
    }

    public static Expression camelContextOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){
            private Expression exp;

            @Override
            public void init(CamelContext context) {
                this.exp = ExpressionBuilder.beanExpression(context, ognl);
                this.exp.init(context);
            }

            @Override
            public Object evaluate(Exchange exchange) {
                return this.exp.evaluate(exchange, Object.class);
            }

            public String toString() {
                return "camelContextOgnl(" + ognl + ")";
            }
        };
    }

    public static Expression bodyOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){
            private Language bean;

            @Override
            public Object evaluate(Exchange exchange) {
                Object body = exchange.getIn().getBody();
                if (body == null) {
                    return null;
                }
                Expression ognlExp = this.bean.createExpression(null, new Object[]{body, ognl});
                ognlExp.init(exchange.getContext());
                return ognlExp.evaluate(exchange, Object.class);
            }

            @Override
            public void init(CamelContext context) {
                this.bean = context.resolveLanguage("bean");
            }

            public String toString() {
                return "bodyOgnl(" + ognl + ")";
            }
        };
    }

    public static Expression cacheExpression(final Expression expression) {
        return new ExpressionAdapter(){
            private final AtomicReference<Object> cache = new AtomicReference();

            @Override
            public Object evaluate(Exchange exchange) {
                Object answer = this.cache.get();
                if (answer == null) {
                    answer = expression.evaluate(exchange, Object.class);
                    this.cache.set(answer);
                }
                return answer;
            }

            public String toString() {
                return expression.toString();
            }
        };
    }

    public static Expression typeExpression(final String name) {
        return new ExpressionAdapter(){
            private ClassResolver classResolver;
            private Expression exp;

            @Override
            public void init(CamelContext context) {
                this.classResolver = context.getClassResolver();
                this.exp = ExpressionBuilder.simpleExpression(name);
                this.exp.init(context);
            }

            @Override
            public Object evaluate(Exchange exchange) {
                String text = this.exp.evaluate(exchange, String.class);
                Class<?> type = this.classResolver.resolveClass(text);
                if (type != null) {
                    return type;
                }
                int pos = text.lastIndexOf(46);
                if (pos > 0) {
                    String before = text.substring(0, pos);
                    String after = text.substring(pos + 1);
                    type = this.classResolver.resolveClass(before);
                    if (type != null) {
                        return ObjectHelper.lookupConstantFieldValue(type, after);
                    }
                }
                throw CamelExecutionException.wrapCamelExecutionException(exchange, new ClassNotFoundException("Cannot find type " + text));
            }

            public String toString() {
                return "type:" + name;
            }
        };
    }

    public static Expression propertyOgnlExpression(String ognl) {
        return new KeyedOgnlExpressionAdapter(ognl, "propertyOgnl(" + ognl + ")", (exchange, exp) -> {
            String text = exp.evaluate(exchange, String.class);
            return exchange.getProperty(text);
        });
    }

    public static Expression exchangeExceptionOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){
            private Language bean;

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class);
                }
                if (exception == null) {
                    return null;
                }
                Expression ognlExp = this.bean.createExpression(null, new Object[]{exception, ognl});
                ognlExp.init(exchange.getContext());
                return ognlExp.evaluate(exchange, Object.class);
            }

            @Override
            public void init(CamelContext context) {
                this.bean = context.resolveLanguage("bean");
            }

            public String toString() {
                return "exchangeExceptionOgnl(" + ognl + ")";
            }
        };
    }

    public static class KeyedOgnlExpressionAdapter
    extends ExpressionAdapter {
        private final String ognl;
        private final String toStringValue;
        private final KeyedEntityRetrievalStrategy keyedEntityRetrievalStrategy;
        private String key;
        private String keySuffix;
        private String method;
        private Expression keyExpression;
        private Expression ognlExpression;
        private Language beanLanguage;

        KeyedOgnlExpressionAdapter(String ognl, String toStringValue, KeyedEntityRetrievalStrategy keyedEntityRetrievalStrategy) {
            this.ognl = ognl;
            this.toStringValue = toStringValue;
            this.keyedEntityRetrievalStrategy = keyedEntityRetrievalStrategy;
            List<String> methods = OgnlHelper.splitOgnl(ognl);
            this.key = methods.get(0);
            this.keySuffix = "";
            if (this.key.startsWith("[") && this.key.endsWith("]")) {
                this.key = StringHelper.removeLeadingAndEndingQuotes(this.key.substring(1, this.key.length() - 1));
                this.keySuffix = StringHelper.after(methods.get(0), this.key);
            }
            this.key = OgnlHelper.removeOperators(this.key);
            this.method = StringHelper.after(ognl, this.key + this.keySuffix);
        }

        @Override
        public void init(CamelContext context) {
            this.beanLanguage = context.resolveLanguage("bean");
            this.ognlExpression = ExpressionBuilder.simpleExpression(this.ognl);
            this.ognlExpression.init(context);
        }

        @Override
        public Object evaluate(Exchange exchange) {
            Object property = this.keyedEntityRetrievalStrategy.getKeyedEntity(exchange, this.ognlExpression);
            if (property != null) {
                return property;
            }
            if (this.keyExpression == null) {
                this.keyExpression = ExpressionBuilder.simpleExpression(this.key);
                this.keyExpression.init(exchange.getContext());
            }
            if ((property = this.keyedEntityRetrievalStrategy.getKeyedEntity(exchange, this.keyExpression)) == null) {
                return null;
            }
            if (this.method != null) {
                Expression exp = this.beanLanguage.createExpression(null, new Object[]{property, this.method});
                exp.init(exchange.getContext());
                return exp.evaluate(exchange, Object.class);
            }
            return property;
        }

        public String toString() {
            return this.toStringValue;
        }

        public static interface KeyedEntityRetrievalStrategy {
            public Object getKeyedEntity(Exchange var1, Expression var2);
        }
    }
}

