/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.ast;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.language.simple.SimpleExpressionBuilder;
import org.apache.camel.language.simple.ast.LiteralExpression;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.spi.Language;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public class SimpleFunctionExpression
extends LiteralExpression {
    private Map<String, Expression> cacheExpression;

    public SimpleFunctionExpression(SimpleToken token, Map<String, Expression> cacheExpression) {
        super(token);
        this.cacheExpression = cacheExpression;
    }

    @Override
    public Expression createExpression(CamelContext camelContext, String expression) {
        Expression answer;
        String function = this.text.toString();
        Expression expression2 = answer = this.cacheExpression != null ? this.cacheExpression.get(function) : null;
        if (answer == null) {
            answer = this.createSimpleExpression(camelContext, function, true);
            if (answer != null) {
                answer.init(camelContext);
            }
            if (this.cacheExpression != null && answer != null) {
                this.cacheExpression.put(function, answer);
            }
        }
        return answer;
    }

    private Expression createSimpleExpression(CamelContext camelContext, String function, boolean strict) {
        String[] parts;
        Expression fileExpression;
        Expression answer = this.createSimpleExpressionDirectly(camelContext, function);
        if (answer != null) {
            return answer;
        }
        answer = this.createSimpleExpressionBodyOrHeader(function, strict);
        if (answer != null) {
            return answer;
        }
        String remainder = this.ifStartsWithReturnRemainder("camelContext", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${camelContext.OGNL} was: " + function, this.token.getIndex());
            }
            return SimpleExpressionBuilder.camelContextOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("exception", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${exception.OGNL} was: " + function, this.token.getIndex());
            }
            return SimpleExpressionBuilder.exchangeExceptionOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("exchangeProperty", function);
        if (remainder != null) {
            boolean invalid;
            if (remainder.startsWith(".") || remainder.startsWith("?")) {
                remainder = remainder.substring(1);
            }
            if (remainder.startsWith("[") && remainder.endsWith("]")) {
                remainder = remainder.substring(1, remainder.length() - 1);
            }
            if (invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder)) {
                throw new SimpleParserException("Valid syntax: ${exchangeProperty.OGNL} was: " + function, this.token.getIndex());
            }
            if (OgnlHelper.isValidOgnlExpression(remainder)) {
                return SimpleExpressionBuilder.propertyOgnlExpression(remainder);
            }
            return ExpressionBuilder.exchangePropertyExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("sys.", function);
        if (remainder != null) {
            return ExpressionBuilder.systemPropertyExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("sysenv.", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("sysenv:", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("env.", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("env:", function);
        }
        if (remainder != null) {
            return ExpressionBuilder.systemEnvironmentExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("exchange", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${exchange.OGNL} was: " + function, this.token.getIndex());
            }
            return SimpleExpressionBuilder.exchangeOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("file:", function);
        if (remainder != null && (fileExpression = this.createSimpleFileExpression(remainder, strict)) != null) {
            return fileExpression;
        }
        remainder = this.ifStartsWithReturnRemainder("date:", function);
        if (remainder != null) {
            parts = remainder.split(":", 2);
            if (parts.length == 1) {
                return SimpleExpressionBuilder.dateExpression(parts[0]);
            }
            if (parts.length == 2) {
                return SimpleExpressionBuilder.dateExpression(parts[0], parts[1]);
            }
        }
        if ((remainder = this.ifStartsWithReturnRemainder("date-with-timezone:", function)) != null) {
            parts = remainder.split(":", 3);
            if (parts.length < 3) {
                throw new SimpleParserException("Valid syntax: ${date-with-timezone:command:timezone:pattern} was: " + function, this.token.getIndex());
            }
            return SimpleExpressionBuilder.dateExpression(parts[0], parts[1], parts[2]);
        }
        remainder = this.ifStartsWithReturnRemainder("bean:", function);
        if (remainder != null) {
            Language bean = camelContext.resolveLanguage("bean");
            String ref = remainder;
            Object method = null;
            Object scope = null;
            if (remainder.contains("?method=") || remainder.contains("?scope=")) {
                ref = StringHelper.before(remainder, "?");
                String query = StringHelper.after(remainder, "?");
                try {
                    Map<String, Object> map = URISupport.parseQuery(query);
                    method = map.get("method");
                    scope = map.get("scope");
                }
                catch (URISyntaxException e) {
                    throw RuntimeCamelException.wrapRuntimeException(e);
                }
            } else {
                int doubleColonIndex = remainder.indexOf("::");
                int beginOfParameterDeclaration = remainder.indexOf(40);
                if (!(doubleColonIndex <= 0 || remainder.contains("(") && doubleColonIndex >= beginOfParameterDeclaration)) {
                    ref = remainder.substring(0, doubleColonIndex);
                    method = remainder.substring(doubleColonIndex + 2);
                } else {
                    int idx = remainder.indexOf(46);
                    if (idx > 0) {
                        ref = remainder.substring(0, idx);
                        method = remainder.substring(idx + 1);
                    }
                }
            }
            Class<?> type = null;
            if (ref != null && ref.startsWith("type:")) {
                try {
                    type = camelContext.getClassResolver().resolveMandatoryClass(ref.substring(5));
                    ref = null;
                }
                catch (ClassNotFoundException e) {
                    throw RuntimeCamelException.wrapRuntimeException(e);
                }
            }
            Object[] properties = new Object[5];
            properties[2] = type;
            properties[3] = ref;
            properties[1] = method;
            properties[4] = scope;
            return bean.createExpression(null, properties);
        }
        remainder = this.ifStartsWithReturnRemainder("properties:", function);
        if (remainder != null) {
            parts = remainder.split(":", 2);
            if (parts.length > 2) {
                throw new SimpleParserException("Valid syntax: ${properties:key[:default]} was: " + function, this.token.getIndex());
            }
            String defaultValue = null;
            if (parts.length >= 2) {
                defaultValue = parts[1];
            }
            String key = parts[0];
            return ExpressionBuilder.propertiesComponentExpression(key, defaultValue);
        }
        remainder = this.ifStartsWithReturnRemainder("ref:", function);
        if (remainder != null) {
            return ExpressionBuilder.refExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("type:", function);
        if (remainder != null) {
            Expression exp = SimpleExpressionBuilder.typeExpression(remainder);
            exp.init(camelContext);
            return SimpleExpressionBuilder.cacheExpression(exp);
        }
        Expression misc = this.createSimpleExpressionMisc(function);
        if (misc != null) {
            return misc;
        }
        if (strict) {
            throw new SimpleParserException("Unknown function: " + function, this.token.getIndex());
        }
        return null;
    }

    private Expression createSimpleExpressionBodyOrHeader(String function, boolean strict) {
        String remainder = this.ifStartsWithReturnRemainder("bodyAs(", function);
        if (remainder != null) {
            String type = StringHelper.before(remainder, ")");
            if (type == null) {
                throw new SimpleParserException("Valid syntax: ${bodyAs(type)} was: " + function, this.token.getIndex());
            }
            type = StringHelper.removeQuotes(type);
            if (ObjectHelper.isNotEmpty(remainder = StringHelper.after(remainder, ")"))) {
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${bodyAs(type).OGNL} was: " + function, this.token.getIndex());
                }
                return SimpleExpressionBuilder.bodyOgnlExpression(type, remainder);
            }
            return ExpressionBuilder.bodyExpression(type);
        }
        remainder = this.ifStartsWithReturnRemainder("mandatoryBodyAs(", function);
        if (remainder != null) {
            String type = StringHelper.before(remainder, ")");
            if (type == null) {
                throw new SimpleParserException("Valid syntax: ${mandatoryBodyAs(type)} was: " + function, this.token.getIndex());
            }
            type = StringHelper.removeQuotes(type);
            if (ObjectHelper.isNotEmpty(remainder = StringHelper.after(remainder, ")"))) {
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${mandatoryBodyAs(type).OGNL} was: " + function, this.token.getIndex());
                }
                return SimpleExpressionBuilder.mandatoryBodyOgnlExpression(type, remainder);
            }
            return SimpleExpressionBuilder.mandatoryBodyExpression(type);
        }
        remainder = this.ifStartsWithReturnRemainder("body", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.body", function);
        }
        if (remainder != null) {
            boolean invalid;
            boolean ognlStart = remainder.startsWith(".") || remainder.startsWith("?") || remainder.startsWith("[");
            boolean bl = invalid = !ognlStart || OgnlHelper.isInvalidValidOgnlExpression(remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${body.OGNL} was: " + function, this.token.getIndex());
            }
            return SimpleExpressionBuilder.bodyOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("headerAs(", function);
        if (remainder != null) {
            String keyAndType = StringHelper.before(remainder, ")");
            if (keyAndType == null) {
                throw new SimpleParserException("Valid syntax: ${headerAs(key, type)} was: " + function, this.token.getIndex());
            }
            String key = StringHelper.before(keyAndType, ",");
            String type = StringHelper.after(keyAndType, ",");
            remainder = StringHelper.after(remainder, ")");
            if (ObjectHelper.isEmpty(key) || ObjectHelper.isEmpty(type) || ObjectHelper.isNotEmpty(remainder)) {
                throw new SimpleParserException("Valid syntax: ${headerAs(key, type)} was: " + function, this.token.getIndex());
            }
            key = StringHelper.removeQuotes(key);
            type = StringHelper.removeQuotes(type);
            return ExpressionBuilder.headerExpression(key, type);
        }
        if ("in.headers".equals(function) || "headers".equals(function)) {
            return ExpressionBuilder.headersExpression();
        }
        remainder = this.ifStartsWithReturnRemainder("in.headers", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.header", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("headers", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("header", function);
        }
        if (remainder != null) {
            String key;
            boolean invalid;
            if (remainder.startsWith(".") || remainder.startsWith(":") || remainder.startsWith("?")) {
                remainder = remainder.substring(1);
            }
            if (remainder.startsWith("[") && remainder.endsWith("]")) {
                remainder = remainder.substring(1, remainder.length() - 1);
            }
            if (invalid = OgnlHelper.isInvalidValidOgnlExpression(key = StringHelper.removeLeadingAndEndingQuotes(remainder))) {
                throw new SimpleParserException("Valid syntax: ${header.name[key]} was: " + function, this.token.getIndex());
            }
            if (OgnlHelper.isValidOgnlExpression(key)) {
                return SimpleExpressionBuilder.headersOgnlExpression(key);
            }
            return ExpressionBuilder.headerExpression(key);
        }
        return null;
    }

    private Expression createSimpleExpressionDirectly(CamelContext camelContext, String expression) {
        if (ObjectHelper.isEqualToAny(expression, "body", "in.body")) {
            return ExpressionBuilder.bodyExpression();
        }
        if (ObjectHelper.equal(expression, "bodyOneLine")) {
            return ExpressionBuilder.bodyOneLine();
        }
        if (ObjectHelper.equal(expression, "id")) {
            return ExpressionBuilder.messageIdExpression();
        }
        if (ObjectHelper.equal(expression, "messageTimestamp")) {
            return ExpressionBuilder.messageTimestampExpression();
        }
        if (ObjectHelper.equal(expression, "exchangeId")) {
            return ExpressionBuilder.exchangeIdExpression();
        }
        if (ObjectHelper.equal(expression, "exchange")) {
            return ExpressionBuilder.exchangeExpression();
        }
        if (ObjectHelper.equal(expression, "exception")) {
            return ExpressionBuilder.exchangeExceptionExpression();
        }
        if (ObjectHelper.equal(expression, "exception.message")) {
            return ExpressionBuilder.exchangeExceptionMessageExpression();
        }
        if (ObjectHelper.equal(expression, "exception.stacktrace")) {
            return ExpressionBuilder.exchangeExceptionStackTraceExpression();
        }
        if (ObjectHelper.equal(expression, "threadName")) {
            return ExpressionBuilder.threadNameExpression();
        }
        if (ObjectHelper.equal(expression, "hostname")) {
            return ExpressionBuilder.hostnameExpression();
        }
        if (ObjectHelper.equal(expression, "camelId")) {
            return ExpressionBuilder.camelContextNameExpression();
        }
        if (ObjectHelper.equal(expression, "routeId")) {
            return ExpressionBuilder.routeIdExpression();
        }
        if (ObjectHelper.equal(expression, "stepId")) {
            return ExpressionBuilder.stepIdExpression();
        }
        if (ObjectHelper.equal(expression, "null")) {
            return SimpleExpressionBuilder.nullExpression();
        }
        return null;
    }

    private Expression createSimpleFileExpression(String remainder, boolean strict) {
        if (ObjectHelper.equal(remainder, "name")) {
            return SimpleExpressionBuilder.fileNameExpression();
        }
        if (ObjectHelper.equal(remainder, "name.noext")) {
            return SimpleExpressionBuilder.fileNameNoExtensionExpression();
        }
        if (ObjectHelper.equal(remainder, "name.noext.single")) {
            return SimpleExpressionBuilder.fileNameNoExtensionSingleExpression();
        }
        if (ObjectHelper.equal(remainder, "name.ext") || ObjectHelper.equal(remainder, "ext")) {
            return SimpleExpressionBuilder.fileExtensionExpression();
        }
        if (ObjectHelper.equal(remainder, "name.ext.single")) {
            return SimpleExpressionBuilder.fileExtensionSingleExpression();
        }
        if (ObjectHelper.equal(remainder, "onlyname")) {
            return SimpleExpressionBuilder.fileOnlyNameExpression();
        }
        if (ObjectHelper.equal(remainder, "onlyname.noext")) {
            return SimpleExpressionBuilder.fileOnlyNameNoExtensionExpression();
        }
        if (ObjectHelper.equal(remainder, "onlyname.noext.single")) {
            return SimpleExpressionBuilder.fileOnlyNameNoExtensionSingleExpression();
        }
        if (ObjectHelper.equal(remainder, "parent")) {
            return SimpleExpressionBuilder.fileParentExpression();
        }
        if (ObjectHelper.equal(remainder, "path")) {
            return SimpleExpressionBuilder.filePathExpression();
        }
        if (ObjectHelper.equal(remainder, "absolute")) {
            return SimpleExpressionBuilder.fileAbsoluteExpression();
        }
        if (ObjectHelper.equal(remainder, "absolute.path")) {
            return SimpleExpressionBuilder.fileAbsolutePathExpression();
        }
        if (ObjectHelper.equal(remainder, "length") || ObjectHelper.equal(remainder, "size")) {
            return SimpleExpressionBuilder.fileSizeExpression();
        }
        if (ObjectHelper.equal(remainder, "modified")) {
            return SimpleExpressionBuilder.fileLastModifiedExpression();
        }
        if (strict) {
            throw new SimpleParserException("Unknown file language syntax: " + remainder, this.token.getIndex());
        }
        return null;
    }

    private Expression createSimpleExpressionMisc(String function) {
        String remainder = this.ifStartsWithReturnRemainder("random(", function);
        if (remainder != null) {
            String values = StringHelper.before(remainder, ")");
            if (values == null || ObjectHelper.isEmpty(values)) {
                throw new SimpleParserException("Valid syntax: ${random(min,max)} or ${random(max)} was: " + function, this.token.getIndex());
            }
            if (values.contains(",")) {
                String[] tokens = values.split(",", 3);
                if (tokens.length > 2) {
                    throw new SimpleParserException("Valid syntax: ${random(min,max)} or ${random(max)} was: " + function, this.token.getIndex());
                }
                return SimpleExpressionBuilder.randomExpression(tokens[0].trim(), tokens[1].trim());
            }
            return SimpleExpressionBuilder.randomExpression("0", values.trim());
        }
        remainder = this.ifStartsWithReturnRemainder("skip(", function);
        if (remainder != null) {
            String values = StringHelper.before(remainder, ")");
            if (values == null || ObjectHelper.isEmpty(values)) {
                throw new SimpleParserException("Valid syntax: ${skip(number)} was: " + function, this.token.getIndex());
            }
            String exp = "${body}";
            int num = Integer.parseInt(values.trim());
            return SimpleExpressionBuilder.skipExpression(exp, num);
        }
        remainder = this.ifStartsWithReturnRemainder("collate(", function);
        if (remainder != null) {
            String values = StringHelper.before(remainder, ")");
            if (values == null || ObjectHelper.isEmpty(values)) {
                throw new SimpleParserException("Valid syntax: ${collate(group)} was: " + function, this.token.getIndex());
            }
            String exp = "${body}";
            int num = Integer.parseInt(values.trim());
            return SimpleExpressionBuilder.collateExpression(exp, num);
        }
        remainder = this.ifStartsWithReturnRemainder("messageHistory", function);
        if (remainder != null) {
            String values = StringHelper.between(remainder, "(", ")");
            boolean detailed = values == null || ObjectHelper.isEmpty(values) ? true : Boolean.parseBoolean(values);
            return SimpleExpressionBuilder.messageHistoryExpression(detailed);
        }
        if (ObjectHelper.equal(function, "messageHistory")) {
            return SimpleExpressionBuilder.messageHistoryExpression(true);
        }
        return null;
    }

    private String ifStartsWithReturnRemainder(String prefix, String text) {
        String remainder;
        if (text.startsWith(prefix) && (remainder = text.substring(prefix.length())).length() > 0) {
            return remainder;
        }
        return null;
    }

    @Override
    public String createCode(String expression) throws SimpleParserException {
        String[] parts;
        String function = this.getText();
        String answer = this.createCodeDirectly(function);
        if (answer != null) {
            return answer;
        }
        answer = this.createCodeBody(function);
        if (answer != null) {
            return answer;
        }
        answer = this.createCodeHeader(function);
        if (answer != null) {
            return answer;
        }
        answer = this.createCodeExchangeProperty(function);
        if (answer != null) {
            return answer;
        }
        String remainder = this.ifStartsWithReturnRemainder("camelContext", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${camelContext.OGNL} was: " + function, this.token.getIndex());
            }
            return "context" + SimpleFunctionExpression.ognlCodeMethods(remainder, null);
        }
        remainder = this.ifStartsWithReturnRemainder("exceptionAs(", function);
        if (remainder != null) {
            String type = StringHelper.before(remainder, ")");
            remainder = StringHelper.after(remainder, ")");
            if (!(type = StringHelper.removeQuotes(type)).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            type = type.trim();
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
            if (type.isEmpty() || invalid) {
                throw new SimpleParserException("Valid syntax: ${exceptionAs(type).OGNL} was: " + function, this.token.getIndex());
            }
            return "exceptionAs(exchange, " + type + ")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
        }
        remainder = this.ifStartsWithReturnRemainder("exception", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${exceptionAs(type).OGNL} was: " + function, this.token.getIndex());
            }
            return "exception(exchange)" + SimpleFunctionExpression.ognlCodeMethods(remainder, null);
        }
        remainder = this.ifStartsWithReturnRemainder("sys.", function);
        if (remainder != null) {
            return "sys(\"" + remainder + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("sysenv.", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("sysenv:", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("env.", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("env:", function);
        }
        if (remainder != null) {
            return "sysenv(\"" + remainder + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("exchange", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${exchange.OGNL} was: " + function, this.token.getIndex());
            }
            return "exchange" + SimpleFunctionExpression.ognlCodeMethods(remainder, null);
        }
        remainder = this.ifStartsWithReturnRemainder("file:", function);
        if (remainder != null) {
            return this.createCodeFileExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("date:", function);
        if (remainder != null) {
            parts = remainder.split(":", 2);
            if (parts.length == 1) {
                return "date(exchange, \"" + parts[0] + "\")";
            }
            if (parts.length == 2) {
                return "date(exchange, \"" + parts[0] + "\", null, \"" + parts[1] + "\")";
            }
        }
        if ((remainder = this.ifStartsWithReturnRemainder("date-with-timezone:", function)) != null) {
            parts = remainder.split(":", 3);
            if (parts.length < 3) {
                throw new SimpleParserException("Valid syntax: ${date-with-timezone:command:timezone:pattern} was: " + function, this.token.getIndex());
            }
            return "date(exchange, \"" + parts[0] + "\", \"" + parts[1] + "\", \"" + parts[2] + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("bean:", function);
        if (remainder != null) {
            String ref = remainder;
            Object method = null;
            Object scope = null;
            if (remainder.contains("?method=") || remainder.contains("?scope=")) {
                ref = StringHelper.before(remainder, "?");
                String query = StringHelper.after(remainder, "?");
                try {
                    Map<String, Object> map = URISupport.parseQuery(query);
                    method = map.get("method");
                    scope = map.get("scope");
                }
                catch (URISyntaxException e) {
                    throw RuntimeCamelException.wrapRuntimeException(e);
                }
            } else {
                int doubleColonIndex = remainder.indexOf("::");
                int beginOfParameterDeclaration = remainder.indexOf(40);
                if (!(doubleColonIndex <= 0 || remainder.contains("(") && doubleColonIndex >= beginOfParameterDeclaration)) {
                    ref = remainder.substring(0, doubleColonIndex);
                    method = remainder.substring(doubleColonIndex + 2);
                } else {
                    int idx = remainder.indexOf(46);
                    if (idx > 0) {
                        ref = remainder.substring(0, idx);
                        method = remainder.substring(idx + 1);
                    }
                }
            }
            ref = ref.trim();
            if (method != null && scope != null) {
                return "bean(exchange, bean, \"" + ref + "\", \"" + method.toString() + "\", \"" + scope.toString() + "\")";
            }
            if (method != null) {
                return "bean(exchange, bean, \"" + ref + "\", \"" + method.toString() + "\", null)";
            }
            return "bean(exchange, bean, \"" + ref + "\", null, null)";
        }
        remainder = this.ifStartsWithReturnRemainder("properties:", function);
        if (remainder != null) {
            parts = remainder.split(":", 2);
            if (parts.length > 2) {
                throw new SimpleParserException("Valid syntax: ${properties:key[:default]} was: " + function, this.token.getIndex());
            }
            String defaultValue = null;
            if (parts.length >= 2) {
                defaultValue = parts[1];
            }
            String key = parts[0];
            key = key.trim();
            if (defaultValue != null) {
                return "properties(exchange, \"" + key + "\", \"" + defaultValue.trim() + "\")";
            }
            return "properties(exchange, \"" + key + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("ref:", function);
        if (remainder != null) {
            return "ref(exchange, \"" + remainder + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("type:", function);
        if (remainder != null) {
            String field;
            int pos = remainder.lastIndexOf(46);
            String type = pos != -1 ? remainder.substring(0, pos) : remainder;
            String string = field = pos != -1 ? remainder.substring(pos + 1) : null;
            if (!type.endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            if (field != null) {
                return "type(exchange, " + type + ", \"" + field + "\")";
            }
            return "type(exchange, " + type + ")";
        }
        String misc = this.createCodeExpressionMisc(function);
        if (misc != null) {
            return misc;
        }
        throw new SimpleParserException("Unknown function: " + function, this.token.getIndex());
    }

    public String createCodeDirectly(String expression) throws SimpleParserException {
        if (ObjectHelper.isEqualToAny(expression, "body", "in.body")) {
            return "body";
        }
        if (ObjectHelper.equal(expression, "bodyOneLine")) {
            return "bodyOneLine(exchange)";
        }
        if (ObjectHelper.equal(expression, "id")) {
            return "message.getMessageId()";
        }
        if (ObjectHelper.equal(expression, "messageTimestamp")) {
            return "message.getMessageTimestamp()";
        }
        if (ObjectHelper.equal(expression, "exchangeId")) {
            return "exchange.getExchangeId()";
        }
        if (ObjectHelper.equal(expression, "exchange")) {
            return "exchange";
        }
        if (ObjectHelper.equal(expression, "exception")) {
            return "exception(exchange)";
        }
        if (ObjectHelper.equal(expression, "exception.message")) {
            return "exceptionMessage(exchange)";
        }
        if (ObjectHelper.equal(expression, "exception.stacktrace")) {
            return "exceptionStacktrace(exchange)";
        }
        if (ObjectHelper.equal(expression, "threadName")) {
            return "threadName()";
        }
        if (ObjectHelper.equal(expression, "hostname")) {
            return "hostName()";
        }
        if (ObjectHelper.equal(expression, "camelId")) {
            return "context.getName()";
        }
        if (ObjectHelper.equal(expression, "routeId")) {
            return "routeId(exchange)";
        }
        if (ObjectHelper.equal(expression, "stepId")) {
            return "stepId(exchange)";
        }
        if (ObjectHelper.equal(expression, "null")) {
            return "null";
        }
        return null;
    }

    private String createCodeBody(String function) {
        String remainder = this.ifStartsWithReturnRemainder("bodyAsIndex(", function);
        if (remainder != null) {
            String typeAndIndex = StringHelper.before(remainder, ")");
            if (typeAndIndex == null) {
                throw new SimpleParserException("Valid syntax: ${bodyAsIndex(type, index).OGNL} was: " + function, this.token.getIndex());
            }
            String type = StringHelper.before(typeAndIndex, ",");
            String index = StringHelper.after(typeAndIndex, ",");
            remainder = StringHelper.after(remainder, ")");
            if (ObjectHelper.isEmpty(type) || ObjectHelper.isEmpty(index)) {
                throw new SimpleParserException("Valid syntax: ${bodyAsIndex(type, index).OGNL} was: " + function, this.token.getIndex());
            }
            type = StringHelper.removeQuotes(type);
            if (!(type = type.trim()).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            index = StringHelper.removeQuotes(index);
            index = index.trim();
            if (ObjectHelper.isNotEmpty(remainder)) {
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${bodyAsIndex(type, index).OGNL} was: " + function, this.token.getIndex());
                }
                return "bodyAsIndex(message, " + type + ", \"" + index + "\")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
            }
            return "bodyAsIndex(message, " + type + ", \"" + index + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("bodyAs(", function);
        if (remainder != null) {
            String type = StringHelper.before(remainder, ")");
            if (type == null) {
                throw new SimpleParserException("Valid syntax: ${bodyAs(type)} was: " + function, this.token.getIndex());
            }
            if (!(type = StringHelper.removeQuotes(type)).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            type = type.trim();
            if (ObjectHelper.isNotEmpty(remainder = StringHelper.after(remainder, ")"))) {
                List<String> parts;
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${bodyAs(type).OGNL} was: " + function, this.token.getIndex());
                }
                if (remainder.startsWith("[") && !(parts = SimpleFunctionExpression.splitOgnl(remainder)).isEmpty()) {
                    String func = "bodyAsIndex(" + type + ", \"" + parts.remove(0) + "\")";
                    String last = String.join((CharSequence)"", parts);
                    if (!last.isEmpty()) {
                        func = func + "." + last;
                    }
                    return this.createCodeBody(func);
                }
                return "bodyAs(message, " + type + ")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
            }
            return "bodyAs(message, " + type + ")";
        }
        remainder = this.ifStartsWithReturnRemainder("mandatoryBodyAsIndex(", function);
        if (remainder != null) {
            String typeAndIndex = StringHelper.before(remainder, ")");
            if (typeAndIndex == null) {
                throw new SimpleParserException("Valid syntax: ${mandatoryBodyAsIndex(type, index).OGNL} was: " + function, this.token.getIndex());
            }
            String type = StringHelper.before(typeAndIndex, ",");
            String index = StringHelper.after(typeAndIndex, ",");
            remainder = StringHelper.after(remainder, ")");
            if (ObjectHelper.isEmpty(type) || ObjectHelper.isEmpty(index)) {
                throw new SimpleParserException("Valid syntax: ${mandatoryBodyAsIndex(type, index).OGNL} was: " + function, this.token.getIndex());
            }
            type = StringHelper.removeQuotes(type);
            if (!(type = type.trim()).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            index = StringHelper.removeQuotes(index);
            index = index.trim();
            if (ObjectHelper.isNotEmpty(remainder)) {
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${mandatoryBodyAsIndex(type, index).OGNL} was: " + function, this.token.getIndex());
                }
                return "mandatoryBodyAsIndex(message, " + type + ", \"" + index + "\")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
            }
            return "mandatoryBodyAsIndex(message, " + type + ", \"" + index + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("mandatoryBodyAs(", function);
        if (remainder != null) {
            String type = StringHelper.before(remainder, ")");
            if (type == null) {
                throw new SimpleParserException("Valid syntax: ${mandatoryBodyAs(type)} was: " + function, this.token.getIndex());
            }
            if (!(type = StringHelper.removeQuotes(type)).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            type = type.trim();
            if (ObjectHelper.isNotEmpty(remainder = StringHelper.after(remainder, ")"))) {
                List<String> parts;
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${mandatoryBodyAs(type).OGNL} was: " + function, this.token.getIndex());
                }
                if (remainder.startsWith("[") && !(parts = SimpleFunctionExpression.splitOgnl(remainder)).isEmpty()) {
                    String func = "mandatoryBodyAsIndex(" + type + ", \"" + parts.remove(0) + "\")";
                    String last = String.join((CharSequence)"", parts);
                    if (!last.isEmpty()) {
                        func = func + "." + last;
                    }
                    return this.createCodeBody(func);
                }
                return "mandatoryBodyAs(message, " + type + ")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
            }
            return "mandatoryBodyAs(message, " + type + ")";
        }
        remainder = this.ifStartsWithReturnRemainder("body", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.body", function);
        }
        if (remainder != null) {
            List<String> parts;
            boolean invalid;
            boolean ognlStart = remainder.startsWith(".") || remainder.startsWith("?") || remainder.startsWith("[");
            boolean bl = invalid = !ognlStart || OgnlHelper.isInvalidValidOgnlExpression(remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${body.OGNL} was: " + function, this.token.getIndex());
            }
            if (remainder.startsWith("[") && !(parts = SimpleFunctionExpression.splitOgnl(remainder)).isEmpty()) {
                String func = "bodyAsIndex(Object.class, \"" + parts.remove(0) + "\")";
                String last = String.join((CharSequence)"", parts);
                if (!last.isEmpty()) {
                    func = func + "." + last;
                }
                return this.createCodeBody(func);
            }
            return "body" + SimpleFunctionExpression.ognlCodeMethods(remainder, null);
        }
        return null;
    }

    private String createCodeHeader(String function) {
        String remainder = this.ifStartsWithReturnRemainder("headerAsIndex(", function);
        if (remainder != null) {
            String keyTypeAndIndex = StringHelper.before(remainder, ")");
            if (keyTypeAndIndex == null) {
                throw new SimpleParserException("Valid syntax: ${headerAsIndex(key, type, index)} was: " + function, this.token.getIndex());
            }
            String[] parts = keyTypeAndIndex.split(",");
            if (parts.length != 3) {
                throw new SimpleParserException("Valid syntax: ${headerAsIndex(key, type, index)} was: " + function, this.token.getIndex());
            }
            String key = parts[0];
            String type = parts[1];
            String index = parts[2];
            if (ObjectHelper.isEmpty(key) || ObjectHelper.isEmpty(type) || ObjectHelper.isEmpty(index)) {
                throw new SimpleParserException("Valid syntax: ${headerAsIndex(key, type, index)} was: " + function, this.token.getIndex());
            }
            key = StringHelper.removeQuotes(key);
            key = key.trim();
            if (!(type = StringHelper.removeQuotes(type)).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            type = type.trim();
            index = StringHelper.removeQuotes(index);
            index = index.trim();
            if (ObjectHelper.isNotEmpty(remainder = StringHelper.after(remainder, ")"))) {
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${headerAsIndex(key, type, index).OGNL} was: " + function, this.token.getIndex());
                }
                return "headerAsIndex(message, " + type + ", \"" + key + "\", \"" + index + "\")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
            }
            return "headerAsIndex(message, " + type + ", \"" + key + "\", \"" + index + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("headerAs(", function);
        if (remainder != null) {
            String keyAndType = StringHelper.before(remainder, ")");
            if (keyAndType == null) {
                throw new SimpleParserException("Valid syntax: ${headerAs(key, type)} was: " + function, this.token.getIndex());
            }
            String key = StringHelper.before(keyAndType, ",");
            String type = StringHelper.after(keyAndType, ",");
            remainder = StringHelper.after(remainder, ")");
            if (ObjectHelper.isEmpty(key) || ObjectHelper.isEmpty(type)) {
                throw new SimpleParserException("Valid syntax: ${headerAs(key, type)} was: " + function, this.token.getIndex());
            }
            key = StringHelper.removeQuotes(key);
            key = key.trim();
            if (!(type = StringHelper.removeQuotes(type)).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            type = type.trim();
            return "headerAs(message, \"" + key + "\", " + type + ")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
        }
        if ("in.headers".equals(function) || "headers".equals(function)) {
            return "message.getHeaders()";
        }
        remainder = this.ifStartsWithReturnRemainder("in.headers", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.header", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("headers", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("header", function);
        }
        if (remainder != null) {
            String s;
            int pos;
            if (remainder.startsWith(".") || remainder.startsWith(":") || remainder.startsWith("?")) {
                remainder = remainder.substring(1);
            }
            if (remainder.startsWith("[") && remainder.endsWith("]")) {
                remainder = remainder.substring(1, remainder.length() - 1);
            }
            String key = StringHelper.removeLeadingAndEndingQuotes(remainder);
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(key = key.trim());
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${header.name[key]} was: " + function, this.token.getIndex());
            }
            boolean index = false;
            List<String> parts = SimpleFunctionExpression.splitOgnl(key);
            if (!parts.isEmpty() && (pos = (s = parts.get(0)).indexOf(91)) != -1) {
                index = true;
                String before = s.substring(0, pos);
                String after = s.substring(pos);
                parts.set(0, before);
                parts.add(1, after);
            }
            if (index) {
                String last;
                String func = "headerAsIndex(\"" + parts.get(0) + "\", Object.class, \"" + parts.get(1) + "\")";
                if (parts.size() > 2 && !(last = String.join((CharSequence)"", parts.subList(2, parts.size()))).isEmpty()) {
                    func = func + "." + last;
                }
                return this.createCodeHeader(func);
            }
            if (OgnlHelper.isValidOgnlExpression(key)) {
                throw new SimpleParserException("Valid syntax: ${headerAs(key, type).OGNL} was: " + function, this.token.getIndex());
            }
            return "header(message, \"" + key + "\")";
        }
        return null;
    }

    private String createCodeExchangeProperty(String function) {
        String remainder = this.ifStartsWithReturnRemainder("exchangePropertyAsIndex(", function);
        if (remainder != null) {
            String keyTypeAndIndex = StringHelper.before(remainder, ")");
            if (keyTypeAndIndex == null) {
                throw new SimpleParserException("Valid syntax: ${exchangePropertyAsIndex(key, type, index)} was: " + function, this.token.getIndex());
            }
            String[] parts = keyTypeAndIndex.split(",");
            if (parts.length != 3) {
                throw new SimpleParserException("Valid syntax: ${exchangePropertyAsIndex(key, type, index)} was: " + function, this.token.getIndex());
            }
            String key = parts[0];
            String type = parts[1];
            String index = parts[2];
            if (ObjectHelper.isEmpty(key) || ObjectHelper.isEmpty(type) || ObjectHelper.isEmpty(index)) {
                throw new SimpleParserException("Valid syntax: ${exchangePropertyAsIndex(key, type, index)} was: " + function, this.token.getIndex());
            }
            key = StringHelper.removeQuotes(key);
            key = key.trim();
            if (!(type = StringHelper.removeQuotes(type)).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            type = type.trim();
            index = StringHelper.removeQuotes(index);
            index = index.trim();
            if (ObjectHelper.isNotEmpty(remainder = StringHelper.after(remainder, ")"))) {
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${exchangePropertyAsIndex(key, type, index).OGNL} was: " + function, this.token.getIndex());
                }
                return "exchangePropertyAsIndex(exchange, " + type + ", \"" + key + "\", \"" + index + "\")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
            }
            return "exchangePropertyAsIndex(exchange, " + type + ", \"" + key + "\", \"" + index + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("exchangePropertyAs(", function);
        if (remainder != null) {
            String keyAndType = StringHelper.before(remainder, ")");
            if (keyAndType == null) {
                throw new SimpleParserException("Valid syntax: ${exchangePropertyAs(key, type)} was: " + function, this.token.getIndex());
            }
            String key = StringHelper.before(keyAndType, ",");
            String type = StringHelper.after(keyAndType, ",");
            remainder = StringHelper.after(remainder, ")");
            if (ObjectHelper.isEmpty(key) || ObjectHelper.isEmpty(type)) {
                throw new SimpleParserException("Valid syntax: ${exchangePropertyAs(key, type)} was: " + function, this.token.getIndex());
            }
            key = StringHelper.removeQuotes(key);
            key = key.trim();
            if (!(type = StringHelper.removeQuotes(type)).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            type = type.trim();
            return "exchangePropertyAs(exchange, \"" + key + "\", " + type + ")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
        }
        remainder = this.ifStartsWithReturnRemainder("exchangeProperty", function);
        if (remainder != null) {
            if (remainder.startsWith(".") || remainder.startsWith("?")) {
                remainder = remainder.substring(1);
            }
            if (remainder.startsWith("[") && remainder.endsWith("]")) {
                remainder = remainder.substring(1, remainder.length() - 1);
            }
            String key = StringHelper.removeLeadingAndEndingQuotes(remainder);
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(key = key.trim());
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${exchangeProperty.name[key]} was: " + function, this.token.getIndex());
            }
            String index = null;
            if (key.endsWith("]") && (index = StringHelper.between(key, "[", "]")) != null) {
                key = StringHelper.before(key, "[");
            }
            if (index != null) {
                index = StringHelper.removeLeadingAndEndingQuotes(index);
                return "exchangePropertyAsIndex(exchange, Object.class, \"" + key + "\", \"" + index + "\")";
            }
            if (OgnlHelper.isValidOgnlExpression(remainder)) {
                throw new SimpleParserException("Valid syntax: ${exchangePropertyAs(key, type)} was: " + function, this.token.getIndex());
            }
            return "exchangeProperty(exchange, \"" + key + "\")";
        }
        return null;
    }

    private String createCodeFileExpression(String remainder) {
        if (ObjectHelper.equal(remainder, "name")) {
            return "fileName(message)";
        }
        if (ObjectHelper.equal(remainder, "name.noext")) {
            return "fileNameNoExt(message)";
        }
        if (ObjectHelper.equal(remainder, "name.noext.single")) {
            return "fileNameNoExtSingle(message)";
        }
        if (ObjectHelper.equal(remainder, "name.ext") || ObjectHelper.equal(remainder, "ext")) {
            return "fileNameExt(message)";
        }
        if (ObjectHelper.equal(remainder, "name.ext.single")) {
            return "fileNameExtSingle(message)";
        }
        if (ObjectHelper.equal(remainder, "onlyname")) {
            return "fileOnlyName(message)";
        }
        if (ObjectHelper.equal(remainder, "onlyname.noext")) {
            return "fileOnlyNameNoExt(message)";
        }
        if (ObjectHelper.equal(remainder, "onlyname.noext.single")) {
            return "fileOnlyNameNoExtSingle(message)";
        }
        if (ObjectHelper.equal(remainder, "parent")) {
            return "fileParent(message)";
        }
        if (ObjectHelper.equal(remainder, "path")) {
            return "filePath(message)";
        }
        if (ObjectHelper.equal(remainder, "absolute")) {
            return "fileAbsolute(message)";
        }
        if (ObjectHelper.equal(remainder, "absolute.path")) {
            return "fileAbsolutePath(message)";
        }
        if (ObjectHelper.equal(remainder, "length") || ObjectHelper.equal(remainder, "size")) {
            return "fileSize(message)";
        }
        if (ObjectHelper.equal(remainder, "modified")) {
            return "fileModified(message)";
        }
        throw new SimpleParserException("Unknown file language syntax: " + remainder, this.token.getIndex());
    }

    private String createCodeExpressionMisc(String function) {
        String remainder = this.ifStartsWithReturnRemainder("random(", function);
        if (remainder != null) {
            String values = StringHelper.beforeLast(remainder, ")");
            if (values == null || ObjectHelper.isEmpty(values)) {
                throw new SimpleParserException("Valid syntax: ${random(min,max)} or ${random(max)} was: " + function, this.token.getIndex());
            }
            if (values.contains(",")) {
                String before = StringHelper.before(remainder, ",");
                before = before.trim();
                String after = StringHelper.after(remainder, ",");
                if ((after = after.trim()).endsWith(")")) {
                    after = after.substring(0, after.length() - 1);
                }
                return "random(exchange, " + before + ", " + after + ")";
            }
            return "random(exchange, 0, " + values.trim() + ")";
        }
        remainder = this.ifStartsWithReturnRemainder("skip(", function);
        if (remainder != null) {
            String values = StringHelper.beforeLast(remainder, ")");
            if (values == null || ObjectHelper.isEmpty(values)) {
                throw new SimpleParserException("Valid syntax: ${skip(number)} was: " + function, this.token.getIndex());
            }
            return "skip(exchange, " + values.trim() + ")";
        }
        remainder = this.ifStartsWithReturnRemainder("collate(", function);
        if (remainder != null) {
            String values = StringHelper.beforeLast(remainder, ")");
            if (values == null || ObjectHelper.isEmpty(values)) {
                throw new SimpleParserException("Valid syntax: ${collate(group)} was: " + function, this.token.getIndex());
            }
            return "collate(exchange, " + values.trim() + ")";
        }
        remainder = this.ifStartsWithReturnRemainder("messageHistory", function);
        if (remainder != null) {
            String values = StringHelper.between(remainder, "(", ")");
            boolean detailed = values == null || ObjectHelper.isEmpty(values) ? true : Boolean.parseBoolean(values);
            return "messageHistory(exchange, " + (detailed ? "true" : "false") + ")";
        }
        if (ObjectHelper.equal(function, "messageHistory")) {
            return "messageHistory(exchange, true)";
        }
        return null;
    }

    private static List<String> splitOgnl(String remainder) {
        List<String> methods = OgnlHelper.splitOgnl(remainder);
        ArrayList<String> answer = new ArrayList<String>();
        for (String m : methods) {
            boolean index;
            if (m.startsWith(".")) {
                m = m.substring(1);
            }
            boolean bl = index = m.startsWith("[") && m.endsWith("]");
            if (index) {
                boolean lastIndex;
                String last = answer.isEmpty() ? null : (String)answer.get(answer.size() - 1);
                boolean bl2 = lastIndex = last != null && last.startsWith("[") && last.endsWith("]");
                if (lastIndex) {
                    String line = last + m;
                    answer.set(answer.size() - 1, line);
                    continue;
                }
                answer.add(m);
                continue;
            }
            answer.add(m);
        }
        return answer;
    }

    private static String ognlCodeMethods(String remainder, String type) {
        StringBuilder sb = new StringBuilder();
        if (remainder != null) {
            List<String> methods = SimpleFunctionExpression.splitOgnl(remainder);
            for (int i = 0; i < methods.size(); ++i) {
                String m = methods.get(i);
                if (m.startsWith("(")) {
                    sb.append(m);
                    continue;
                }
                String index = StringHelper.betweenOuterPair(m, '[', ']');
                if (index != null) {
                    m = StringHelper.before(m, "[");
                }
                if (m != null && m.equals("length") && type != null && type.contains("[]")) {
                    sb.append(".length");
                    continue;
                }
                if (m != null) {
                    m = OgnlHelper.methodAsDoubleQuotes(m);
                }
                if (m != null && !m.isEmpty()) {
                    sb.append(".");
                    char ch = m.charAt(m.length() - 1);
                    if (Character.isAlphabetic(ch)) {
                        if (!m.startsWith("get")) {
                            sb.append("get");
                            sb.append(Character.toUpperCase(m.charAt(0)));
                            sb.append(m.substring(1));
                        } else {
                            sb.append(m);
                        }
                        sb.append("()");
                    } else {
                        sb.append(m);
                    }
                }
                if (index == null) continue;
                sb.append(".get(");
                try {
                    long lon = Long.parseLong(index);
                    sb.append(lon);
                    if (lon > Integer.MAX_VALUE) {
                        sb.append("l");
                    }
                }
                catch (Exception e) {
                    index = StringHelper.removeLeadingAndEndingQuotes(index);
                    sb.append("\"");
                    sb.append(index);
                    sb.append("\"");
                }
                sb.append(")");
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return remainder;
    }
}

