/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.RouteTemplateContainer;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="routeTemplates")
@XmlRootElement(name="routeTemplates")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RouteTemplatesDefinition
extends OptionalIdentifiedDefinition<RouteTemplatesDefinition>
implements RouteTemplateContainer,
CamelContextAware {
    @XmlElementRef
    private List<RouteTemplateDefinition> routeTemplates = new ArrayList<RouteTemplateDefinition>();
    @XmlTransient
    private CamelContext camelContext;
    @XmlTransient
    private ErrorHandlerFactory errorHandlerFactory;

    public String toString() {
        return "RouteTemplates: " + this.routeTemplates;
    }

    @Override
    public String getShortName() {
        return "routeTemplates";
    }

    @Override
    public String getLabel() {
        return "RouteTemplate " + this.getId();
    }

    @Override
    public List<RouteTemplateDefinition> getRouteTemplates() {
        return this.routeTemplates;
    }

    @Override
    public void setRouteTemplates(List<RouteTemplateDefinition> routeTemplates) {
        this.routeTemplates = routeTemplates;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public ErrorHandlerFactory getErrorHandlerFactory() {
        return this.errorHandlerFactory;
    }

    public void setErrorHandlerFactory(ErrorHandlerFactory errorHandlerFactory) {
        this.errorHandlerFactory = errorHandlerFactory;
    }

    public RouteTemplateDefinition routeTemplate(String id) {
        RouteTemplateDefinition routeTemplate = this.createRouteTemplate();
        routeTemplate.id(id);
        return this.routeTemplate(routeTemplate);
    }

    public RouteTemplateDefinition routeTemplate(RouteTemplateDefinition template) {
        this.getRouteTemplates().add(template);
        return template;
    }

    protected RouteTemplateDefinition createRouteTemplate() {
        RouteTemplateDefinition template = new RouteTemplateDefinition();
        ErrorHandlerFactory handler = this.getErrorHandlerFactory();
        if (handler != null) {
            template.getRoute().setErrorHandlerFactoryIfNull(handler);
        }
        return template;
    }
}

