/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.util.function.BiFunction;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;

public class AggregationStrategyBiFunctionAdapter
implements AggregationStrategy {
    private final BiFunction<Exchange, Exchange, Object> function;
    private boolean allowNullOldExchange;
    private boolean allowNullNewExchange;

    public AggregationStrategyBiFunctionAdapter(BiFunction<Exchange, Exchange, Object> function) {
        this.function = function;
    }

    public boolean isAllowNullOldExchange() {
        return this.allowNullOldExchange;
    }

    public void setAllowNullOldExchange(boolean allowNullOldExchange) {
        this.allowNullOldExchange = allowNullOldExchange;
    }

    public boolean isAllowNullNewExchange() {
        return this.allowNullNewExchange;
    }

    public void setAllowNullNewExchange(boolean allowNullNewExchange) {
        this.allowNullNewExchange = allowNullNewExchange;
    }

    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        if (!this.allowNullOldExchange && oldExchange == null) {
            return newExchange;
        }
        if (!this.allowNullNewExchange && newExchange == null) {
            return oldExchange;
        }
        try {
            Object out = this.function.apply(oldExchange, newExchange);
            if (out != null && !(out instanceof Exchange)) {
                if (oldExchange != null) {
                    oldExchange.getIn().setBody(out);
                } else {
                    newExchange.getIn().setBody(out);
                }
            }
        }
        catch (Exception e) {
            if (oldExchange != null) {
                oldExchange.setException(e);
            }
            newExchange.setException(e);
        }
        return oldExchange != null ? oldExchange : newExchange;
    }
}

