/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit4;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Route;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.PredicateAssertHelper;
import org.apache.camel.test.junit4.CamelTestWatcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class TestSupport
extends Assert {
    protected static final String LS = System.lineSeparator();
    private static final Logger LOG = LoggerFactory.getLogger(TestSupport.class);
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TestName testName = new TestName();
    private CamelTestWatcher camelTestWatcher = new CamelTestWatcher();

    public static ValueBuilder header(String name) {
        return Builder.header(name);
    }

    @Deprecated
    public static ValueBuilder property(String name) {
        return Builder.exchangeProperty(name);
    }

    public static ValueBuilder exchangeProperty(String name) {
        return Builder.exchangeProperty(name);
    }

    public static ValueBuilder body() {
        return Builder.body();
    }

    public static <T> ValueBuilder bodyAs(Class<T> type) {
        return Builder.bodyAs(type);
    }

    public static ValueBuilder systemProperty(String name) {
        return Builder.systemProperty(name);
    }

    public static ValueBuilder systemProperty(String name, String defaultValue) {
        return Builder.systemProperty(name, defaultValue);
    }

    public static <T> T assertIsInstanceOf(Class<T> expectedType, Object value) {
        TestSupport.assertNotNull((String)("Expected an instance of type: " + expectedType.getName() + " but was null"), (Object)value);
        TestSupport.assertTrue((String)("Object should be of type " + expectedType.getName() + " but was: " + value + " with the type: " + value.getClass().getName()), (boolean)expectedType.isInstance(value));
        return expectedType.cast(value);
    }

    public static void assertEndpointUri(Endpoint endpoint, String uri) {
        TestSupport.assertNotNull((String)("Endpoint is null when expecting endpoint for: " + uri), (Object)endpoint);
        TestSupport.assertEquals((String)("Endpoint uri for: " + endpoint), (Object)uri, (Object)endpoint.getEndpointUri());
    }

    public static Object assertInMessageHeader(Exchange exchange, String name, Object expected) {
        return TestSupport.assertMessageHeader(exchange.getIn(), name, expected);
    }

    public static Object assertOutMessageHeader(Exchange exchange, String name, Object expected) {
        return TestSupport.assertMessageHeader(exchange.getOut(), name, expected);
    }

    public static void assertInMessageBodyEquals(Exchange exchange, Object expected) throws InvalidPayloadException {
        Object actual;
        TestSupport.assertNotNull((String)"Should have a response exchange!", (Object)exchange);
        if (expected == null) {
            actual = exchange.getIn().getMandatoryBody();
            TestSupport.assertEquals((String)("in body of: " + exchange), (Object)expected, (Object)actual);
        } else {
            actual = exchange.getIn().getMandatoryBody(expected.getClass());
        }
        TestSupport.assertEquals((String)("in body of: " + exchange), (Object)expected, (Object)actual);
        LOG.debug("Received response: {} with in: {}", (Object)exchange, (Object)exchange.getIn());
    }

    public static void assertOutMessageBodyEquals(Exchange exchange, Object expected) throws InvalidPayloadException {
        Object actual;
        TestSupport.assertNotNull((String)"Should have a response exchange!", (Object)exchange);
        if (expected == null) {
            actual = exchange.getOut().getMandatoryBody();
            TestSupport.assertEquals((String)("output body of: " + exchange), (Object)expected, (Object)actual);
        } else {
            actual = exchange.getOut().getMandatoryBody(expected.getClass());
        }
        TestSupport.assertEquals((String)("output body of: " + exchange), (Object)expected, (Object)actual);
        LOG.debug("Received response: {} with out: {}", (Object)exchange, (Object)exchange.getOut());
    }

    public static Object assertMessageHeader(Message message, String name, Object expected) {
        Object value = message.getHeader(name);
        TestSupport.assertEquals((String)("Header: " + name + " on Message: " + message), (Object)expected, (Object)value);
        return value;
    }

    public static Object assertExpression(Expression expression, Exchange exchange, Object expected) {
        Object value = expected != null ? expression.evaluate(exchange, expected.getClass()) : expression.evaluate(exchange, Object.class);
        LOG.debug("Evaluated expression: {} on exchange: {} result: {}", new Object[]{expression, exchange, value});
        TestSupport.assertEquals((String)("Expression: " + expression + " on Exchange: " + exchange), (Object)expected, (Object)value);
        return value;
    }

    public static void assertPredicateMatches(Predicate predicate, Exchange exchange) {
        TestSupport.assertPredicate(predicate, exchange, true);
    }

    public static void assertPredicateDoesNotMatch(Predicate predicate, Exchange exchange) {
        try {
            PredicateAssertHelper.assertMatches(predicate, "Predicate should match: ", exchange);
        }
        catch (AssertionError e) {
            LOG.debug("Caught expected assertion error: {}", (Object)((Throwable)((Object)e)).getMessage(), (Object)e);
        }
        TestSupport.assertPredicate(predicate, exchange, false);
    }

    public static boolean assertPredicate(Predicate predicate, Exchange exchange, boolean expected) {
        if (expected) {
            PredicateAssertHelper.assertMatches(predicate, "Predicate failed: ", exchange);
        }
        boolean value = predicate.matches(exchange);
        LOG.debug("Evaluated predicate: {} on exchange: {} result: {}", new Object[]{predicate, exchange, value});
        TestSupport.assertEquals((String)("Predicate: " + predicate + " on Exchange: " + exchange), (Object)expected, (Object)value);
        return value;
    }

    public static Endpoint resolveMandatoryEndpoint(CamelContext context, String uri) {
        Endpoint endpoint = context.getEndpoint(uri);
        TestSupport.assertNotNull((String)("No endpoint found for URI: " + uri), (Object)endpoint);
        return endpoint;
    }

    public static <T extends Endpoint> T resolveMandatoryEndpoint(CamelContext context, String uri, Class<T> endpointType) {
        T endpoint = context.getEndpoint(uri, endpointType);
        TestSupport.assertNotNull((String)("No endpoint found for URI: " + uri), endpoint);
        return endpoint;
    }

    protected Exchange createExchangeWithBody(CamelContext camelContext, Object body) {
        DefaultExchange exchange = new DefaultExchange(camelContext);
        Message message = exchange.getIn();
        message.setHeader("testClass", ((Object)((Object)this)).getClass().getName());
        message.setBody(body);
        return exchange;
    }

    public static <T> T assertOneElement(List<T> list) {
        TestSupport.assertEquals((String)("Size of list should be 1: " + list), (long)1L, (long)list.size());
        return list.get(0);
    }

    public static <T> List<T> assertListSize(List<T> list, int size) {
        return TestSupport.assertListSize("List", list, size);
    }

    public static <T> List<T> assertListSize(String message, List<T> list, int size) {
        TestSupport.assertEquals((String)(message + " should be of size: " + size + " but is: " + list), (long)size, (long)list.size());
        return list;
    }

    public static <T> Collection<T> assertCollectionSize(Collection<T> list, int size) {
        return TestSupport.assertCollectionSize("List", list, size);
    }

    public static <T> Collection<T> assertCollectionSize(String message, Collection<T> list, int size) {
        TestSupport.assertEquals((String)(message + " should be of size: " + size + " but is: " + list), (long)size, (long)list.size());
        return list;
    }

    public static List<Route> getRouteList(RouteBuilder builder) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes(builder);
        context.start();
        List<Route> answer = context.getRoutes();
        context.stop();
        return answer;
    }

    public static void assertStringContains(String text, String containedText) {
        TestSupport.assertNotNull((String)"Text should not be null!", (Object)text);
        TestSupport.assertTrue((String)("Text: " + text + " does not contain: " + containedText), (boolean)text.contains(containedText));
    }

    public static boolean deleteDirectory(String file) {
        return TestSupport.deleteDirectory(new File(file));
    }

    public static boolean deleteDirectory(File file) {
        int tries = 0;
        int maxTries = 5;
        boolean exists = true;
        while (exists && tries < maxTries) {
            TestSupport.recursivelyDeleteDirectory(file);
            ++tries;
            exists = file.exists();
            if (!exists) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return !exists;
    }

    private static void recursivelyDeleteDirectory(File file) {
        boolean success;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File child : files = file.listFiles()) {
                TestSupport.recursivelyDeleteDirectory(child);
            }
        }
        if (!(success = file.delete())) {
            LOG.warn("Deletion of file: {} failed", (Object)file.getAbsolutePath());
        }
    }

    public static void createDirectory(String file) {
        File dir = new File(file);
        dir.mkdirs();
    }

    public static void assertDirectoryEquals(String expected, String actual) {
        TestSupport.assertDirectoryEquals(null, expected, actual);
    }

    public static void assertDirectoryEquals(String message, String expected, String actual) {
        String expectedPath = expected.replace('\\', '/');
        String actualPath = actual.replace('\\', '/');
        if (message != null) {
            TestSupport.assertEquals((String)message, (Object)expectedPath, (Object)actualPath);
        } else {
            TestSupport.assertEquals((Object)expectedPath, (Object)actualPath);
        }
    }

    public static void assertDirectoryExists(String filename) {
        File file = new File(filename);
        TestSupport.assertTrue((String)("Directory " + filename + " should exist"), (boolean)file.exists());
        TestSupport.assertTrue((String)("Directory " + filename + " should be a directory"), (boolean)file.isDirectory());
    }

    public static void assertFileExists(String filename) {
        File file = new File(filename);
        TestSupport.assertTrue((String)("File " + filename + " should exist"), (boolean)file.exists());
        TestSupport.assertTrue((String)("File " + filename + " should be a file"), (boolean)file.isFile());
    }

    public static void assertFileNotExists(String filename) {
        File file = new File(filename);
        TestSupport.assertFalse((String)("File " + filename + " should not exist"), (boolean)file.exists());
    }

    public static boolean isPlatform(String platform) {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.contains(platform.toLowerCase(Locale.US));
    }

    public static boolean isJavaVendor(String vendor) {
        String javaVendor = System.getProperty("java.vendor").toLowerCase(Locale.US);
        return javaVendor.contains(vendor.toLowerCase(Locale.US));
    }

    @Deprecated
    public static boolean isJava15() {
        return TestSupport.getJavaMajorVersion() == 5;
    }

    @Deprecated
    public static boolean isJava16() {
        return TestSupport.getJavaMajorVersion() == 6;
    }

    @Deprecated
    public static boolean isJava17() {
        return TestSupport.getJavaMajorVersion() == 7;
    }

    public static boolean isJava18() {
        return TestSupport.getJavaMajorVersion() == 8;
    }

    public static boolean isJava19() {
        return TestSupport.getJavaMajorVersion() == 9;
    }

    public static int getJavaMajorVersion() {
        String javaSpecVersion = System.getProperty("java.specification.version");
        if (javaSpecVersion.contains(".")) {
            return Integer.parseInt(javaSpecVersion.split("\\.")[1]);
        }
        return Integer.parseInt(javaSpecVersion);
    }

    @Rule
    public TestName getTestName() {
        return this.testName;
    }

    public String getTestMethodName() {
        return this.testName.getMethodName();
    }
}

