/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.thrift;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.thrift.ThriftComponent;
import org.apache.camel.component.thrift.ThriftConfiguration;
import org.apache.camel.component.thrift.ThriftConstants;
import org.apache.camel.component.thrift.ThriftConsumer;
import org.apache.camel.component.thrift.ThriftProducer;
import org.apache.camel.component.thrift.ThriftUtils;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.SynchronousDelegateProducer;

@UriEndpoint(firstVersion="2.20.0", scheme="thrift", title="Thrift", syntax="thrift:host:port/service", category={Category.RPC, Category.TRANSFORMATION}, headersClass=ThriftConstants.class)
public class ThriftEndpoint
extends DefaultEndpoint {
    @UriParam
    private ThriftConfiguration configuration;
    @UriParam(defaultValue="false", label="advanced", description="Sets whether synchronous processing should be strictly used")
    private boolean synchronous;
    private String serviceName;
    private String servicePackage;

    public ThriftEndpoint(String uri, ThriftComponent component, ThriftConfiguration config) {
        super(uri, component);
        this.configuration = config;
        this.serviceName = ThriftUtils.extractServiceName(this.configuration.getService());
        this.servicePackage = ThriftUtils.extractServicePackage(this.configuration.getService());
    }

    public ThriftConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Producer createProducer() throws Exception {
        ThriftProducer producer = new ThriftProducer(this, this.configuration);
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer(producer);
        }
        return producer;
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        ThriftConsumer consumer = new ThriftConsumer(this, processor, this.configuration);
        this.configureConsumer(consumer);
        return consumer;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServicePackage() {
        return this.servicePackage;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }
}

