/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.Rational;
import com.drew.lang.StringUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagDescriptor<T extends Directory> {
    @NotNull
    protected final T _directory;

    public TagDescriptor(@NotNull T directory) {
        this._directory = directory;
    }

    @Nullable
    public String getDescription(int tagType) {
        int length;
        Object object = ((Directory)this._directory).getObject(tagType);
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray() && (length = Array.getLength(object)) > 16) {
            return String.format("[%d %s]", length, length == 1 ? "value" : "values");
        }
        if (object instanceof Date) {
            return new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy").format((Date)object).replaceAll("([0-9]{2} [^ ]+)$", ":$1");
        }
        return ((Directory)this._directory).getString(tagType);
    }

    @Nullable
    public static String convertBytesToVersionString(@Nullable int[] components, int majorDigits) {
        if (components == null) {
            return null;
        }
        StringBuilder version = new StringBuilder();
        for (int i = 0; i < 4 && i < components.length; ++i) {
            char c;
            if (i == majorDigits) {
                version.append('.');
            }
            if ((c = (char)components[i]) < '0') {
                c = (char)(c + 48);
            }
            if (i == 0 && c == '0') continue;
            version.append(c);
        }
        return version.toString();
    }

    @Nullable
    protected String getVersionBytesDescription(int tagType, int majorDigits) {
        int[] values = ((Directory)this._directory).getIntArray(tagType);
        return values == null ? null : TagDescriptor.convertBytesToVersionString(values, majorDigits);
    }

    @Nullable
    protected String getIndexedDescription(int tagType, String ... descriptions) {
        return this.getIndexedDescription(tagType, 0, descriptions);
    }

    @Nullable
    protected String getIndexedDescription(int tagType, int baseIndex, String ... descriptions) {
        String description;
        Integer index = ((Directory)this._directory).getInteger(tagType);
        if (index == null) {
            return null;
        }
        int arrayIndex = index - baseIndex;
        if (arrayIndex >= 0 && arrayIndex < descriptions.length && (description = descriptions[arrayIndex]) != null) {
            return description;
        }
        return "Unknown (" + index + ")";
    }

    @Nullable
    protected String getByteLengthDescription(int tagType) {
        byte[] bytes = ((Directory)this._directory).getByteArray(tagType);
        if (bytes == null) {
            return null;
        }
        return String.format("(%d byte%s)", bytes.length, bytes.length == 1 ? "" : "s");
    }

    @Nullable
    protected String getSimpleRational(int tagType) {
        Rational value = ((Directory)this._directory).getRational(tagType);
        if (value == null) {
            return null;
        }
        return value.toSimpleString(true);
    }

    @Nullable
    protected String getDecimalRational(int tagType, int decimalPlaces) {
        Rational value = ((Directory)this._directory).getRational(tagType);
        if (value == null) {
            return null;
        }
        return String.format("%." + decimalPlaces + "f", value.doubleValue());
    }

    @Nullable
    protected String getFormattedInt(int tagType, @NotNull String format) {
        Integer value = ((Directory)this._directory).getInteger(tagType);
        if (value == null) {
            return null;
        }
        return String.format(format, value);
    }

    @Nullable
    protected String getFormattedFloat(int tagType, @NotNull String format) {
        Float value = ((Directory)this._directory).getFloatObject(tagType);
        if (value == null) {
            return null;
        }
        return String.format(format, value);
    }

    @Nullable
    protected String getFormattedString(int tagType, @NotNull String format) {
        String value = ((Directory)this._directory).getString(tagType);
        if (value == null) {
            return null;
        }
        return String.format(format, value);
    }

    @Nullable
    protected String getEpochTimeDescription(int tagType) {
        Long value = ((Directory)this._directory).getLongObject(tagType);
        if (value == null) {
            return null;
        }
        return new Date(value).toString();
    }

    @Nullable
    protected String getBitFlagDescription(int tagType, Object ... labels) {
        Integer value = ((Directory)this._directory).getInteger(tagType);
        if (value == null) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (int bitIndex = 0; labels.length > bitIndex; ++bitIndex) {
            Object labelObj = labels[bitIndex];
            if (labelObj != null) {
                boolean isBitSet;
                boolean bl = isBitSet = (value & 1) == 1;
                if (labelObj instanceof String[]) {
                    String[] labelPair = (String[])labelObj;
                    assert (labelPair.length == 2);
                    parts.add(labelPair[isBitSet ? 1 : 0]);
                } else if (isBitSet && labelObj instanceof String) {
                    parts.add((String)labelObj);
                }
            }
            value = value >> 1;
        }
        return StringUtil.join(parts, ", ");
    }

    @Nullable
    protected String get7BitStringFromBytes(int tagType) {
        byte[] bytes = ((Directory)this._directory).getByteArray(tagType);
        if (bytes == null) {
            return null;
        }
        int length = bytes.length;
        for (int index = 0; index < bytes.length; ++index) {
            int i = bytes[index] & 0xFF;
            if (i != 0 && i <= 127) continue;
            length = index;
            break;
        }
        return new String(bytes, 0, length);
    }

    @Nullable
    protected String getAsciiStringFromBytes(int tag) {
        byte[] values = ((Directory)this._directory).getByteArray(tag);
        if (values == null) {
            return null;
        }
        try {
            return new String(values, "ASCII").trim();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Nullable
    protected String getRationalOrDoubleString(int tagType) {
        Rational rational = ((Directory)this._directory).getRational(tagType);
        if (rational != null) {
            return rational.toSimpleString(true);
        }
        Double d = ((Directory)this._directory).getDoubleObject(tagType);
        if (d != null) {
            DecimalFormat format = new DecimalFormat("0.###");
            return format.format(d);
        }
        return null;
    }

    @Nullable
    protected static String getFStopDescription(double fStop) {
        DecimalFormat format = new DecimalFormat("0.0");
        format.setRoundingMode(RoundingMode.HALF_UP);
        return "f/" + format.format(fStop);
    }

    @Nullable
    protected static String getFocalLengthDescription(double mm) {
        DecimalFormat format = new DecimalFormat("0.#");
        format.setRoundingMode(RoundingMode.HALF_UP);
        return format.format(mm) + " mm";
    }

    @Nullable
    protected String getLensSpecificationDescription(int tag) {
        Rational[] values = ((Directory)this._directory).getRationalArray(tag);
        if (values == null || values.length != 4 || values[0].doubleValue() == 0.0 && values[2].doubleValue() == 0.0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (values[0].equals(values[1])) {
            sb.append(values[0].toSimpleString(true)).append("mm");
        } else {
            sb.append(values[0].toSimpleString(true)).append('-').append(values[1].toSimpleString(true)).append("mm");
        }
        if (values[2].doubleValue() != 0.0) {
            sb.append(' ');
            DecimalFormat format = new DecimalFormat("0.0");
            format.setRoundingMode(RoundingMode.HALF_UP);
            if (values[2].equals(values[3])) {
                sb.append(TagDescriptor.getFStopDescription(values[2].doubleValue()));
            } else {
                sb.append("f/").append(format.format(values[2].doubleValue())).append('-').append(format.format(values[3].doubleValue()));
            }
        }
        return sb.toString();
    }
}

