/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.record;

import java.awt.Rectangle;
import java.io.IOException;
import org.apache.poi.hemf.record.HemfRecord;
import org.apache.poi.hemf.record.HemfRecordType;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianInputStream;

@Internal
public class HemfHeader
implements HemfRecord {
    private Rectangle boundsRectangle;
    private Rectangle frameRectangle;
    private long bytes;
    private long records;
    private int handles;
    private long nDescription;
    private long offDescription;
    private long nPalEntries;
    private boolean hasExtension1;
    private long cbPixelFormat;
    private long offPixelFormat;
    private long bOpenGL;
    private boolean hasExtension2;
    private long micrometersX;
    private long micrometersY;

    public Rectangle getBoundsRectangle() {
        return this.boundsRectangle;
    }

    public Rectangle getFrameRectangle() {
        return this.frameRectangle;
    }

    public long getBytes() {
        return this.bytes;
    }

    public long getRecords() {
        return this.records;
    }

    public int getHandles() {
        return this.handles;
    }

    public long getnDescription() {
        return this.nDescription;
    }

    public long getOffDescription() {
        return this.offDescription;
    }

    public long getnPalEntries() {
        return this.nPalEntries;
    }

    public boolean isHasExtension1() {
        return this.hasExtension1;
    }

    public long getCbPixelFormat() {
        return this.cbPixelFormat;
    }

    public long getOffPixelFormat() {
        return this.offPixelFormat;
    }

    public long getbOpenGL() {
        return this.bOpenGL;
    }

    public boolean isHasExtension2() {
        return this.hasExtension2;
    }

    public long getMicrometersX() {
        return this.micrometersX;
    }

    public long getMicrometersY() {
        return this.micrometersY;
    }

    public String toString() {
        return "HemfHeader{boundsRectangle=" + this.boundsRectangle + ", frameRectangle=" + this.frameRectangle + ", bytes=" + this.bytes + ", records=" + this.records + ", handles=" + this.handles + ", nDescription=" + this.nDescription + ", offDescription=" + this.offDescription + ", nPalEntries=" + this.nPalEntries + ", hasExtension1=" + this.hasExtension1 + ", cbPixelFormat=" + this.cbPixelFormat + ", offPixelFormat=" + this.offPixelFormat + ", bOpenGL=" + this.bOpenGL + ", hasExtension2=" + this.hasExtension2 + ", micrometersX=" + this.micrometersX + ", micrometersY=" + this.micrometersY + '}';
    }

    @Override
    public HemfRecordType getRecordType() {
        return HemfRecordType.header;
    }

    @Override
    public long init(LittleEndianInputStream leis, long recordId, long recordSize) throws IOException {
        if (recordId != 1L) {
            throw new IOException("Not a valid EMF header. Record type:" + recordId);
        }
        byte[] data = new byte[(int)recordSize];
        IOUtils.readFully(leis, data);
        int offset = 0;
        int boundsLeft = LittleEndian.getInt(data, offset);
        int boundsTop = LittleEndian.getInt(data, offset += 4);
        int boundsRight = LittleEndian.getInt(data, offset += 4);
        int boundsBottom = LittleEndian.getInt(data, offset += 4);
        this.boundsRectangle = new Rectangle(boundsLeft, boundsTop, boundsRight - boundsLeft, boundsBottom - boundsTop);
        int frameLeft = LittleEndian.getInt(data, offset += 4);
        int frameTop = LittleEndian.getInt(data, offset += 4);
        int frameRight = LittleEndian.getInt(data, offset += 4);
        int frameBottom = LittleEndian.getInt(data, offset += 4);
        this.frameRectangle = new Rectangle(frameLeft, frameTop, frameRight - frameLeft, frameBottom - frameTop);
        long recordSignature = LittleEndian.getInt(data, offset += 4);
        offset += 4;
        if (recordSignature != 1179469088L) {
            throw new IOException("bad record signature: " + recordSignature);
        }
        long version = LittleEndian.getInt(data, offset);
        this.bytes = LittleEndian.getUInt(data, offset += 4);
        this.records = LittleEndian.getUInt(data, offset += 4);
        this.handles = LittleEndian.getUShort(data, offset += 4);
        offset += 2;
        this.nDescription = LittleEndian.getUInt(data, offset += 2);
        this.offDescription = LittleEndian.getUInt(data, offset += 4);
        this.nPalEntries = LittleEndian.getUInt(data, offset += 4);
        offset += 4;
        offset += 8;
        offset += 8;
        if (recordSize + 8L >= 100L) {
            this.hasExtension1 = true;
            this.cbPixelFormat = LittleEndian.getUInt(data, offset);
            this.offPixelFormat = LittleEndian.getUInt(data, offset += 4);
            this.bOpenGL = LittleEndian.getUInt(data, offset += 4);
            offset += 4;
        }
        if (recordSize + 8L >= 108L) {
            this.hasExtension2 = true;
            this.micrometersX = LittleEndian.getUInt(data, offset);
            this.micrometersY = LittleEndian.getUInt(data, offset += 4);
            offset += 4;
        }
        return recordSize;
    }
}

