/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.nio.charset.Charset;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.poi.hwmf.draw.HwmfDrawProperties;
import org.apache.poi.hwmf.record.HwmfBrushStyle;
import org.apache.poi.hwmf.record.HwmfFont;
import org.apache.poi.hwmf.record.HwmfHatchStyle;
import org.apache.poi.hwmf.record.HwmfMapMode;
import org.apache.poi.hwmf.record.HwmfMisc;
import org.apache.poi.hwmf.record.HwmfObjectTableEntry;
import org.apache.poi.hwmf.record.HwmfPenStyle;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.draw.DrawFontManager;
import org.apache.poi.sl.draw.Drawable;
import org.apache.poi.util.LocaleUtil;

public class HwmfGraphics {
    private static final Charset DEFAULT_CHARSET = LocaleUtil.CHARSET_1252;
    private final Graphics2D graphicsCtx;
    private final List<HwmfDrawProperties> propStack = new LinkedList<HwmfDrawProperties>();
    private HwmfDrawProperties prop = new HwmfDrawProperties();
    private List<HwmfObjectTableEntry> objectTable = new ArrayList<HwmfObjectTableEntry>();
    private final Rectangle2D bbox;
    private final AffineTransform initialAT;

    public HwmfGraphics(Graphics2D graphicsCtx, Rectangle2D bbox) {
        this.graphicsCtx = graphicsCtx;
        this.bbox = (Rectangle2D)bbox.clone();
        this.initialAT = graphicsCtx.getTransform();
        DrawFactory.getInstance(graphicsCtx).fixFonts(graphicsCtx);
    }

    public HwmfDrawProperties getProperties() {
        return this.prop;
    }

    public void draw(Shape shape) {
        HwmfPenStyle.HwmfLineDash lineDash = this.prop.getPenStyle().getLineDash();
        if (lineDash == HwmfPenStyle.HwmfLineDash.NULL) {
            return;
        }
        BasicStroke stroke = this.getStroke();
        if (this.prop.getBkMode() == HwmfMisc.WmfSetBkMode.HwmfBkMode.OPAQUE && lineDash != HwmfPenStyle.HwmfLineDash.SOLID && lineDash != HwmfPenStyle.HwmfLineDash.INSIDEFRAME) {
            this.graphicsCtx.setStroke(new BasicStroke(stroke.getLineWidth()));
            this.graphicsCtx.setColor(this.prop.getBackgroundColor().getColor());
            this.graphicsCtx.draw(shape);
        }
        this.graphicsCtx.setStroke(stroke);
        this.graphicsCtx.setColor(this.prop.getPenColor().getColor());
        this.graphicsCtx.draw(shape);
    }

    public void fill(Shape shape) {
        if (this.prop.getBrushStyle() != HwmfBrushStyle.BS_NULL) {
            this.graphicsCtx.setPaint(this.getFill());
            this.graphicsCtx.fill(shape);
        }
        this.draw(shape);
    }

    protected BasicStroke getStroke() {
        float width = (float)this.prop.getPenWidth();
        if (width == 0.0f) {
            width = 1.0f;
        }
        HwmfPenStyle ps = this.prop.getPenStyle();
        int cap = ps.getLineCap().awtFlag;
        int join = ps.getLineJoin().awtFlag;
        float miterLimit = (float)this.prop.getPenMiterLimit();
        float[] dashes = ps.getLineDash().dashes;
        boolean dashAlt = ps.isAlternateDash();
        float dashStart = dashAlt && dashes != null && dashes.length > 1 ? dashes[0] : 0.0f;
        return new BasicStroke(width, cap, join, miterLimit, dashes, dashStart);
    }

    protected Paint getFill() {
        switch (this.prop.getBrushStyle()) {
            default: {
                return null;
            }
            case BS_PATTERN: 
            case BS_DIBPATTERN: 
            case BS_DIBPATTERNPT: {
                return this.getPatternPaint();
            }
            case BS_SOLID: {
                return this.getSolidFill();
            }
            case BS_HATCHED: 
        }
        return this.getHatchedFill();
    }

    protected Paint getSolidFill() {
        return this.prop.getBrushColor().getColor();
    }

    protected Paint getHatchedFill() {
        int dim = 7;
        int mid = 3;
        BufferedImage bi = new BufferedImage(dim, dim, 6);
        Graphics2D g = bi.createGraphics();
        Color c = this.prop.getBkMode() == HwmfMisc.WmfSetBkMode.HwmfBkMode.TRANSPARENT ? new Color(0, true) : this.prop.getBackgroundColor().getColor();
        g.setColor(c);
        g.fillRect(0, 0, dim, dim);
        g.setColor(this.prop.getBrushColor().getColor());
        HwmfHatchStyle h = this.prop.getBrushHatch();
        if (h == HwmfHatchStyle.HS_HORIZONTAL || h == HwmfHatchStyle.HS_CROSS) {
            g.drawLine(0, mid, dim, mid);
        }
        if (h == HwmfHatchStyle.HS_VERTICAL || h == HwmfHatchStyle.HS_CROSS) {
            g.drawLine(mid, 0, mid, dim);
        }
        if (h == HwmfHatchStyle.HS_FDIAGONAL || h == HwmfHatchStyle.HS_DIAGCROSS) {
            g.drawLine(0, 0, dim, dim);
        }
        if (h == HwmfHatchStyle.HS_BDIAGONAL || h == HwmfHatchStyle.HS_DIAGCROSS) {
            g.drawLine(0, dim, dim, 0);
        }
        g.dispose();
        return new TexturePaint(bi, new Rectangle(0, 0, dim, dim));
    }

    protected Paint getPatternPaint() {
        BufferedImage bi = this.prop.getBrushBitmap();
        return bi == null ? null : new TexturePaint(bi, new Rectangle(0, 0, bi.getWidth(), bi.getHeight()));
    }

    public void addObjectTableEntry(HwmfObjectTableEntry entry) {
        ListIterator<HwmfObjectTableEntry> oIter = this.objectTable.listIterator();
        while (oIter.hasNext()) {
            HwmfObjectTableEntry tableEntry = oIter.next();
            if (tableEntry != null) continue;
            oIter.set(entry);
            return;
        }
        this.objectTable.add(entry);
    }

    public void applyObjectTableEntry(int index) {
        HwmfObjectTableEntry ote = this.objectTable.get(index);
        if (ote == null) {
            throw new NoSuchElementException("WMF reference exception - object table entry on index " + index + " was deleted before.");
        }
        ote.applyObject(this);
    }

    public void unsetObjectTableEntry(int index) {
        this.objectTable.set(index, null);
    }

    public void saveProperties() {
        this.propStack.add(this.prop);
        this.prop = new HwmfDrawProperties(this.prop);
    }

    public void restoreProperties(int index) {
        if (index == 0) {
            return;
        }
        int stackIndex = index;
        if (stackIndex < 0) {
            int curIdx = this.propStack.indexOf(this.prop);
            if (curIdx == -1) {
                curIdx = this.propStack.size();
            }
            stackIndex = curIdx + index;
        }
        if (stackIndex == -1) {
            stackIndex = this.propStack.size() - 1;
        }
        this.prop = this.propStack.get(stackIndex);
    }

    public void updateWindowMapMode() {
        Rectangle2D win = this.prop.getWindow();
        HwmfMapMode mapMode = this.prop.getMapMode();
        this.graphicsCtx.setTransform(this.initialAT);
        switch (mapMode) {
            default: {
                this.graphicsCtx.scale(this.bbox.getWidth() / win.getWidth(), this.bbox.getHeight() / win.getHeight());
                this.graphicsCtx.translate(-win.getX(), -win.getY());
                break;
            }
            case MM_ISOTROPIC: {
                this.graphicsCtx.scale(this.bbox.getWidth() / win.getWidth(), this.bbox.getWidth() / win.getWidth());
                this.graphicsCtx.translate(-win.getX(), -win.getY());
                break;
            }
            case MM_LOMETRIC: 
            case MM_HIMETRIC: 
            case MM_LOENGLISH: 
            case MM_HIENGLISH: 
            case MM_TWIPS: {
                GraphicsConfiguration gc = this.graphicsCtx.getDeviceConfiguration();
                this.graphicsCtx.transform(gc.getNormalizingTransform());
                this.graphicsCtx.scale(1.0 / (double)mapMode.scale, -1.0 / (double)mapMode.scale);
                this.graphicsCtx.translate(-win.getX(), -win.getY());
            }
            case MM_TEXT: 
        }
    }

    public void drawString(byte[] text, Rectangle2D bounds) {
        this.drawString(text, bounds, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawString(byte[] text, Rectangle2D bounds, int[] dx) {
        HwmfFont font = this.prop.getFont();
        if (font == null || text == null || text.length == 0) {
            return;
        }
        double fontH = this.getFontHeight(font);
        double fontW = fontH / 1.8;
        int len = text.length;
        Charset charset = font.getCharSet().getCharset() == null ? DEFAULT_CHARSET : font.getCharSet().getCharset();
        String textString = new String(text, charset);
        AttributedString as = new AttributedString(textString);
        if (dx == null || dx.length == 0) {
            this.addAttributes(as, font);
        } else {
            int[] dxNormed = dx;
            if (textString.length() != text.length) {
                int cp;
                int codePoints = textString.codePointCount(0, textString.length());
                dxNormed = new int[codePoints];
                int dxPosition = 0;
                for (int offset = 0; offset < textString.length(); offset += Character.charCount(cp)) {
                    dxNormed[offset] = dx[dxPosition];
                    cp = textString.codePointAt(offset);
                    int[] chars = new int[]{cp};
                    int byteLength = new String(chars, 0, chars.length).getBytes(charset).length;
                    dxPosition += byteLength;
                }
            }
            for (int i = 0; i < dxNormed.length; ++i) {
                this.addAttributes(as, font);
                if (i >= dxNormed.length - 1) continue;
                as.addAttribute(TextAttribute.TRACKING, ((double)dxNormed[i] - fontW) / fontH, i + 1, i + 2);
            }
        }
        double angle = Math.toRadians((double)(-font.getEscapement()) / 10.0);
        AffineTransform at = this.graphicsCtx.getTransform();
        try {
            this.graphicsCtx.translate(bounds.getX(), bounds.getY() + fontH);
            this.graphicsCtx.rotate(angle);
            if (this.prop.getBkMode() == HwmfMisc.WmfSetBkMode.HwmfBkMode.OPAQUE) {
                this.graphicsCtx.setBackground(this.prop.getBackgroundColor().getColor());
                this.graphicsCtx.fill(new Rectangle2D.Double(0.0, 0.0, bounds.getWidth(), bounds.getHeight()));
            }
            this.graphicsCtx.setColor(this.prop.getTextColor().getColor());
            this.graphicsCtx.drawString(as.getIterator(), 0, 0);
        }
        finally {
            this.graphicsCtx.setTransform(at);
        }
    }

    private void addAttributes(AttributedString as, HwmfFont font) {
        DrawFontManager fontHandler = (DrawFontManager)this.graphicsCtx.getRenderingHint(Drawable.FONT_HANDLER);
        String fontFamily = null;
        Map fontMap = (Map)this.graphicsCtx.getRenderingHint(Drawable.FONT_MAP);
        if (fontMap != null && fontMap.containsKey(font.getFacename())) {
            fontFamily = (String)fontMap.get(font.getFacename());
        }
        if (fontHandler != null) {
            fontFamily = fontHandler.getRendererableFont(font.getFacename(), font.getPitchAndFamily());
        }
        if (fontFamily == null) {
            fontFamily = font.getFacename();
        }
        as.addAttribute(TextAttribute.FAMILY, fontFamily);
        as.addAttribute(TextAttribute.SIZE, this.getFontHeight(font));
        as.addAttribute(TextAttribute.STRIKETHROUGH, font.isStrikeOut());
        if (font.isUnderline()) {
            as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (font.isItalic()) {
            as.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        as.addAttribute(TextAttribute.WEIGHT, font.getWeight());
    }

    private double getFontHeight(HwmfFont font) {
        double fontHeight = font.getHeight();
        if (fontHeight == 0.0) {
            return 12.0;
        }
        if (fontHeight < 0.0) {
            return -fontHeight;
        }
        return fontHeight * 3.0 / 4.0;
    }
}

