/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;

abstract class PathConverter<S, T>
extends SystemConverter<S, T> {
    private static final long serialVersionUID = 4361503025580262022L;

    PathConverter(Class<S> clazz, Class<T> clazz2) {
        super(clazz, clazz2);
    }

    @Override
    public final Set<FunctionProperty> properties() {
        return EnumSet.of(FunctionProperty.INJECTIVE, FunctionProperty.INVERTIBLE);
    }

    @Override
    public final T apply(S s) throws UnconvertibleObjectException {
        if (s == null) {
            return null;
        }
        try {
            return this.doConvert(s);
        }
        catch (Exception exception) {
            throw new UnconvertibleObjectException(this.formatErrorMessage(s), exception);
        }
    }

    abstract T doConvert(S var1) throws Exception;

    public static final class URI_URL
    extends PathConverter<URI, URL> {
        private static final long serialVersionUID = 5478354821309176895L;
        static final URI_URL INSTANCE = new URI_URL();

        public URI_URL() {
            super(URI.class, URL.class);
        }

        @Override
        public ObjectConverter<URI, URL> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<URL, URI> inverse() {
            return URL_URI.INSTANCE;
        }

        @Override
        public URL doConvert(URI uRI) throws MalformedURLException {
            return uRI.toURL();
        }
    }

    public static final class URL_URI
    extends PathConverter<URL, URI> {
        private static final long serialVersionUID = 6327568235014244008L;
        static final URL_URI INSTANCE = new URL_URI();

        public URL_URI() {
            super(URL.class, URI.class);
        }

        @Override
        public ObjectConverter<URL, URI> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<URI, URL> inverse() {
            return URI_URL.INSTANCE;
        }

        @Override
        public URI doConvert(URL uRL) throws URISyntaxException {
            return uRL.toURI();
        }
    }

    public static final class URIFile
    extends PathConverter<URI, File> {
        private static final long serialVersionUID = 5070991554943811760L;
        static final URIFile INSTANCE = new URIFile();

        public URIFile() {
            super(URI.class, File.class);
        }

        @Override
        public ObjectConverter<URI, File> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<File, URI> inverse() {
            return FileURI.INSTANCE;
        }

        @Override
        public File doConvert(URI uRI) throws IllegalArgumentException {
            return new File(uRI);
        }
    }

    public static final class URLFile
    extends PathConverter<URL, File> {
        private static final long serialVersionUID = 3669726699184691997L;
        static final URLFile INSTANCE = new URLFile();

        public URLFile() {
            super(URL.class, File.class);
        }

        @Override
        public ObjectConverter<URL, File> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<File, URL> inverse() {
            return FileURL.INSTANCE;
        }

        @Override
        public File doConvert(URL uRL) throws URISyntaxException {
            return new File(uRL.toURI());
        }
    }

    public static final class FileURL
    extends PathConverter<File, URL> {
        private static final long serialVersionUID = 2191394598748096966L;
        static final FileURL INSTANCE = new FileURL();

        public FileURL() {
            super(File.class, URL.class);
        }

        @Override
        public ObjectConverter<File, URL> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<URL, File> inverse() {
            return URLFile.INSTANCE;
        }

        @Override
        public URL doConvert(File file) throws MalformedURLException {
            return file.toURI().toURL();
        }
    }

    public static final class FileURI
    extends PathConverter<File, URI> {
        private static final long serialVersionUID = 1122784850124333991L;
        static final FileURI INSTANCE = new FileURI();

        public FileURI() {
            super(File.class, URI.class);
        }

        @Override
        public ObjectConverter<File, URI> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<URI, File> inverse() {
            return URIFile.INSTANCE;
        }

        @Override
        public URI doConvert(File file) {
            return file.toURI();
        }
    }
}

