/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.referencing;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.PropertyType;
import org.apache.sis.internal.jaxb.referencing.CC_GeneralOperationParameter;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public final class CC_OperationMethod
extends PropertyType<CC_OperationMethod, OperationMethod> {
    public CC_OperationMethod() {
    }

    @Override
    protected Class<OperationMethod> getBoundType() {
        return OperationMethod.class;
    }

    private CC_OperationMethod(OperationMethod operationMethod) {
        super(operationMethod);
    }

    @Override
    protected CC_OperationMethod wrap(OperationMethod operationMethod) {
        return new CC_OperationMethod(operationMethod);
    }

    @XmlElement(name="OperationMethod")
    public DefaultOperationMethod getElement() {
        return DefaultOperationMethod.castOrCopy((OperationMethod)this.metadata);
    }

    public void setElement(DefaultOperationMethod defaultOperationMethod) {
        if (!CC_GeneralOperationParameter.isValid(defaultOperationMethod.getParameters())) {
            throw new IllegalArgumentException(Errors.format((short)64, "parameters"));
        }
        this.metadata = defaultOperationMethod;
    }

    public static GeneralParameterValue[] filterImplicit(GeneralParameterValue[] generalParameterValueArray) {
        int n = 0;
        for (GeneralParameterValue generalParameterValue : generalParameterValueArray) {
            if (CC_OperationMethod.isImplicitParameter(generalParameterValue.getDescriptor())) continue;
            generalParameterValueArray[n++] = generalParameterValue;
        }
        return ArraysExt.resize(generalParameterValueArray, n);
    }

    public static GeneralParameterDescriptor[] filterImplicit(GeneralParameterDescriptor[] generalParameterDescriptorArray) {
        int n = 0;
        for (GeneralParameterDescriptor generalParameterDescriptor : generalParameterDescriptorArray) {
            if (CC_OperationMethod.isImplicitParameter(generalParameterDescriptor)) continue;
            generalParameterDescriptorArray[n++] = generalParameterDescriptor;
        }
        return ArraysExt.resize(generalParameterDescriptorArray, n);
    }

    static boolean isImplicitParameter(GeneralParameterDescriptor generalParameterDescriptor) {
        return generalParameterDescriptor == MapProjection.SEMI_MAJOR || generalParameterDescriptor == MapProjection.SEMI_MINOR;
    }

    public static ParameterDescriptorGroup group(Identifier identifier, GeneralParameterDescriptor[] generalParameterDescriptorArray) {
        DefaultCoordinateOperationFactory defaultCoordinateOperationFactory = DefaultFactories.forBuildin(CoordinateOperationFactory.class, DefaultCoordinateOperationFactory.class);
        OperationMethod operationMethod = null;
        if (defaultCoordinateOperationFactory != null) {
            try {
                operationMethod = defaultCoordinateOperationFactory.getOperationMethod(identifier.getCode());
            }
            catch (FactoryException factoryException) {
                Context.warningOccured(Context.current(), DefaultOperationMethod.class, "setDescriptors", factoryException, true);
            }
        }
        Map<String, Identifier> map = Collections.singletonMap("name", identifier);
        if (operationMethod != null) {
            ParameterDescriptorGroup parameterDescriptorGroup = operationMethod.getParameters();
            return CC_GeneralOperationParameter.merge(DefaultOperationMethod.class, map, IdentifiedObjects.getProperties(parameterDescriptorGroup, new String[0]), 1, 1, generalParameterDescriptorArray, parameterDescriptorGroup, true);
        }
        return new DefaultParameterDescriptorGroup(map, 1, 1, generalParameterDescriptorArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void store(GeneralParameterValue[] generalParameterValueArray, Collection<GeneralParameterValue> collection, Map<GeneralParameterDescriptor, GeneralParameterDescriptor> map) {
        for (GeneralParameterValue generalParameterValue : generalParameterValueArray) {
            void object;
            GeneralParameterDescriptor generalParameterDescriptor = map.get(generalParameterValue.getDescriptor());
            if (generalParameterDescriptor != null) {
                Object object2;
                Cloneable cloneable;
                GeneralParameterValue generalParameterValue2;
                if (generalParameterValue instanceof ParameterValue) {
                    generalParameterValue2 = (ParameterValue)generalParameterValue;
                    cloneable = new DefaultParameterValue((ParameterDescriptor)generalParameterDescriptor);
                    object2 = generalParameterValue2.getValue();
                    Unit<?> unit = generalParameterValue2.getUnit();
                    if (unit == null) {
                        cloneable.setValue(object2);
                    } else if (object2 instanceof double[]) {
                        cloneable.setValue((double[])object2, unit);
                    } else {
                        cloneable.setValue(((Number)object2).doubleValue(), unit);
                    }
                    Cloneable cloneable2 = cloneable;
                } else if (generalParameterValue instanceof ParameterValueGroup) {
                    generalParameterValue2 = (ParameterValueGroup)generalParameterValue;
                    cloneable = new DefaultParameterValueGroup((ParameterDescriptorGroup)generalParameterDescriptor);
                    object2 = generalParameterValue2.values();
                    CC_OperationMethod.store(object2.toArray(new GeneralParameterValue[object2.size()]), cloneable.values(), map);
                    Cloneable cloneable3 = cloneable;
                }
            }
            collection.add((GeneralParameterValue)object);
        }
    }
}

