/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.io.IOException;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.ucar.GridGeometryWrapper;
import org.apache.sis.internal.netcdf.ucar.VariableWrapper;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.logging.WarningListeners;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;

public final class DecoderWrapper
extends Decoder
implements CancelTask {
    private final NetcdfFile file;
    private Group[] groups;
    private transient Variable[] variables;
    private transient GridGeometry[] geometries;

    public DecoderWrapper(WarningListeners<?> warningListeners, NetcdfFile netcdfFile) {
        super(warningListeners);
        this.file = netcdfFile;
    }

    public DecoderWrapper(WarningListeners<?> warningListeners, String string) throws IOException {
        super(warningListeners);
        this.file = NetcdfDataset.openDataset(string, false, this);
    }

    @Override
    public void setSearchPath(String ... stringArray) {
        Group[] groupArray = new Group[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            if (string != null) {
                Group group = this.file.findGroup(string);
                if (group == null) continue;
                groupArray[n] = group;
            }
            ++n;
        }
        this.groups = ArraysExt.resize(groupArray, n);
    }

    @Override
    public String[] getSearchPath() {
        String[] stringArray = new String[this.groups.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Group group = this.groups[i];
            if (group == null) continue;
            stringArray[i] = group.getShortName();
        }
        return stringArray;
    }

    private Attribute findAttribute(Group group, String string) {
        return group != null ? group.findAttributeIgnoreCase(string) : this.file.findGlobalAttributeIgnoreCase(string);
    }

    @Override
    public String stringValue(String string) {
        if (string != null) {
            for (Group group : this.groups) {
                String string2;
                Attribute attribute = this.findAttribute(group, string);
                if (attribute == null || !attribute.isString() || (string2 = attribute.getStringValue()) == null || (string2 = string2.trim()).isEmpty()) continue;
                return string2;
            }
        }
        return null;
    }

    @Override
    public Number numericValue(String string) {
        if (string != null) {
            for (Group group : this.groups) {
                Attribute attribute = this.findAttribute(group, string);
                if (attribute == null) continue;
                Number number = attribute.getNumericValue();
                if (number != null) {
                    return number;
                }
                String string2 = attribute.getStringValue();
                if (string2 == null || (string2 = string2.trim()).isEmpty()) continue;
                return this.parseNumber(string2);
            }
        }
        return null;
    }

    @Override
    public Date dateValue(String string) {
        if (string != null) {
            for (Group group : this.groups) {
                CalendarDate calendarDate;
                String string2;
                Attribute attribute = this.findAttribute(group, string);
                if (attribute == null || !attribute.isString() || (string2 = attribute.getStringValue()) == null || (string2 = string2.trim()).isEmpty()) continue;
                try {
                    calendarDate = CalendarDateFormatter.isoStringToCalendarDate(Calendar.proleptic_gregorian, string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.listeners.warning(null, illegalArgumentException);
                    continue;
                }
                return new Date(calendarDate.getMillis());
            }
        }
        return null;
    }

    @Override
    public Date[] numberToDate(String string, Number ... numberArray) {
        DateUnit dateUnit;
        Date[] dateArray = new Date[numberArray.length];
        try {
            dateUnit = new DateUnit(string);
        }
        catch (Exception exception) {
            this.listeners.warning(null, exception);
            return dateArray;
        }
        for (int i = 0; i < numberArray.length; ++i) {
            Number number = numberArray[i];
            if (number == null) continue;
            dateArray[i] = dateUnit.makeDate(number.doubleValue());
        }
        return dateArray;
    }

    @Override
    public String getId() {
        return this.file.getId();
    }

    @Override
    public String getTitle() {
        return this.file.getTitle();
    }

    @Override
    public Variable[] getVariables() {
        if (this.variables == null) {
            List<Dimension> list = this.file.getDimensions();
            List<ucar.nc2.Variable> list2 = this.file.getVariables();
            this.variables = new Variable[list2 != null ? list2.size() : 0];
            for (int i = 0; i < this.variables.length; ++i) {
                this.variables[i] = new VariableWrapper(list2.get(i), list);
            }
        }
        return this.variables;
    }

    @Override
    public GridGeometry[] getGridGeometries() throws IOException {
        if (this.geometries == null) {
            List<CoordinateSystem> list = null;
            if (this.file instanceof NetcdfDataset) {
                NetcdfDataset netcdfDataset = (NetcdfDataset)this.file;
                EnumSet<NetcdfDataset.Enhance> enumSet = EnumSet.copyOf(netcdfDataset.getEnhanceMode());
                if (enumSet.add(NetcdfDataset.Enhance.CoordSystems)) {
                    netcdfDataset.enhance(enumSet);
                }
                list = netcdfDataset.getCoordinateSystems();
            }
            this.geometries = new GridGeometry[list != null ? list.size() : 0];
            for (int i = 0; i < this.geometries.length; ++i) {
                this.geometries[i] = new GridGeometryWrapper(list.get(i));
            }
        }
        return this.geometries;
    }

    @Override
    public boolean isCancel() {
        return this.canceled;
    }

    @Override
    public void setProgress(String string, int n) {
    }

    @Override
    public void setError(String string) {
        this.listeners.warning(string, null);
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    public String toString() {
        return "UCAR driver: \u201c" + this.file.getLocation() + '\u201d';
    }
}

