/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.apache.sis.measure.Units;

public final class PatchedUnitFormat
extends Format {
    private static final long serialVersionUID = -3064428584419360693L;
    private static volatile Map<Unit<?>, String> SYMBOLS;
    private final UnitFormat format;
    public boolean isLocaleUS;

    public static void init(Object ... objectArray) {
        HashMap hashMap = new HashMap(8);
        for (int i = 0; i < objectArray.length; ++i) {
            String string;
            if (hashMap.put((Unit)objectArray[i], string = (String)objectArray[++i]) == null) continue;
            throw new IllegalArgumentException(string);
        }
        if (SYMBOLS != null) {
            throw new IllegalStateException();
        }
        SYMBOLS = hashMap;
    }

    public PatchedUnitFormat(UnitFormat unitFormat) {
        this.format = unitFormat;
    }

    public static <Q extends Quantity> Unit<Q> toFormattable(Unit<Q> unit) {
        Map<Unit<?>, String> map = SYMBOLS;
        if (map != null && map.containsKey(unit)) {
            assert (Units.isAngular(unit));
            unit = NonSI.DEGREE_ANGLE;
        }
        return unit;
    }

    public static String toString(Unit<?> unit) {
        if (unit != null) {
            String string;
            Map<Unit<?>, String> map = SYMBOLS;
            if (map != null && (string = map.get(unit)) != null) {
                return string;
            }
            try {
                string = unit.toString();
                if (string.equals("deg")) {
                    string = "\u00b0";
                }
                return string;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        String string;
        Map<Unit<?>, String> map = SYMBOLS;
        if (map != null && (string = map.get(object)) != null) {
            return stringBuffer.append(string);
        }
        if (Unit.ONE.equals(object)) {
            return stringBuffer.append("unity");
        }
        if (NonSI.DEGREE_ANGLE.equals(object)) {
            return stringBuffer.append("degree");
        }
        if (SI.METRE.equals(object)) {
            return stringBuffer.append(this.isLocaleUS ? "meter" : "metre");
        }
        if (NonSI.FOOT_SURVEY_US.equals(object)) {
            return stringBuffer.append("US survey foot");
        }
        if (Units.PPM.equals(object)) {
            return stringBuffer.append("parts per million");
        }
        return this.format.format(object, stringBuffer, fieldPosition);
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.format.parseObject(string, parsePosition);
    }
}

