/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Date;
import java.util.Map;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Duration;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.TemporalDatum;

@XmlType(name="TemporalCRSType", propOrder={"coordinateSystem", "datum"})
@XmlRootElement(name="TemporalCRS")
public class DefaultTemporalCRS
extends AbstractCRS
implements TemporalCRS {
    private static final long serialVersionUID = 3000119849197222007L;
    @XmlElement(name="temporalDatum", required=true)
    private final TemporalDatum datum;
    private transient UnitConverter toMillis;
    private transient long origin;

    public DefaultTemporalCRS(Map<String, ?> map, TemporalDatum temporalDatum, TimeCS timeCS) {
        super(map, timeCS);
        ArgumentChecks.ensureNonNull("datum", temporalDatum);
        this.datum = temporalDatum;
    }

    protected DefaultTemporalCRS(TemporalCRS temporalCRS) {
        super(temporalCRS);
        this.datum = temporalCRS.getDatum();
    }

    public static DefaultTemporalCRS castOrCopy(TemporalCRS temporalCRS) {
        return temporalCRS == null || temporalCRS instanceof DefaultTemporalCRS ? (DefaultTemporalCRS)temporalCRS : new DefaultTemporalCRS(temporalCRS);
    }

    public Class<? extends TemporalCRS> getInterface() {
        return TemporalCRS.class;
    }

    private void initializeConverter() {
        this.origin = this.datum.getOrigin().getTime();
        this.toMillis = this.getCoordinateSystem().getAxis(0).getUnit().asType(Duration.class).getConverterTo(Units.MILLISECOND);
    }

    @Override
    public final TemporalDatum getDatum() {
        return this.datum;
    }

    @Override
    @XmlElement(name="timeCS", required=true)
    public TimeCS getCoordinateSystem() {
        return (TimeCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultTemporalCRS forConvention(AxesConvention axesConvention) {
        return (DefaultTemporalCRS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        return new DefaultTemporalCRS(map, this.datum, (TimeCS)coordinateSystem);
    }

    public Date toDate(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        if (this.toMillis == null) {
            this.initializeConverter();
        }
        return new Date(Math.round(this.toMillis.convert(d)) + this.origin);
    }

    public double toValue(Date date) {
        if (date == null) {
            return Double.NaN;
        }
        if (this.toMillis == null) {
            this.initializeConverter();
        }
        return this.toMillis.inverse().convert(date.getTime() - this.origin);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return DefaultTemporalCRS.isBaseCRS(formatter) ? "BaseTimeCRS" : "TimeCRS";
    }

    private DefaultTemporalCRS() {
        this.datum = null;
    }

    private void setCoordinateSystem(TimeCS timeCS) {
        this.setCoordinateSystem("timeCS", timeCS);
    }
}

