/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.validation.Schema;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.LegacyNamespaces;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Locales;
import org.apache.sis.util.Version;
import org.apache.sis.util.logging.WarningListener;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.FilterVersion;
import org.apache.sis.xml.ReferenceResolver;
import org.apache.sis.xml.ValueConverter;

abstract class Pooled {
    private static final String[] SCHEMA_KEYS = new String[]{"gmd"};
    static final String ENDORSED_PREFIX = "com.sun.xml.bind.";
    private final boolean internal;
    final Map<Object, Object> initialProperties;
    private int bitMasks;
    private Locale locale;
    private TimeZone timezone;
    private Map<String, String> schemas;
    private byte xmlnsReplaceCode;
    private Version versionGML;
    private ReferenceResolver resolver;
    private ValueConverter converter;
    private WarningListener<?> warningListener;
    volatile long resetTime;

    Pooled(boolean bl) {
        this.internal = bl;
        this.initialProperties = new LinkedHashMap<Object, Object>();
    }

    Pooled(Pooled pooled) {
        this.initialProperties = new LinkedHashMap<Object, Object>();
        this.internal = pooled.internal;
    }

    final void initialize(Pooled pooled) throws JAXBException {
        this.reset(pooled);
        for (Map.Entry<Object, Object> entry : pooled.initialProperties.entrySet()) {
            this.setStandardProperty((String)entry.getKey(), entry.getValue());
        }
    }

    public final void reset(Pooled pooled) throws JAXBException {
        for (Map.Entry<Object, Object> entry : this.initialProperties.entrySet()) {
            this.reset(entry.getKey(), entry.getValue());
        }
        this.initialProperties.clear();
        this.bitMasks = pooled.bitMasks;
        this.locale = pooled.locale;
        this.timezone = pooled.timezone;
        this.schemas = pooled.schemas;
        this.xmlnsReplaceCode = pooled.xmlnsReplaceCode;
        this.versionGML = pooled.versionGML;
        this.resolver = pooled.resolver;
        this.converter = pooled.converter;
        this.warningListener = pooled.warningListener;
        this.resetTime = System.nanoTime();
        if (this instanceof Marshaller) {
            this.bitMasks |= 1;
        }
    }

    protected abstract void reset(Object var1, Object var2) throws JAXBException;

    final FilterVersion getFilterVersion() {
        switch (this.xmlnsReplaceCode) {
            case 0: {
                if (this.versionGML == null || this.versionGML.compareTo(LegacyNamespaces.VERSION_3_2_1) >= 0) break;
                return FilterVersion.GML31;
            }
            case 1: {
                if ((this.bitMasks & 1) != 0) break;
                return FilterVersion.ALL;
            }
        }
        return null;
    }

    final boolean isPropertySaved(Class<?> clazz) {
        return this.initialProperties.containsKey(clazz);
    }

    final <E> void saveProperty(Class<E> clazz, E e) {
        if (this.initialProperties.put(clazz, e) != null) {
            throw new ConcurrentModificationException(Errors.format((short)108, clazz.getInterfaces()[0].getSimpleName() + ".get" + clazz.getSimpleName()));
        }
    }

    private String convertPropertyKey(String string) {
        if (this.internal && string.startsWith(ENDORSED_PREFIX)) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + 10);
            string = stringBuilder.append("com.sun.xml.internal.bind.").append(string, ENDORSED_PREFIX.length(), string.length()).toString();
        }
        return string;
    }

    public final void setProperty(String string, Object object) throws PropertyException {
        try {
            if (string.equals("org.apache.sis.xml.locale")) {
                this.locale = object instanceof CharSequence ? Locales.parse(object.toString()) : (Locale)object;
                return;
            }
            if (string.equals("org.apache.sis.xml.timezone")) {
                this.timezone = object instanceof CharSequence ? TimeZone.getTimeZone(object.toString()) : (TimeZone)object;
                return;
            }
            if (string.equals("org.apache.sis.xml.schemas")) {
                Map map = (Map)object;
                Map<String, String> map2 = null;
                if (map != null) {
                    map2 = new HashMap(4);
                    for (String string2 : SCHEMA_KEYS) {
                        Object v = map.get(string2);
                        if (v == null) continue;
                        if (!(v instanceof String)) {
                            throw new PropertyException(Errors.format((short)40, string + "[\"" + string2 + "\"]", object.getClass()));
                        }
                        map2.put(string2, (String)v);
                    }
                    map2 = CollectionsExt.unmodifiableOrCopy(map2);
                }
                this.schemas = map2;
                return;
            }
            if (string.equals("org.apache.sis.gml.version")) {
                this.versionGML = object instanceof CharSequence ? new Version(object.toString()) : (Version)object;
                return;
            }
            if (string.equals("org.apache.sis.xml.resolver")) {
                this.resolver = (ReferenceResolver)object;
                return;
            }
            if (string.equals("org.apache.sis.xml.converter")) {
                this.converter = (ValueConverter)object;
                return;
            }
            if (string.equals("org.apache.sis.xml.stringSubstitutes")) {
                this.bitMasks &= 0xFFFFFFE1;
                if (object != null) {
                    for (CharSequence charSequence : (CharSequence[])object) {
                        if (CharSequences.equalsIgnoreCase(charSequence, "language")) {
                            this.bitMasks |= 2;
                            continue;
                        }
                        if (CharSequences.equalsIgnoreCase(charSequence, "country")) {
                            this.bitMasks |= 4;
                            continue;
                        }
                        if (CharSequences.equalsIgnoreCase(charSequence, "filename")) {
                            this.bitMasks |= 8;
                            continue;
                        }
                        if (!CharSequences.equalsIgnoreCase(charSequence, "mimetype")) continue;
                        this.bitMasks |= 0x10;
                    }
                }
                return;
            }
            if (string.equals("org.apache.sis.xml.warningListener")) {
                this.warningListener = (WarningListener)object;
                return;
            }
            if (string.equals("org.apache.sis.xml.applyNamespaceReplacements")) {
                this.xmlnsReplaceCode = 0;
                if (object != null) {
                    this.xmlnsReplaceCode = (byte)((Boolean)object != false ? 1 : 2);
                }
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            throw new PropertyException(Errors.format((short)40, string, object.getClass()), (Throwable)runtimeException);
        }
        string = this.convertPropertyKey(string);
        if (!this.initialProperties.containsKey(string) && this.initialProperties.put(string, this.getStandardProperty(string)) != null) {
            throw new ConcurrentModificationException(string);
        }
        this.setStandardProperty(string, object);
    }

    public final Object getProperty(String string) throws PropertyException {
        if (string.equals("org.apache.sis.xml.locale")) {
            return this.locale;
        }
        if (string.equals("org.apache.sis.xml.timezone")) {
            return this.timezone;
        }
        if (string.equals("org.apache.sis.xml.schemas")) {
            return this.schemas;
        }
        if (string.equals("org.apache.sis.gml.version")) {
            return this.versionGML;
        }
        if (string.equals("org.apache.sis.xml.resolver")) {
            return this.resolver;
        }
        if (string.equals("org.apache.sis.xml.converter")) {
            return this.converter;
        }
        if (string.equals("org.apache.sis.xml.warningListener")) {
            return this.warningListener;
        }
        if (string.equals("org.apache.sis.xml.stringSubstitutes")) {
            int n = 0;
            String[] stringArray = new String[4];
            if ((this.bitMasks & 2) != 0) {
                stringArray[n++] = "language";
            }
            if ((this.bitMasks & 4) != 0) {
                stringArray[n++] = "country";
            }
            if ((this.bitMasks & 8) != 0) {
                stringArray[n++] = "filename";
            }
            if ((this.bitMasks & 0x10) != 0) {
                stringArray[n++] = "mimetype";
            }
            return n != 0 ? ArraysExt.resize(stringArray, n) : null;
        }
        if (string.equals("org.apache.sis.xml.applyNamespaceReplacements")) {
            switch (this.xmlnsReplaceCode) {
                case 1: {
                    return Boolean.TRUE;
                }
                case 2: {
                    return Boolean.FALSE;
                }
            }
            return null;
        }
        return this.getStandardProperty(this.convertPropertyKey(string));
    }

    abstract void setStandardProperty(String var1, Object var2) throws PropertyException;

    abstract Object getStandardProperty(String var1) throws PropertyException;

    public final void setAdapter(XmlAdapter xmlAdapter) {
        this.setAdapter(xmlAdapter.getClass(), xmlAdapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> clazz, A a) {
        if (!this.isPropertySaved(clazz)) {
            this.saveProperty(clazz, this.getAdapter(clazz));
        }
    }

    public abstract <A extends XmlAdapter> A getAdapter(Class<A> var1);

    public void setSchema(Schema schema) {
        if (!this.isPropertySaved(Schema.class)) {
            this.saveProperty(Schema.class, this.getSchema());
        }
    }

    public abstract Schema getSchema();

    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        if (!this.initialProperties.containsKey(ValidationEventHandler.class)) {
            this.saveProperty(ValidationEventHandler.class, this.getEventHandler());
        }
    }

    public abstract ValidationEventHandler getEventHandler() throws JAXBException;

    final Context begin() {
        return new Context(this.bitMasks, this.locale, this.timezone, this.schemas, this.versionGML, this.resolver, this.converter, this.warningListener);
    }
}

