/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import org.apache.poi.hslf.model.Comment;
import org.apache.poi.hslf.model.HeadersFooters;
import org.apache.poi.hslf.model.OLEShape;
import org.apache.poi.hslf.record.DocInfoListContainer;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.VBAInfoAtom;
import org.apache.poi.hslf.record.VBAInfoContainer;
import org.apache.poi.hslf.usermodel.HSLFHyperlink;
import org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import org.apache.poi.hslf.usermodel.HSLFNotes;
import org.apache.poi.hslf.usermodel.HSLFObjectData;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTable;
import org.apache.poi.hslf.usermodel.HSLFTableCell;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextRun;
import org.apache.poi.hslf.usermodel.HSLFTextShape;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class HSLFExtractor
extends AbstractPOIFSExtractor {
    public HSLFExtractor(ParseContext context, Metadata metadata) {
        super(context, metadata);
    }

    protected void parse(NPOIFSFileSystem filesystem, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        this.parse(filesystem.getRoot(), xhtml);
    }

    protected void parse(DirectoryNode root, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        HSLFSlideShow ss = new HSLFSlideShow(root);
        List<HSLFSlide> _slides = ss.getSlides();
        xhtml.startElement("div", "class", "slideShow");
        for (HSLFSlide slide : _slides) {
            xhtml.startElement("div", "class", "slide");
            HeadersFooters hf = slide.getHeadersFooters();
            if (hf != null && hf.isHeaderVisible() && hf.getHeaderText() != null) {
                xhtml.startElement("p", "class", "slide-header");
                xhtml.characters(hf.getHeaderText());
                xhtml.endElement("p");
            }
            this.extractMaster(xhtml, slide.getMasterSheet());
            xhtml.startElement("div", "class", "slide-content");
            this.textRunsToText(xhtml, slide.getTextParagraphs());
            xhtml.endElement("div");
            for (HSLFShape hSLFShape : slide.getShapes()) {
                if (!(hSLFShape instanceof HSLFTable)) continue;
                this.extractTableText(xhtml, (HSLFTable)hSLFShape);
            }
            if (hf != null && hf.isFooterVisible() && hf.getFooterText() != null) {
                xhtml.startElement("p", "class", "slide-footer");
                xhtml.characters(hf.getFooterText());
                xhtml.endElement("p");
            }
            StringBuilder authorStringBuilder = new StringBuilder();
            for (Comment comment : slide.getComments()) {
                authorStringBuilder.setLength(0);
                xhtml.startElement("p", "class", "slide-comment");
                if (comment.getAuthor() != null) {
                    authorStringBuilder.append(comment.getAuthor());
                }
                if (comment.getAuthorInitials() != null) {
                    if (authorStringBuilder.length() > 0) {
                        authorStringBuilder.append(" ");
                    }
                    authorStringBuilder.append("(" + comment.getAuthorInitials() + ")");
                }
                if (authorStringBuilder.length() > 0) {
                    if (comment.getText() != null) {
                        authorStringBuilder.append(" - ");
                    }
                    xhtml.startElement("b");
                    xhtml.characters(authorStringBuilder.toString());
                    xhtml.endElement("b");
                }
                if (comment.getText() != null) {
                    xhtml.characters(comment.getText());
                }
                xhtml.endElement("p");
            }
            this.handleSlideEmbeddedResources(slide, xhtml);
            HSLFNotes hSLFNotes = slide.getNotes();
            if (hSLFNotes != null) {
                xhtml.startElement("div", "class", "slide-notes");
                this.textRunsToText(xhtml, hSLFNotes.getTextParagraphs());
                xhtml.endElement("div");
            }
            xhtml.endElement("div");
        }
        xhtml.endElement("div");
        xhtml.startElement("div", "class", "slide-notes");
        HashSet<Integer> seenNotes = new HashSet<Integer>();
        HeadersFooters hf = ss.getNotesHeadersFooters();
        for (HSLFSlide slide : _slides) {
            Integer id;
            HSLFNotes hSLFNotes = slide.getNotes();
            if (hSLFNotes == null || seenNotes.contains(id = Integer.valueOf(hSLFNotes._getSheetNumber()))) continue;
            seenNotes.add(id);
            if (hf != null && hf.isHeaderVisible() && hf.getHeaderText() != null) {
                xhtml.startElement("p", "class", "slide-note-header");
                xhtml.characters(hf.getHeaderText());
                xhtml.endElement("p");
            }
            this.textRunsToText(xhtml, hSLFNotes.getTextParagraphs());
            if (hf == null || !hf.isFooterVisible() || hf.getFooterText() == null) continue;
            xhtml.startElement("p", "class", "slide-note-footer");
            xhtml.characters(hf.getFooterText());
            xhtml.endElement("p");
        }
        this.handleSlideEmbeddedPictures(ss, xhtml);
        if (this.officeParserConfig.getExtractMacros()) {
            this.extractMacros(ss, xhtml);
        }
        xhtml.endElement("div");
    }

    private void extractMacros(HSLFSlideShow ppt, XHTMLContentHandler xhtml) {
        DocInfoListContainer list = (DocInfoListContainer)ppt.getDocumentRecord().findFirstOfType(RecordTypes.List.typeID);
        if (list == null) {
            return;
        }
        VBAInfoContainer vbaInfo = (VBAInfoContainer)list.findFirstOfType(RecordTypes.VBAInfo.typeID);
        if (vbaInfo == null) {
            return;
        }
        VBAInfoAtom vbaAtom = (VBAInfoAtom)vbaInfo.findFirstOfType(RecordTypes.VBAInfoAtom.typeID);
        if (vbaAtom == null) {
            return;
        }
        long persistId = vbaAtom.getPersistIdRef();
        for (HSLFObjectData objData : ppt.getEmbeddedObjects()) {
            if ((long)objData.getExOleObjStg().getPersistId() != persistId) continue;
            try (NPOIFSFileSystem npoifsFileSystem = new NPOIFSFileSystem(objData.getData());){
                try {
                    OfficeParser.extractMacros(npoifsFileSystem, xhtml, EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(this.context));
                }
                catch (IOException | SAXException inner) {
                    EmbeddedDocumentUtil.recordException(inner, this.parentMetadata);
                }
            }
            catch (IOException e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException(e, this.parentMetadata);
            }
        }
    }

    private void extractMaster(XHTMLContentHandler xhtml, HSLFMasterSheet master) throws SAXException {
        if (master == null) {
            return;
        }
        List<HSLFShape> shapes = master.getShapes();
        if (shapes == null || shapes.isEmpty()) {
            return;
        }
        xhtml.startElement("div", "class", "slide-master-content");
        for (HSLFShape shape : shapes) {
            HSLFTextShape tsh;
            String text;
            if (shape == null || HSLFMasterSheet.isPlaceholder(shape) || !(shape instanceof HSLFTextShape) || (text = (tsh = (HSLFTextShape)shape).getText()) == null) continue;
            xhtml.element("p", text);
        }
        xhtml.endElement("div");
    }

    private void extractTableText(XHTMLContentHandler xhtml, HSLFTable shape) throws SAXException {
        xhtml.startElement("table");
        for (int row = 0; row < shape.getNumberOfRows(); ++row) {
            xhtml.startElement("tr");
            for (int col = 0; col < shape.getNumberOfColumns(); ++col) {
                HSLFTableCell cell = shape.getCell(row, col);
                String txt = "";
                if (cell != null) {
                    txt = cell.getText();
                }
                xhtml.element("td", txt);
            }
            xhtml.endElement("tr");
        }
        xhtml.endElement("table");
    }

    private void textRunsToText(XHTMLContentHandler xhtml, List<List<HSLFTextParagraph>> paragraphsList) throws SAXException {
        if (paragraphsList == null) {
            return;
        }
        for (List<HSLFTextParagraph> run : paragraphsList) {
            boolean isBullet = false;
            for (HSLFTextParagraph htp : run) {
                boolean nextBullet = htp.isBullet();
                if (isBullet != nextBullet) {
                    isBullet = nextBullet;
                    if (isBullet) {
                        xhtml.startElement("ul");
                    } else {
                        xhtml.endElement("ul");
                    }
                }
                List<HSLFTextRun> textRuns = htp.getTextRuns();
                String firstLine = HSLFExtractor.removePBreak(textRuns.get(0).getRawText());
                boolean showBullet = isBullet && (textRuns.size() > 1 || !"".equals(firstLine));
                String paraTag = showBullet ? "li" : "p";
                xhtml.startElement(paraTag);
                boolean runIsHyperLink = false;
                for (HSLFTextRun htr : textRuns) {
                    String line;
                    String address;
                    HSLFHyperlink link = htr.getHyperlink();
                    if (link != null && (address = link.getAddress()) != null && !address.startsWith("_ftn")) {
                        xhtml.startElement("a", "href", link.getAddress());
                        runIsHyperLink = true;
                    }
                    if ((line = htr.getRawText()) != null) {
                        boolean isfirst = true;
                        for (String fragment : line.split("\\u000b")) {
                            if (!isfirst) {
                                xhtml.startElement("br");
                                xhtml.endElement("br");
                            }
                            isfirst = false;
                            xhtml.characters(HSLFExtractor.removePBreak(fragment));
                        }
                        if (line.endsWith("\u000b")) {
                            xhtml.startElement("br");
                            xhtml.endElement("br");
                        }
                    }
                    if (runIsHyperLink) {
                        xhtml.endElement("a");
                    }
                    runIsHyperLink = false;
                }
                xhtml.endElement(paraTag);
            }
            if (!isBullet) continue;
            xhtml.endElement("ul");
        }
    }

    private static String removePBreak(String fragment) {
        return fragment.replaceFirst("\\r$", "");
    }

    private void handleSlideEmbeddedPictures(HSLFSlideShow slideshow, XHTMLContentHandler xhtml) throws TikaException, SAXException, IOException {
        for (HSLFPictureData pic : slideshow.getPictureData()) {
            String mediaType;
            switch (pic.getType()) {
                case EMF: {
                    mediaType = "image/emf";
                    break;
                }
                case WMF: {
                    mediaType = "image/wmf";
                    break;
                }
                case DIB: {
                    mediaType = "image/bmp";
                    break;
                }
                default: {
                    mediaType = pic.getContentType();
                }
            }
            byte[] data = null;
            try {
                data = pic.getData();
            }
            catch (Exception e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException(e, this.parentMetadata);
                continue;
            }
            TikaInputStream picIs = TikaInputStream.get(data);
            Throwable throwable = null;
            try {
                this.handleEmbeddedResource(picIs, null, null, mediaType, xhtml, false);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (picIs == null) continue;
                if (throwable != null) {
                    try {
                        picIs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                picIs.close();
            }
        }
    }

    private void handleSlideEmbeddedResources(HSLFSlide slide, XHTMLContentHandler xhtml) throws TikaException, SAXException, IOException {
        List<HSLFShape> shapes;
        try {
            shapes = slide.getShapes();
        }
        catch (NullPointerException e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException(e, this.parentMetadata);
            return;
        }
        for (HSLFShape shape : shapes) {
            if (!(shape instanceof OLEShape)) continue;
            OLEShape oleShape = (OLEShape)shape;
            HSLFObjectData data = null;
            try {
                data = oleShape.getObjectData();
            }
            catch (NullPointerException e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException(e, this.parentMetadata);
                continue;
            }
            if (data == null) continue;
            String objID = Integer.toString(oleShape.getObjectID());
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "class", "class", "CDATA", "embedded");
            attributes.addAttribute("", "id", "id", "CDATA", objID);
            xhtml.startElement("div", attributes);
            xhtml.endElement("div");
            InputStream dataStream = null;
            try {
                dataStream = data.getData();
            }
            catch (Exception e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException(e, this.parentMetadata);
                continue;
            }
            try {
                TikaInputStream stream = TikaInputStream.get(dataStream);
                Throwable throwable = null;
                try {
                    String mediaType = null;
                    if ("Excel.Chart.8".equals(oleShape.getProgID())) {
                        mediaType = "application/vnd.ms-excel";
                    } else {
                        MediaType mt = this.getTikaConfig().getDetector().detect(stream, new Metadata());
                        mediaType = mt.toString();
                    }
                    if (mediaType.equals("application/x-tika-msoffice-embedded; format=comp_obj")) {
                        NPOIFSFileSystem npoifs = new NPOIFSFileSystem(new CloseShieldInputStream(stream));
                        Throwable throwable2 = null;
                        try {
                            this.handleEmbeddedOfficeDoc(npoifs.getRoot(), objID, xhtml);
                            continue;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (npoifs == null) continue;
                            if (throwable2 != null) {
                                try {
                                    npoifs.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            npoifs.close();
                            continue;
                        }
                    }
                    this.handleEmbeddedResource(stream, objID, objID, mediaType, xhtml, false);
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException(e, this.parentMetadata);
            }
        }
    }
}

