/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ner.grobid;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.tika.parser.ner.NERecogniser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrobidNERecogniser
implements NERecogniser {
    private static final Logger LOG = LoggerFactory.getLogger(GrobidNERecogniser.class);
    private static boolean available = false;
    private static final String GROBID_REST_HOST = "http://localhost:8080";
    private String restHostUrlStr;
    public static final Set<String> ENTITY_TYPES = new HashSet<String>(){
        {
            this.add("MEASUREMENT_NUMBERS");
            this.add("MEASUREMENT_UNITS");
            this.add("MEASUREMENTS");
            this.add("NORMALIZED_MEASUREMENTS");
            this.add("MEASUREMENT_TYPES");
        }
    };

    public GrobidNERecogniser() {
        try {
            String restHostUrlStr = "";
            try {
                restHostUrlStr = GrobidNERecogniser.readRestUrl();
            }
            catch (IOException e) {
                LOG.warn("couldn't read rest url", (Throwable)e);
            }
            this.restHostUrlStr = restHostUrlStr == null || restHostUrlStr.equals("") ? GROBID_REST_HOST : restHostUrlStr;
            Response response = WebClient.create(restHostUrlStr).accept("application/json").get();
            int responseCode = response.getStatus();
            if (responseCode == 200) {
                available = true;
            } else {
                LOG.info("Grobid REST Server is not running");
            }
        }
        catch (Exception e) {
            LOG.info(e.getMessage(), (Throwable)e);
        }
    }

    private static String readRestUrl() throws IOException {
        Properties grobidProperties = new Properties();
        grobidProperties.load(GrobidNERecogniser.class.getResourceAsStream("GrobidServer.properties"));
        return grobidProperties.getProperty("grobid.server.url");
    }

    private static String readRestEndpoint() throws IOException {
        Properties grobidProperties = new Properties();
        grobidProperties.load(GrobidNERecogniser.class.getResourceAsStream("GrobidServer.properties"));
        return grobidProperties.getProperty("grobid.endpoint.text");
    }

    @Override
    public boolean isAvailable() {
        return available;
    }

    @Override
    public Set<String> getEntityTypes() {
        return ENTITY_TYPES;
    }

    public JSONArray convertToJSONArray(JSONObject obj, String key) {
        JSONArray jsonArray = new JSONArray();
        try {
            jsonArray = (JSONArray)obj.get(key);
        }
        catch (Exception e) {
            LOG.info(e.getMessage(), (Throwable)e);
        }
        return jsonArray;
    }

    public JSONObject convertToJSONObject(String jsonString) {
        JSONParser parser = new JSONParser();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = (JSONObject)parser.parse(jsonString);
        }
        catch (Exception e) {
            LOG.info(e.getMessage(), (Throwable)e);
        }
        return jsonObject;
    }

    @Override
    public Map<String, Set<String>> recognise(String text) {
        HashMap<String, Set<String>> entities = new HashMap<String, Set<String>>();
        HashSet<String> measurementNumberSet = new HashSet<String>();
        HashSet<String> unitSet = new HashSet<String>();
        HashSet<String> measurementSet = new HashSet<String>();
        HashSet<String> normalizedMeasurementSet = new HashSet<String>();
        HashSet<String> measurementTypeSet = new HashSet<String>();
        try {
            String url = this.restHostUrlStr + GrobidNERecogniser.readRestEndpoint();
            Response response = WebClient.create(url).accept("application/json").post("text=" + text);
            int responseCode = response.getStatus();
            if (responseCode == 200) {
                String result = response.readEntity(String.class);
                JSONObject jsonObject = this.convertToJSONObject(result);
                JSONArray measurements = this.convertToJSONArray(jsonObject, "measurements");
                for (int i = 0; i < measurements.size(); ++i) {
                    JSONObject jsonObj;
                    StringBuffer measurementString = new StringBuffer();
                    StringBuffer normalizedMeasurementString = new StringBuffer();
                    JSONObject quantity = (JSONObject)this.convertToJSONObject(measurements.get(i).toString()).get("quantity");
                    if (quantity == null) continue;
                    if (quantity.containsKey("rawValue")) {
                        String measurementNumber = (String)this.convertToJSONObject(quantity.toString()).get("rawValue");
                        measurementString.append(measurementNumber);
                        measurementString.append(" ");
                        measurementNumberSet.add(measurementNumber);
                    }
                    if (quantity.containsKey("normalizedQuantity")) {
                        String normalizedMeasurementNumber = this.convertToJSONObject(quantity.toString()).get("normalizedQuantity").toString();
                        normalizedMeasurementString.append(normalizedMeasurementNumber);
                        normalizedMeasurementString.append(" ");
                    }
                    if (quantity.containsKey("type")) {
                        String measurementType = (String)this.convertToJSONObject(quantity.toString()).get("type");
                        measurementTypeSet.add(measurementType);
                    }
                    if ((jsonObj = this.convertToJSONObject(quantity.toString())).containsKey("rawUnit")) {
                        JSONObject rawUnit = (JSONObject)jsonObj.get("rawUnit");
                        String unitName = (String)this.convertToJSONObject(rawUnit.toString()).get("name");
                        unitSet.add(unitName);
                        measurementString.append(unitName);
                    }
                    if (jsonObj.containsKey("normalizedUnit")) {
                        JSONObject normalizedUnit = (JSONObject)jsonObj.get("normalizedUnit");
                        String normalizedUnitName = (String)this.convertToJSONObject(normalizedUnit.toString()).get("name");
                        normalizedMeasurementString.append(normalizedUnitName);
                    }
                    if (!measurementString.toString().equals("")) {
                        measurementSet.add(measurementString.toString());
                    }
                    if (normalizedMeasurementString.toString().equals("")) continue;
                    normalizedMeasurementSet.add(normalizedMeasurementString.toString());
                }
                entities.put("MEASUREMENT_NUMBERS", measurementNumberSet);
                entities.put("MEASUREMENT_UNITS", unitSet);
                entities.put("MEASUREMENTS", measurementSet);
                entities.put("NORMALIZED_MEASUREMENTS", normalizedMeasurementSet);
                entities.put("MEASUREMENT_TYPES", measurementTypeSet);
            }
        }
        catch (Exception e) {
            LOG.info(e.getMessage(), (Throwable)e);
        }
        ENTITY_TYPES.clear();
        ENTITY_TYPES.addAll(entities.keySet());
        return entities;
    }
}

