/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.recognition.tf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.tika.config.Field;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.external.ExternalParser;
import org.apache.tika.parser.recognition.ObjectRecogniser;
import org.apache.tika.parser.recognition.RecognisedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TensorflowImageRecParser
extends ExternalParser
implements ObjectRecogniser {
    private static final Logger LOG = LoggerFactory.getLogger(TensorflowImageRecParser.class);
    private static final String SCRIPT_FILE_NAME = "classify_image.py";
    static final Set<MediaType> SUPPORTED_MIMES = Collections.singleton(MediaType.image("jpeg"));
    private static final File DEFAULT_SCRIPT_FILE = new File("tensorflow" + File.separator + "classify_image.py");
    private static final File DEFAULT_MODEL_FILE = new File("tensorflow" + File.separator + "tf-objectrec-model");
    private static final ExternalParser.LineConsumer IGNORED_LINE_LOGGER = new ExternalParser.LineConsumer(){

        @Override
        public void consume(String line) {
            LOG.debug(line);
        }
    };
    @Field
    private String executor = "python";
    @Field
    private File scriptFile = DEFAULT_SCRIPT_FILE;
    @Field
    private String modelArg = "--model_dir";
    @Field
    private File modelFile = DEFAULT_MODEL_FILE;
    @Field
    private String imageArg = "--image_file";
    @Field
    private String outPattern = "(.*) \\(score = ([0-9]+\\.[0-9]+)\\)$";
    @Field
    private String availabilityTestArgs = "";
    private boolean available = false;

    @Override
    public Set<MediaType> getSupportedMimes() {
        return SUPPORTED_MIMES;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public void initialize(Map<String, Param> params) throws TikaConfigException {
        try {
            if (!this.modelFile.exists()) {
                this.modelFile.getParentFile().mkdirs();
                LOG.warn("Model doesn't exist at {}. Expecting the script to download it.", (Object)this.modelFile);
            }
            if (!this.scriptFile.exists()) {
                this.scriptFile.getParentFile().mkdirs();
                LOG.info("Copying script to : {}", (Object)this.scriptFile);
                try (InputStream sourceStream = this.getClass().getResourceAsStream(SCRIPT_FILE_NAME);
                     FileOutputStream destStream = new FileOutputStream(this.scriptFile);){
                    IOUtils.copy(sourceStream, (OutputStream)destStream);
                }
                LOG.debug("Copied..");
            }
            String[] availabilityCheckArgs = new String[]{this.executor, this.scriptFile.getAbsolutePath(), this.modelArg, this.modelFile.getAbsolutePath(), this.availabilityTestArgs};
            this.available = ExternalParser.check(availabilityCheckArgs, new int[0]);
            LOG.debug("Available? {}", (Object)this.available);
            if (!this.available) {
                return;
            }
            String[] parseCmd = new String[]{this.executor, this.scriptFile.getAbsolutePath(), this.modelArg, this.modelFile.getAbsolutePath(), this.imageArg, "${INPUT}", "--out_file", "${OUTPUT}"};
            this.setCommand(parseCmd);
            HashMap<Pattern, String> patterns = new HashMap<Pattern, String>();
            patterns.put(Pattern.compile(this.outPattern), null);
            this.setMetadataExtractionPatterns(patterns);
            this.setIgnoredLineConsumer(IGNORED_LINE_LOGGER);
        }
        catch (Exception e) {
            throw new TikaConfigException(e.getMessage(), e);
        }
    }

    @Override
    public void checkInitialization(InitializableProblemHandler handler) throws TikaConfigException {
    }

    @Override
    public List<RecognisedObject> recognise(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        Metadata md = new Metadata();
        this.parse(stream, handler, md, context);
        ArrayList<RecognisedObject> objects = new ArrayList<RecognisedObject>();
        for (String key : md.names()) {
            double confidence = Double.parseDouble(md.get(key));
            objects.add(new RecognisedObject(key, "eng", key, confidence));
        }
        return objects;
    }
}

