/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.recognition.tf;

import java.net.URI;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;
import org.apache.tika.config.Field;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.parser.recognition.tf.TensorflowRESTRecogniser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TensorflowRESTVideoRecogniser
extends TensorflowRESTRecogniser {
    private static final Logger LOG = LoggerFactory.getLogger(TensorflowRESTRecogniser.class);
    private static final Set<MediaType> SUPPORTED_MIMES = Collections.singleton(MediaType.video("mp4"));
    @Field
    private URI apiUri = URI.create("http://localhost:8764/inception/v4/classify/video?topk=10");

    @Override
    public Set<MediaType> getSupportedMimes() {
        return SUPPORTED_MIMES;
    }

    @Override
    protected URI getApiUri(Metadata metadata) {
        TikaConfig config = TikaConfig.getDefaultConfig();
        String ext = null;
        try {
            MimeType mimeType = config.getMimeRepository().forName(metadata.get("Content-Type"));
            ext = mimeType.getExtension();
            return UriBuilder.fromUri(this.apiUri).queryParam("ext", ext).build(new Object[0]);
        }
        catch (MimeTypeException e) {
            LOG.error("Can't find extension from metadata");
            return this.apiUri;
        }
    }
}

