/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.rtf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.poi.util.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.EndianUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.RTFMetadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.microsoft.OfficeParser;

class RTFObjDataParser {
    private static final String WIN_ASCII = "WINDOWS-1252";
    private final int memoryLimitInKb;

    RTFObjDataParser(int memoryLimitInKb) {
        this.memoryLimitInKb = memoryLimitInKb;
    }

    protected byte[] parse(byte[] bytes, Metadata metadata, AtomicInteger unknownFilenameCount) throws IOException, TikaException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        long version = this.readUInt(is);
        metadata.add(RTFMetadata.EMB_APP_VERSION, Long.toString(version));
        long formatId = this.readUInt(is);
        if (formatId != 2L) {
            return null;
        }
        String className = this.readLengthPrefixedAnsiString(is).trim();
        String topicName = this.readLengthPrefixedAnsiString(is).trim();
        String itemName = this.readLengthPrefixedAnsiString(is).trim();
        if (className != null && className.length() > 0) {
            metadata.add(RTFMetadata.EMB_CLASS, className);
        }
        if (topicName != null && topicName.length() > 0) {
            metadata.add(RTFMetadata.EMB_TOPIC, topicName);
        }
        if (itemName != null && itemName.length() > 0) {
            metadata.add(RTFMetadata.EMB_ITEM, itemName);
        }
        long dataSz = this.readUInt(is);
        byte[] embObjBytes = this.readBytes(is, dataSz);
        if (className.toLowerCase(Locale.ROOT).equals("package")) {
            return this.handlePackage(embObjBytes, metadata);
        }
        if (className.toLowerCase(Locale.ROOT).equals("pbrush")) {
            return embObjBytes;
        }
        ByteArrayInputStream embIs = new ByteArrayInputStream(embObjBytes);
        boolean hasPoifs = false;
        try {
            hasPoifs = NPOIFSFileSystem.hasPOIFSHeader(embIs);
        }
        catch (IOException e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException(e, metadata);
            return embObjBytes;
        }
        if (hasPoifs) {
            try {
                return this.handleEmbeddedPOIFS(embIs, metadata, unknownFilenameCount);
            }
            catch (Exception e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException(e, metadata);
            }
        }
        return embObjBytes;
    }

    private byte[] handleEmbeddedPOIFS(InputStream is, Metadata metadata, AtomicInteger unknownFilenameCount) throws IOException {
        byte[] ret;
        block35: {
            ret = null;
            try (NPOIFSFileSystem fs = new NPOIFSFileSystem(is);){
                DirectoryNode root = fs.getRoot();
                if (root == null) {
                    byte[] byArray = ret;
                    return byArray;
                }
                if (root.hasEntry("Package")) {
                    Entry ooxml = root.getEntry("Package");
                    TikaInputStream stream = TikaInputStream.get(new DocumentInputStream((DocumentEntry)ooxml));
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IOUtils.copy(stream, out);
                    ret = out.toByteArray();
                    break block35;
                }
                OfficeParser.POIFSDocumentType type = OfficeParser.POIFSDocumentType.detectType(root);
                if (type == OfficeParser.POIFSDocumentType.OLE10_NATIVE) {
                    try {
                        Ole10Native ole = Ole10Native.createFromEmbeddedOleObject(root);
                        ret = ole.getDataBuffer();
                    }
                    catch (Ole10NativeException ole) {}
                    break block35;
                }
                if (type == OfficeParser.POIFSDocumentType.COMP_OBJ) {
                    DocumentEntry contentsEntry;
                    try {
                        contentsEntry = (DocumentEntry)root.getEntry("CONTENTS");
                    }
                    catch (FileNotFoundException ioe) {
                        contentsEntry = (DocumentEntry)root.getEntry("Contents");
                    }
                    try (DocumentInputStream inp = new DocumentInputStream(contentsEntry);){
                        ret = new byte[contentsEntry.getSize()];
                        inp.readFully(ret);
                        break block35;
                    }
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                is.reset();
                IOUtils.copy(is, out);
                ret = out.toByteArray();
                metadata.set("resourceName", "file_" + unknownFilenameCount.getAndIncrement() + "." + type.getExtension());
                metadata.set("Content-Type", type.getType().toString());
            }
        }
        return ret;
    }

    private byte[] handlePackage(byte[] pkgBytes, Metadata metadata) throws IOException, TikaException {
        ByteArrayInputStream is = new ByteArrayInputStream(pkgBytes);
        this.readUShort(is);
        String displayName = this.readAnsiString(is);
        this.readAnsiString(is);
        try {
            EndianUtils.readUShortBE(is);
        }
        catch (EndianUtils.BufferUnderrunException e) {
            throw new IOException(e);
        }
        int type = this.readUShort(is);
        if (type != 3) {
            return null;
        }
        this.readUInt(is);
        String ansiFilePath = this.readAnsiString(is);
        long bytesLen = this.readUInt(is);
        byte[] objBytes = this.initByteArray(bytesLen);
        IOUtils.readFully(is, objBytes);
        StringBuilder unicodeFilePath = new StringBuilder();
        try {
            long unicodeLen = this.readUInt(is);
            int i = 0;
            while ((long)i < unicodeLen) {
                int lo = is.read();
                int hi = is.read();
                int sum = lo + 256 * hi;
                if (hi == -1 || lo == -1) {
                    unicodeFilePath.setLength(0);
                    break;
                }
                unicodeFilePath.append((char)sum);
                ++i;
            }
        }
        catch (IOException e) {
            unicodeFilePath.setLength(0);
        }
        String fileNameToUse = "";
        String pathToUse = "";
        if (unicodeFilePath.length() > 0) {
            String p;
            fileNameToUse = p = unicodeFilePath.toString();
            pathToUse = p;
        } else {
            fileNameToUse = displayName == null ? "" : displayName;
            pathToUse = ansiFilePath == null ? "" : ansiFilePath;
        }
        metadata.set(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, fileNameToUse);
        metadata.set("resourceName", FilenameUtils.getName((String)fileNameToUse));
        metadata.set("embeddedRelationshipId", pathToUse);
        return objBytes;
    }

    private int readUShort(InputStream is) throws IOException {
        try {
            return EndianUtils.readUShortLE(is);
        }
        catch (EndianUtils.BufferUnderrunException e) {
            throw new IOException(e);
        }
    }

    private long readUInt(InputStream is) throws IOException {
        try {
            return EndianUtils.readUIntLE(is);
        }
        catch (EndianUtils.BufferUnderrunException e) {
            throw new IOException(e);
        }
    }

    private String readAnsiString(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        int c = is.read();
        while (c > 0) {
            sb.append((char)c);
            c = is.read();
        }
        if (c == -1) {
            throw new IOException("Hit end of stream before end of AnsiString");
        }
        return sb.toString();
    }

    private String readLengthPrefixedAnsiString(InputStream is) throws IOException, TikaException {
        long len = this.readUInt(is);
        byte[] bytes = this.readBytes(is, len);
        try {
            return new String(bytes, WIN_ASCII);
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("Unsupported encoding");
        }
    }

    private byte[] readBytes(InputStream is, long len) throws IOException, TikaException {
        byte[] bytes = this.initByteArray(len);
        IOUtils.readFully(is, bytes);
        return bytes;
    }

    private byte[] initByteArray(long len) throws IOException, TikaException {
        if (len < 0L) {
            throw new IOException("Requested length for reading bytes < 0?!: " + len);
        }
        if (this.memoryLimitInKb > -1 && len > (long)(this.memoryLimitInKb * 1024)) {
            throw new TikaMemoryLimitException("File embedded in RTF caused this (" + len + ") bytes), but maximum allowed is (" + this.memoryLimitInKb * 1024 + ").If this is a valid RTF file, consider increasing the memory limit via TikaConfig.");
        }
        if (len > Integer.MAX_VALUE) {
            throw new TikaMemoryLimitException("File embedded in RTF caused this (" + len + ") bytes), but there is a hard limit of Integer.MAX_VALUE+");
        }
        return new byte[(int)len];
    }
}

