/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.sentiment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import opennlp.tools.sentiment.SentimentME;
import opennlp.tools.sentiment.SentimentModel;
import org.apache.commons.io.IOUtils;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SentimentAnalysisParser
extends AbstractParser
implements Initializable {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application("sentiment"));
    private static final Logger LOG = LoggerFactory.getLogger(SentimentAnalysisParser.class);
    public static final String DEF_MODEL = "https://raw.githubusercontent.com/USCDataScience/SentimentAnalysisParser/master/sentiment-models/en-netflix-sentiment.bin";
    private SentimentME classifier;
    @Field
    private String modelPath = "https://raw.githubusercontent.com/USCDataScience/SentimentAnalysisParser/master/sentiment-models/en-netflix-sentiment.bin";

    @Override
    public void initialize(Map<String, Param> params) throws TikaConfigException {
        LOG.debug("Initializing...");
        if (this.modelPath == null) {
            throw new TikaConfigException("Parameter 'modelPath' is required but it is not set");
        }
        try {
            URL resolvedUrl = null;
            if (this.modelPath.startsWith("http://") || this.modelPath.startsWith("https://")) {
                resolvedUrl = new URL(this.modelPath);
            } else {
                resolvedUrl = this.getClass().getClassLoader().getResource(this.modelPath);
                File file = new File(this.modelPath);
                if (file.exists()) {
                    resolvedUrl = file.toURI().toURL();
                }
            }
            if (resolvedUrl == null) {
                throw new TikaConfigException("Model doesn't exists :" + this.modelPath);
            }
            LOG.info("Sentiment Model is at {}", (Object)resolvedUrl);
            long st = System.currentTimeMillis();
            SentimentModel model = new SentimentModel(resolvedUrl);
            long time = System.currentTimeMillis() - st;
            LOG.debug("time taken to load model {}", (Object)time);
            this.classifier = new SentimentME(model);
        }
        catch (Exception e) {
            LOG.warn("Failed to load sentiment model from {}" + this.modelPath);
            throw new TikaConfigException(e.getMessage(), e);
        }
    }

    @Override
    public void checkInitialization(InitializableProblemHandler handler) throws TikaConfigException {
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (this.classifier == null) {
            LOG.warn(this.getClass().getSimpleName() + " is not configured properly.");
            return;
        }
        String inputString = IOUtils.toString((InputStream)stream, (String)"UTF-8");
        String sentiment = this.classifier.predict(inputString);
        metadata.add("Sentiment", sentiment);
    }
}

