/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.camel.spi.MaskingFormatter;

public class DefaultMaskingFormatter
implements MaskingFormatter {
    private static final Set<String> DEFAULT_KEYWORDS = new HashSet<String>(Arrays.asList("passphrase", "password", "secretKey"));
    private Set<String> keywords;
    private boolean maskKeyValue;
    private boolean maskXmlElement;
    private boolean maskJson;
    private String maskString = "xxxxx";
    private Pattern keyValueMaskPattern;
    private Pattern xmlElementMaskPattern;
    private Pattern jsonMaskPattern;

    public DefaultMaskingFormatter() {
        this(DEFAULT_KEYWORDS, true, true, true);
    }

    public DefaultMaskingFormatter(boolean maskKeyValue, boolean maskXml, boolean maskJson) {
        this(DEFAULT_KEYWORDS, maskKeyValue, maskXml, maskJson);
    }

    public DefaultMaskingFormatter(Set<String> keywords, boolean maskKeyValue, boolean maskXmlElement, boolean maskJson) {
        this.keywords = keywords;
        this.setMaskKeyValue(maskKeyValue);
        this.setMaskXmlElement(maskXmlElement);
        this.setMaskJson(maskJson);
    }

    @Override
    public String format(String source) {
        if (this.keywords == null || this.keywords.isEmpty()) {
            return source;
        }
        String answer = source;
        if (this.maskKeyValue) {
            answer = this.keyValueMaskPattern.matcher(answer).replaceAll("$1\"" + this.maskString + "\"");
        }
        if (this.maskXmlElement) {
            answer = this.xmlElementMaskPattern.matcher(answer).replaceAll("$1" + this.maskString + "$3");
        }
        if (this.maskJson) {
            answer = this.jsonMaskPattern.matcher(answer).replaceAll("$1\"" + this.maskString + "\"");
        }
        return answer;
    }

    public boolean isMaskKeyValue() {
        return this.maskKeyValue;
    }

    public void setMaskKeyValue(boolean maskKeyValue) {
        this.maskKeyValue = maskKeyValue;
        this.keyValueMaskPattern = maskKeyValue ? this.createKeyValueMaskPattern(this.keywords) : null;
    }

    public boolean isMaskXmlElement() {
        return this.maskXmlElement;
    }

    public void setMaskXmlElement(boolean maskXml) {
        this.maskXmlElement = maskXml;
        this.xmlElementMaskPattern = maskXml ? this.createXmlElementMaskPattern(this.keywords) : null;
    }

    public boolean isMaskJson() {
        return this.maskJson;
    }

    public void setMaskJson(boolean maskJson) {
        this.maskJson = maskJson;
        this.jsonMaskPattern = maskJson ? this.createJsonMaskPattern(this.keywords) : null;
    }

    public String getMaskString() {
        return this.maskString;
    }

    public void setMaskString(String maskString) {
        this.maskString = maskString;
    }

    protected Pattern createKeyValueMaskPattern(Set<String> keywords) {
        StringBuilder regex = this.createOneOfThemRegex(keywords);
        if (regex == null) {
            return null;
        }
        regex.insert(0, "([\\w]*(?:");
        regex.append(")[\\w]*[\\s]*?=[\\s]*?)([\\S&&[^'\",\\}\\]\\)]]+[\\S&&[^,\\}\\]\\)>]]*?|\"[^\"]*?\"|'[^']*?')");
        return Pattern.compile(regex.toString(), 2);
    }

    protected Pattern createXmlElementMaskPattern(Set<String> keywords) {
        StringBuilder regex = this.createOneOfThemRegex(keywords);
        if (regex == null) {
            return null;
        }
        regex.insert(0, "(<([\\w]*(?:");
        regex.append(")[\\w]*)(?:[\\s]+.+)*?>[\\s]*?)(?:[\\S&&[^<]]+(?:\\s+[\\S&&[^<]]+)*?)([\\s]*?</\\2>)");
        return Pattern.compile(regex.toString(), 2);
    }

    protected Pattern createJsonMaskPattern(Set<String> keywords) {
        StringBuilder regex = this.createOneOfThemRegex(keywords);
        if (regex == null) {
            return null;
        }
        regex.insert(0, "(\"(?:[^\"]|(?:\\\"))*?(?:");
        regex.append(")(?:[^\"]|(?:\\\"))*?\"\\s*?\\:\\s*?)(?:\"(?:[^\"]|(?:\\\"))*?\")");
        return Pattern.compile(regex.toString(), 2);
    }

    protected StringBuilder createOneOfThemRegex(Set<String> keywords) {
        StringBuilder regex = new StringBuilder();
        if (keywords == null || keywords.isEmpty()) {
            return null;
        }
        String[] strKeywords = keywords.toArray(new String[0]);
        regex.append(Pattern.quote(strKeywords[0]));
        if (strKeywords.length > 1) {
            for (int i = 1; i < strKeywords.length; ++i) {
                regex.append('|');
                regex.append(Pattern.quote(strKeywords[i]));
            }
        }
        return regex;
    }
}

