/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.consumer.streaming;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.TweeterStatusListener;
import org.apache.camel.component.twitter.consumer.Twitter4JConsumer;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusListener;
import twitter4j.TwitterException;
import twitter4j.TwitterStream;

public abstract class StreamingConsumer
extends Twitter4JConsumer
implements StatusListener {
    protected final TwitterStream twitterStream;
    private final List<Status> receivedStatuses = new ArrayList<Status>();
    private volatile boolean clear;
    private TweeterStatusListener tweeterStatusListener;

    public StreamingConsumer(TwitterEndpoint te) {
        super(te);
        this.twitterStream = te.getProperties().createTwitterStream();
        this.twitterStream.addListener(this);
    }

    public List<Status> pollConsume() throws TwitterException {
        this.clear = true;
        return Collections.unmodifiableList(new ArrayList<Status>(this.receivedStatuses));
    }

    public List<Status> directConsume() throws TwitterException {
        return null;
    }

    @Override
    public void onException(Exception ex) {
    }

    @Override
    public void onStatus(Status status) {
        if (this.tweeterStatusListener != null) {
            this.tweeterStatusListener.onStatus(status);
        } else {
            if (this.clear) {
                this.receivedStatuses.clear();
                this.clear = false;
            }
            this.receivedStatuses.add(status);
        }
    }

    @Override
    public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
    }

    @Override
    public void onTrackLimitationNotice(int numberOfLimitedStatuses) {
    }

    @Override
    public void onScrubGeo(long userId, long upToStatusId) {
    }

    public void registerTweetListener(TweeterStatusListener tweeterStatusListener) {
        this.tweeterStatusListener = tweeterStatusListener;
    }

    public void unregisterTweetListener(TweeterStatusListener tweeterStatusListener) {
        this.tweeterStatusListener = null;
    }

    public void doStart() {
        this.startStreaming();
    }

    public void doStop() {
        this.twitterStream.shutdown();
    }

    protected abstract void startStreaming();
}

