/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.directmessage;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import twitter4j.User;

public class DirectMessageProducer
extends DefaultProducer {
    private TwitterEndpoint endpoint;
    private String user;

    public DirectMessageProducer(TwitterEndpoint endpoint, String user) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.user = user;
    }

    public void process(Exchange exchange) throws Exception {
        String toUsername = this.user;
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelTwitterUser", String.class))) {
            toUsername = (String)exchange.getIn().getHeader("CamelTwitterUser", String.class);
        }
        String text = (String)exchange.getIn().getBody(String.class);
        if (toUsername.isEmpty()) {
            throw new CamelExchangeException("Username not configured on TwitterEndpoint", exchange);
        }
        this.log.debug("Sending to: {} message: {}", (Object)toUsername, (Object)text);
        User userStatus = this.endpoint.getProperties().getTwitter().showUser(toUsername);
        this.endpoint.getProperties().getTwitter().sendDirectMessage(userStatus.getId(), text);
    }
}

