/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.streaming;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.Exchange;
import org.apache.camel.Service;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.AbstractTwitterConsumerHandler;
import org.apache.camel.component.twitter.consumer.TwitterEventListener;
import org.apache.camel.component.twitter.consumer.TwitterEventType;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusListener;
import twitter4j.TwitterException;
import twitter4j.TwitterStream;

public abstract class AbstractStreamingConsumerHandler
extends AbstractTwitterConsumerHandler
implements StatusListener,
Service {
    private final TwitterStream twitterStream;
    private final List<Exchange> receivedStatuses = new ArrayList<Exchange>();
    private final AtomicReference<TwitterEventListener> twitterEventListener;
    private boolean clear;

    public AbstractStreamingConsumerHandler(TwitterEndpoint te) {
        super(te);
        this.twitterStream = te.getProperties().createTwitterStream();
        this.twitterStream.addListener(this);
        this.twitterEventListener = new AtomicReference();
        this.clear = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Exchange> pollConsume() throws TwitterException {
        List<Exchange> result;
        List<Exchange> list = this.receivedStatuses;
        synchronized (list) {
            this.clear = true;
            result = Collections.unmodifiableList(new ArrayList<Exchange>(this.receivedStatuses));
        }
        return result;
    }

    @Override
    public List<Exchange> directConsume() throws TwitterException {
        return Collections.emptyList();
    }

    @Override
    public void onException(Exception ex) {
    }

    @Override
    public void onStatus(Status status) {
        this.onEvent(TwitterEventType.STATUS.createExchange(this.endpoint, status));
    }

    @Override
    public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
    }

    @Override
    public void onTrackLimitationNotice(int numberOfLimitedStatuses) {
    }

    @Override
    public void onScrubGeo(long userId, long upToStatusId) {
    }

    public void setEventListener(TwitterEventListener tweeterStatusListener) {
        this.twitterEventListener.set(tweeterStatusListener);
    }

    public void removeEventListener(TwitterEventListener tweeterStatusListener) {
        this.twitterEventListener.compareAndSet(tweeterStatusListener, null);
    }

    public void stop() {
        this.twitterStream.removeListener(this);
        this.twitterStream.shutdown();
        this.twitterStream.cleanUp();
    }

    protected TwitterStream getTwitterStream() {
        return this.twitterStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEvent(Exchange exchange) {
        TwitterEventListener listener = this.twitterEventListener.get();
        if (listener != null) {
            listener.onEvent(exchange);
        } else {
            List<Exchange> list = this.receivedStatuses;
            synchronized (list) {
                if (this.clear) {
                    this.receivedStatuses.clear();
                    this.clear = false;
                }
                this.receivedStatuses.add(exchange);
            }
        }
    }
}

