/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import java.util.Map;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.apache.camel.component.twitter.TwitterConfiguration;
import twitter4j.Twitter;
import twitter4j.TwitterException;

public final class TwitterComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    public TwitterComponentVerifierExtension() {
        this("twitter");
    }

    public TwitterComponentVerifierExtension(String scheme) {
        super(scheme);
    }

    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption((String)"accessToken", parameters)).error(ResultErrorHelper.requiresOption((String)"accessTokenSecret", parameters)).error(ResultErrorHelper.requiresOption((String)"consumerKey", parameters)).error(ResultErrorHelper.requiresOption((String)"consumerSecret", parameters));
        super.verifyParametersAgainstCatalog(builder, parameters);
        return builder.build();
    }

    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        return ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY).error(parameters, this::verifyCredentials).build();
    }

    private void verifyCredentials(ResultBuilder builder, Map<String, Object> parameters) throws Exception {
        try {
            TwitterConfiguration configuration = (TwitterConfiguration)this.setProperties(new TwitterConfiguration(), parameters);
            Twitter twitter = configuration.getTwitter();
            twitter.verifyCredentials();
        }
        catch (TwitterException e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)e.getErrorMessage()).detail("twitter_error_code", (Object)e.getErrorCode()).detail("twitter_status_code", (Object)e.getStatusCode()).detail("twitter_exception_code", (Object)e.getExceptionCode()).detail("twitter_exception_message", (Object)e.getMessage()).detail("twitter_exception_caused-by-network-issue", (Object)e.isCausedByNetworkIssue()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS, (Object)e.getClass().getName()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE, (Object)e);
            if (e.getErrorCode() == 89) {
                errorBuilder.parameterKey("accessToken");
            }
            builder.error(errorBuilder.build());
        }
    }
}

