/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.encoding;

import io.undertow.UndertowLogger;
import io.undertow.conduits.GzipStreamSinkConduit;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.util.ConduitFactory;
import org.xnio.conduits.StreamSinkConduit;

public class GzipEncodingProvider
implements ContentEncodingProvider {
    private final int deflateLevel;

    public GzipEncodingProvider() {
        this(-1);
    }

    public GzipEncodingProvider(int deflateLevel) {
        this.deflateLevel = deflateLevel;
    }

    @Override
    public ConduitWrapper<StreamSinkConduit> getResponseWrapper() {
        return new ConduitWrapper<StreamSinkConduit>(){

            @Override
            public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
                UndertowLogger.REQUEST_LOGGER.tracef("Created GZIP response conduit for %s", (Object)exchange);
                return new GzipStreamSinkConduit(factory, exchange, GzipEncodingProvider.this.deflateLevel);
            }
        };
    }
}

