/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import java.net.URI;
import org.apache.camel.component.undertow.HttpHandlerRegistrationInfo;
import org.apache.camel.component.undertow.UndertowHost;
import org.apache.camel.component.undertow.UndertowHostKey;
import org.apache.camel.component.undertow.UndertowHostOptions;
import org.apache.camel.component.undertow.handlers.CamelRootHandler;
import org.apache.camel.component.undertow.handlers.NotFoundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUndertowHost
implements UndertowHost {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUndertowHost.class);
    private final UndertowHostKey key;
    private final UndertowHostOptions options;
    private final CamelRootHandler rootHandler;
    private Undertow undertow;
    private String hostString;

    public DefaultUndertowHost(UndertowHostKey key) {
        this(key, null);
    }

    public DefaultUndertowHost(UndertowHostKey key, UndertowHostOptions options) {
        this.key = key;
        this.options = options;
        this.rootHandler = new CamelRootHandler(new NotFoundHandler());
    }

    @Override
    public void validateEndpointURI(URI httpURI) {
    }

    @Override
    public synchronized HttpHandler registerHandler(HttpHandlerRegistrationInfo registrationInfo, HttpHandler handler) {
        if (this.undertow == null) {
            Undertow.Builder builder = Undertow.builder();
            if (this.key.getSslContext() != null) {
                builder.addHttpsListener(this.key.getPort(), this.key.getHost(), this.key.getSslContext());
            } else {
                builder.addHttpListener(this.key.getPort(), this.key.getHost());
            }
            if (this.options != null) {
                if (this.options.getIoThreads() != null) {
                    builder.setIoThreads(this.options.getIoThreads());
                }
                if (this.options.getWorkerThreads() != null) {
                    builder.setWorkerThreads(this.options.getWorkerThreads());
                }
                if (this.options.getBufferSize() != null) {
                    builder.setBufferSize(this.options.getBufferSize());
                }
                if (this.options.getDirectBuffers() != null) {
                    builder.setDirectBuffers(this.options.getDirectBuffers());
                }
                if (this.options.getHttp2Enabled() != null) {
                    builder.setServerOption(UndertowOptions.ENABLE_HTTP2, this.options.getHttp2Enabled());
                }
            }
            this.undertow = builder.setHandler(this.rootHandler).build();
            LOG.info("Starting Undertow server on {}://{}:{}", new Object[]{this.key.getSslContext() != null ? "https" : "http", this.key.getHost(), this.key.getPort()});
            try {
                this.undertow.start();
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to start Undertow server on {}://{}:{}, reason: {}", new Object[]{this.key.getSslContext() != null ? "https" : "http", this.key.getHost(), this.key.getPort(), e.getMessage()});
                this.undertow.stop();
                this.undertow = null;
                throw e;
            }
        }
        return this.rootHandler.add(registrationInfo.getUri().getPath(), registrationInfo.getMethodRestrict(), registrationInfo.isMatchOnUriPrefix(), handler);
    }

    @Override
    public synchronized void unregisterHandler(HttpHandlerRegistrationInfo registrationInfo) {
        if (this.undertow == null) {
            return;
        }
        this.rootHandler.remove(registrationInfo.getUri().getPath(), registrationInfo.getMethodRestrict(), registrationInfo.isMatchOnUriPrefix());
        if (this.rootHandler.isEmpty()) {
            LOG.info("Stopping Undertow server on {}://{}:{}", new Object[]{this.key.getSslContext() != null ? "https" : "http", this.key.getHost(), this.key.getPort()});
            this.undertow.stop();
            this.undertow = null;
        }
    }

    public String toString() {
        if (this.hostString == null) {
            this.hostString = String.format("DefaultUndertowHost[%s://%s:%s]", this.key.getSslContext() != null ? "https" : "http", this.key.getHost(), this.key.getPort());
        }
        return this.hostString;
    }
}

