/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.UndertowHelper;
import org.apache.camel.component.undertow.UndertowHttpBinding;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpOperationFailedException;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;

class UndertowClientCallback
implements ClientCallback<ClientConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowClientCallback.class);
    protected final UndertowEndpoint endpoint;
    protected final Exchange exchange;
    protected final ClientRequest request;
    protected final AsyncCallback callback;
    protected final BlockingDeque<Closeable> closables = new LinkedBlockingDeque<Closeable>();
    private final ByteBuffer body;
    private final Boolean throwExceptionOnFailure;

    UndertowClientCallback(Exchange exchange, AsyncCallback callback, UndertowEndpoint endpoint, ClientRequest request, ByteBuffer body) {
        this.exchange = exchange;
        this.callback = callback;
        this.endpoint = endpoint;
        this.request = request;
        this.body = body;
        this.throwExceptionOnFailure = endpoint.getThrowExceptionOnFailure();
    }

    @Override
    public void completed(ClientConnection connection) {
        this.deferClose(connection);
        connection.sendRequest(this.request, this.on(this::performClientExchange));
    }

    @Override
    public void failed(IOException e) {
        this.hasFailedWith(e);
    }

    ChannelListener<StreamSinkChannel> asyncWriter(ByteBuffer body) {
        return channel -> {
            try {
                UndertowClientCallback.write(channel, body);
                if (body.hasRemaining()) {
                    channel.resumeWrites();
                } else {
                    UndertowClientCallback.flush(channel);
                }
            }
            catch (IOException e) {
                this.hasFailedWith(e);
            }
        };
    }

    void deferClose(Closeable closeable) {
        try {
            this.closables.putFirst(closeable);
        }
        catch (InterruptedException e) {
            this.hasFailedWith(e);
        }
    }

    protected void finish(Message result) {
        this.finish(result, true);
    }

    protected void finish(Message result, boolean close) {
        if (close) {
            this.closables.forEach(IoUtils::safeClose);
        }
        if (result != null) {
            if (ExchangeHelper.isOutCapable((Exchange)this.exchange)) {
                this.exchange.setOut(result);
            } else {
                this.exchange.setIn(result);
            }
        }
        this.callback.done(false);
    }

    void hasFailedWith(Throwable e) {
        LOG.trace("Exchange has failed with", e);
        if (Boolean.TRUE.equals(this.throwExceptionOnFailure)) {
            this.exchange.setException(e);
        }
        this.finish(null);
    }

    protected <T> ClientCallback<T> on(Consumer<T> consumer) {
        return new ErrorHandlingClientCallback(consumer);
    }

    void performClientExchange(ClientExchange clientExchange) {
        this.setupResponseListener(clientExchange);
        this.writeRequest(clientExchange);
    }

    void setupResponseListener(ClientExchange clientExchange) {
        clientExchange.setResponseListener(this.on(response -> {
            LOG.trace("completed: {}", (Object)clientExchange);
            try {
                this.storeCookies(clientExchange);
                UndertowHttpBinding binding = this.endpoint.getUndertowHttpBinding();
                Message result = binding.toCamelMessage(clientExchange, this.exchange);
                int code = clientExchange.getResponse().getResponseCode();
                LOG.debug("Http responseCode: {}", (Object)code);
                boolean ok = HttpHelper.isStatusCodeOk(code, "200-299");
                if (!ok && this.throwExceptionOnFailure.booleanValue()) {
                    String uri = this.endpoint.getHttpURI().toString();
                    String statusText = clientExchange.getResponse().getStatus();
                    Map<String, String> headers = result.getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
                    String bodyText = (String)ExchangeHelper.convertToType((Exchange)this.exchange, String.class, (Object)result.getBody());
                    HttpOperationFailedException cause = new HttpOperationFailedException(uri, code, statusText, null, headers, bodyText);
                    if (ExchangeHelper.isOutCapable((Exchange)this.exchange)) {
                        this.exchange.setOut(result);
                    } else {
                        this.exchange.setIn(result);
                    }
                    this.hasFailedWith((Throwable)((Object)cause));
                } else {
                    this.finish(result);
                }
            }
            catch (Throwable e) {
                this.hasFailedWith(e);
            }
        }));
    }

    void storeCookies(ClientExchange clientExchange) throws IOException, URISyntaxException {
        if (this.endpoint.getCookieHandler() != null) {
            String url = UndertowHelper.createURL(this.exchange, this.endpoint);
            URI uri = UndertowHelper.createURI(this.exchange, url, this.endpoint);
            HeaderMap headerMap = clientExchange.getResponse().getResponseHeaders();
            HashMap<String, List<String>> m = new HashMap<String, List<String>>();
            for (HttpString headerName : headerMap.getHeaderNames()) {
                LinkedList<String> headerValue = new LinkedList<String>();
                for (int i = 0; i < headerMap.count(headerName); ++i) {
                    headerValue.add(headerMap.get(headerName, i));
                }
                m.put(headerName.toString(), headerValue);
            }
            this.endpoint.getCookieHandler().storeCookies(this.exchange, uri, m);
        }
    }

    protected void writeRequest(ClientExchange clientExchange) {
        StreamSinkChannel requestChannel = clientExchange.getRequestChannel();
        if (this.body != null) {
            try {
                UndertowClientCallback.write(requestChannel, this.body);
                if (this.body.hasRemaining()) {
                    requestChannel.getWriteSetter().set(this.asyncWriter(this.body));
                    requestChannel.resumeWrites();
                } else {
                    UndertowClientCallback.flush(requestChannel);
                }
            }
            catch (IOException e) {
                this.hasFailedWith(e);
            }
        }
    }

    static void flush(StreamSinkChannel channel) throws IOException {
        channel.shutdownWrites();
        if (!channel.flush()) {
            ChannelListener<StreamSinkChannel> safeClose = IoUtils::safeClose;
            ChannelExceptionHandler<Channel> closingChannelExceptionHandler = ChannelListeners.closingChannelExceptionHandler();
            ChannelListener<Channel> flushingChannelListener = ChannelListeners.flushingChannelListener(safeClose, closingChannelExceptionHandler);
            channel.getWriteSetter().set(flushingChannelListener);
            channel.resumeWrites();
        }
    }

    static void write(StreamSinkChannel channel, ByteBuffer body) throws IOException {
        int written = 1;
        while (body.hasRemaining() && written > 0) {
            written = channel.write(body);
        }
    }

    final class ErrorHandlingClientCallback<T>
    implements ClientCallback<T> {
        private final Consumer<T> consumer;

        private ErrorHandlingClientCallback(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void completed(T result) {
            this.consumer.accept(result);
        }

        @Override
        public void failed(IOException e) {
            UndertowClientCallback.this.hasFailedWith(e);
        }
    }
}

