/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.attachment;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.activation.DataHandler;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.attachment.Attachment;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.attachment.DefaultAttachment;

public final class DefaultAttachmentMessage
implements AttachmentMessage {
    private static final String ATTACHMENT_OBJECTS = "CamelAttachmentObjects";
    private final Message delegate;

    public DefaultAttachmentMessage(Message delegate) {
        this.delegate = delegate;
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    @Override
    public String getMessageId() {
        return this.delegate.getMessageId();
    }

    @Override
    public void setMessageId(String messageId) {
        this.delegate.setMessageId(messageId);
    }

    @Override
    public Exchange getExchange() {
        return this.delegate.getExchange();
    }

    @Override
    public Object getHeader(String name) {
        return this.delegate.getHeader(name);
    }

    @Override
    public Object getHeader(String name, Object defaultValue) {
        return this.delegate.getHeader(name, defaultValue);
    }

    @Override
    public Object getHeader(String name, Supplier<Object> defaultValueSupplier) {
        return this.delegate.getHeader(name, defaultValueSupplier);
    }

    @Override
    public <T> T getHeader(String name, Class<T> type) {
        return this.delegate.getHeader(name, type);
    }

    @Override
    public <T> T getHeader(String name, Object defaultValue, Class<T> type) {
        return this.delegate.getHeader(name, defaultValue, type);
    }

    @Override
    public <T> T getHeader(String name, Supplier<Object> defaultValueSupplier, Class<T> type) {
        return this.delegate.getHeader(name, defaultValueSupplier, type);
    }

    @Override
    public void setHeader(String name, Object value) {
        this.delegate.setHeader(name, value);
    }

    @Override
    public Object removeHeader(String name) {
        return this.delegate.removeHeader(name);
    }

    @Override
    public boolean removeHeaders(String pattern) {
        return this.delegate.removeHeaders(pattern);
    }

    @Override
    public boolean removeHeaders(String pattern, String ... excludePatterns) {
        return this.delegate.removeHeaders(pattern, excludePatterns);
    }

    @Override
    public Map<String, Object> getHeaders() {
        return this.delegate.getHeaders();
    }

    @Override
    public void setHeaders(Map<String, Object> headers) {
        this.delegate.setHeaders(headers);
    }

    @Override
    public boolean hasHeaders() {
        return this.delegate.hasHeaders();
    }

    @Override
    public Object getBody() {
        return this.delegate.getBody();
    }

    @Override
    public Object getMandatoryBody() throws InvalidPayloadException {
        return this.delegate.getMandatoryBody();
    }

    @Override
    public <T> T getBody(Class<T> type) {
        return this.delegate.getBody(type);
    }

    @Override
    public <T> T getMandatoryBody(Class<T> type) throws InvalidPayloadException {
        return this.delegate.getMandatoryBody(type);
    }

    @Override
    public void setBody(Object body) {
        this.delegate.setBody(body);
    }

    @Override
    public <T> void setBody(Object body, Class<T> type) {
        this.delegate.setBody(body, type);
    }

    @Override
    public Message copy() {
        return this.delegate.copy();
    }

    @Override
    public void copyFrom(Message message) {
        this.delegate.copyFrom(message);
    }

    @Override
    public void copyFromWithNewBody(Message message, Object newBody) {
        this.delegate.copyFromWithNewBody(message, newBody);
    }

    @Override
    public DataHandler getAttachment(String id) {
        Attachment att;
        Map map = this.getExchange().getProperty(ATTACHMENT_OBJECTS, Map.class);
        if (map != null && (att = (Attachment)map.get(id)) != null) {
            return att.getDataHandler();
        }
        return null;
    }

    @Override
    public Attachment getAttachmentObject(String id) {
        Map map = this.getExchange().getProperty(ATTACHMENT_OBJECTS, Map.class);
        if (map != null) {
            return (Attachment)map.get(id);
        }
        return null;
    }

    @Override
    public Set<String> getAttachmentNames() {
        Map map = this.getExchange().getProperty(ATTACHMENT_OBJECTS, Map.class);
        if (map != null) {
            return map.keySet();
        }
        return null;
    }

    @Override
    public void removeAttachment(String id) {
        Map map = this.getExchange().getProperty(ATTACHMENT_OBJECTS, Map.class);
        if (map != null) {
            map.remove(id);
        }
    }

    @Override
    public void addAttachment(String id, DataHandler content) {
        LinkedHashMap<String, DefaultAttachment> map = this.getExchange().getProperty(ATTACHMENT_OBJECTS, Map.class);
        if (map == null) {
            map = new LinkedHashMap<String, DefaultAttachment>();
            this.getExchange().setProperty(ATTACHMENT_OBJECTS, map);
        }
        map.put(id, new DefaultAttachment(content));
    }

    @Override
    public void addAttachmentObject(String id, Attachment content) {
        LinkedHashMap<String, Attachment> map = this.getExchange().getProperty(ATTACHMENT_OBJECTS, Map.class);
        if (map == null) {
            map = new LinkedHashMap<String, Attachment>();
            this.getExchange().setProperty(ATTACHMENT_OBJECTS, map);
        }
        map.put(id, content);
    }

    @Override
    public Map<String, DataHandler> getAttachments() {
        Map map = this.getExchange().getProperty(ATTACHMENT_OBJECTS, Map.class);
        if (map != null) {
            HashMap<String, DataHandler> answer = new HashMap<String, DataHandler>();
            map.forEach((id, att) -> answer.put((String)id, att.getDataHandler()));
            return answer;
        }
        return null;
    }

    @Override
    public Map<String, Attachment> getAttachmentObjects() {
        return this.getExchange().getProperty(ATTACHMENT_OBJECTS, Map.class);
    }

    @Override
    public void setAttachments(Map<String, DataHandler> attachments) {
        HashMap map = new HashMap();
        attachments.forEach((id, dh) -> {
            Attachment cfr_ignored_0 = map.put(id, new DefaultAttachment((DataHandler)dh));
        });
        this.getExchange().setProperty(ATTACHMENT_OBJECTS, map);
    }

    @Override
    public void setAttachmentObjects(Map<String, Attachment> attachments) {
        this.getExchange().setProperty(ATTACHMENT_OBJECTS, attachments);
    }

    @Override
    public boolean hasAttachments() {
        Map map = this.getExchange().getProperty(ATTACHMENT_OBJECTS, Map.class);
        return map != null && !map.isEmpty();
    }
}

