/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow.cloud;

import org.apache.camel.impl.cloud.DefaultServiceCallExpression;
import org.apache.camel.util.ObjectHelper;

public final class UndertowServiceExpression
extends DefaultServiceCallExpression {
    public UndertowServiceExpression() {
    }

    public UndertowServiceExpression(String hostHeader, String portHeader) {
        super(hostHeader, portHeader);
    }

    @Override
    protected String doBuildCamelEndpointUri(String host, Integer port, String contextPath, String scheme) {
        if (!ObjectHelper.equal(scheme, "undertow")) {
            return super.doBuildCamelEndpointUri(host, port, contextPath, scheme);
        }
        String answer = scheme + ":http://" + host;
        if (port != null) {
            answer = answer + ":" + port;
        }
        if (contextPath != null) {
            if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            answer = answer + contextPath;
        }
        return answer;
    }
}

