/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.base;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.http.base.HttpSendDynamicPostProcessor;
import org.apache.camel.http.base.HttpSendDynamicPreProcessor;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.support.component.SendDynamicAwareSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public class HttpSendDynamicAware
extends SendDynamicAwareSupport {
    private final Processor postProcessor = new HttpSendDynamicPostProcessor();

    @Override
    public boolean isLenientProperties() {
        return true;
    }

    @Override
    public SendDynamicAware.DynamicAwareEntry prepare(Exchange exchange, String uri, String originalUri) throws Exception {
        Map<String, Object> properties = this.endpointProperties(exchange, uri);
        Map<String, Object> lenient = this.endpointLenientProperties(exchange, uri);
        return new SendDynamicAware.DynamicAwareEntry(uri, originalUri, properties, lenient);
    }

    @Override
    public String resolveStaticUri(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        String[] hostAndPath = this.parseUri(entry);
        String host = hostAndPath[0];
        String path = hostAndPath[1];
        if (path != null || !entry.getLenientProperties().isEmpty()) {
            Map<String, Object> params = entry.getProperties();
            for (String k : entry.getLenientProperties().keySet()) {
                params.remove(k);
            }
            if (path != null) {
                params.remove("httpUri");
                params.remove("httpURI");
                if ("netty-http".equals(this.getScheme())) {
                    params.remove("path");
                }
            }
            String url = this.getScheme() + ":" + host;
            if (!params.isEmpty()) {
                url = url + "?" + URISupport.createQueryString(params, false);
            }
            return url;
        }
        return null;
    }

    @Override
    public Processor createPreProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        String[] hostAndPath = this.parseUri(entry);
        String path = hostAndPath[1];
        String query = null;
        if (!entry.getLenientProperties().isEmpty()) {
            query = URISupport.createQueryString(new LinkedHashMap<String, Object>(entry.getLenientProperties()));
        }
        if (query == null && ObjectHelper.isNotEmpty(exchange.getIn().getHeader("CamelHttpQuery"))) {
            query = (String)exchange.getIn().getHeader("CamelHttpQuery");
        }
        if (path != null || query != null) {
            return new HttpSendDynamicPreProcessor(path, query);
        }
        return null;
    }

    @Override
    public Processor createPostProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        return this.postProcessor;
    }

    public String[] parseUri(SendDynamicAware.DynamicAwareEntry entry) {
        boolean httpComponent;
        String u = entry.getUri();
        boolean bl = httpComponent = "http".equals(this.getScheme()) || "https".equals(this.getScheme());
        if (!httpComponent) {
            String prefix = this.getScheme() + "://";
            String prefix2 = this.getScheme() + ":";
            if (u.startsWith(prefix)) {
                u = u.substring(prefix.length());
            } else if (u.startsWith(prefix2)) {
                u = u.substring(prefix2.length());
            }
        }
        if (u.indexOf(63) > 0) {
            u = StringHelper.before(u, "?");
        }
        try {
            URI parse = new URI(u);
            String host = parse.getHost();
            String path = parse.getPath();
            if (path != null && path.length() > 1) {
                String scheme;
                int port = parse.getPort();
                if (port > 0 && port != 80 && port != 443) {
                    host = host + ":" + port;
                }
                while (path.startsWith("//")) {
                    path = path.substring(1);
                }
                if (!httpComponent && (scheme = parse.getScheme()) != null) {
                    host = scheme + "://" + host;
                }
                return new String[]{host, path};
            }
        }
        catch (URISyntaxException e) {
            return new String[]{u, null};
        }
        return new String[]{u, null};
    }
}

