/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceLoadBalancer;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceCallProcessor
extends AsyncProcessorSupport {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServiceCallProcessor.class);
    private final ExchangePattern exchangePattern;
    private final String name;
    private final String scheme;
    private final String uri;
    private final String contextPath;
    private final CamelContext camelContext;
    private final ServiceLoadBalancer loadBalancer;
    private final Expression expression;
    private ProcessorFactory processorFactory;
    private AsyncProcessor processor;
    private Expression serviceNameExp;
    private Expression serviceUriExp;
    private Expression servicePathExp;
    private Expression serviceSchemeExp;

    public DefaultServiceCallProcessor(CamelContext camelContext, String name, String scheme, String uri, ExchangePattern exchangePattern, ServiceLoadBalancer loadBalancer, Expression expression) {
        String serviceName;
        this.uri = uri;
        this.exchangePattern = exchangePattern;
        this.camelContext = camelContext;
        this.loadBalancer = loadBalancer;
        if (name.contains("/")) {
            serviceName = StringHelper.before(name, "/");
            this.contextPath = StringHelper.after(name, "/");
        } else if (name.contains("?")) {
            serviceName = StringHelper.before(name, "?");
            this.contextPath = StringHelper.after(name, "?");
        } else {
            serviceName = name;
            this.contextPath = null;
        }
        if (serviceName.contains(":")) {
            this.scheme = StringHelper.before(serviceName, ":");
            this.name = StringHelper.after(serviceName, ":");
        } else {
            this.scheme = scheme;
            this.name = serviceName;
        }
        this.expression = expression;
    }

    public ExchangePattern getExchangePattern() {
        return this.exchangePattern;
    }

    public String getName() {
        return this.name;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUri() {
        return this.uri;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServiceLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    protected void doBuild() throws Exception {
        ObjectHelper.notNull(this.camelContext, "camel context");
        this.processorFactory = this.camelContext.adapt(ExtendedCamelContext.class).getProcessorFactory();
    }

    @Override
    protected void doInit() throws Exception {
        StringHelper.notEmpty(this.name, "name", "service name");
        ObjectHelper.notNull(this.expression, "expression");
        ObjectHelper.notNull(this.loadBalancer, "load balancer");
        Processor send = this.processorFactory.createProcessor(this.camelContext, "SendDynamicProcessor", new Object[]{this.uri, this.expression, this.exchangePattern});
        this.processor = AsyncProcessorConverterHelper.convert(send);
        Language simple = this.camelContext.resolveLanguage("simple");
        this.serviceNameExp = simple.createExpression(this.name);
        this.serviceUriExp = this.uri != null ? simple.createExpression(this.uri) : null;
        this.servicePathExp = this.contextPath != null ? simple.createExpression(this.contextPath) : null;
        this.serviceSchemeExp = this.scheme != null ? simple.createExpression(this.scheme) : null;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.processor, this.loadBalancer);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.loadBalancer, this.processor);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Message message = exchange.getIn();
        String serviceName = this.serviceNameExp.evaluate(exchange, String.class);
        String serviceUri = this.serviceUriExp != null ? this.serviceUriExp.evaluate(exchange, String.class) : null;
        String servicePath = this.servicePathExp != null ? this.servicePathExp.evaluate(exchange, String.class) : null;
        String serviceScheme = this.serviceSchemeExp != null ? this.serviceSchemeExp.evaluate(exchange, String.class) : null;
        message.setHeader("CamelServiceCallUri", serviceUri);
        message.setHeader("CamelServiceCallContextPath", servicePath);
        message.setHeader("CamelServiceCallScheme", serviceScheme);
        message.setHeader("CamelServiceCallServiceName", serviceName);
        try {
            return this.loadBalancer.process(serviceName, (ServiceDefinition server) -> this.execute(server, exchange, callback));
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    private boolean execute(ServiceDefinition service, Exchange exchange, AsyncCallback callback) throws Exception {
        Message message = exchange.getIn();
        String host = service.getHost();
        int port = service.getPort();
        Map<String, String> meta = service.getMetadata();
        LOG.debug("Service {} active at server: {}:{}", new Object[]{this.name, host, port});
        message.setHeader("CamelServiceCallServiceHost", host);
        message.setHeader("CamelServiceCallServicePort", port > 0 ? Integer.valueOf(port) : null);
        message.setHeader("CamelServiceCallServiceName", service.getName());
        message.setHeader("CamelServiceCallServiceMeta", meta);
        message.getHeaders().compute("CamelServiceCallContextPath", (k, v) -> v == null ? meta.get("service.path") : v);
        message.getHeaders().compute("CamelServiceCallServicePort", (k, v) -> v == null ? meta.get("service.port") : v);
        return this.processor.process(exchange, callback);
    }
}

