/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.impl.converter.CachingInjector;
import org.apache.camel.impl.converter.InstanceMethodFallbackTypeConverter;
import org.apache.camel.impl.converter.InstanceMethodTypeConverter;
import org.apache.camel.impl.converter.StaticMethodFallbackTypeConverter;
import org.apache.camel.impl.converter.StaticMethodTypeConverter;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationTypeConverterLoader
implements TypeConverterLoader {
    public static final String META_INF_SERVICES = "META-INF/services/org/apache/camel/TypeConverter";
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationTypeConverterLoader.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    protected PackageScanClassResolver resolver;
    protected Set<Class<?>> visitedClasses = new HashSet();
    protected Set<String> visitedURIs = new HashSet<String>();

    public AnnotationTypeConverterLoader(PackageScanClassResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        CharSequence[] packageNames;
        LOG.trace("Searching for {} services", (Object)META_INF_SERVICES);
        try {
            packageNames = this.findPackageNames();
            if (packageNames == null || packageNames.length == 0) {
                LOG.debug("No package names found to be used for classpath scanning for annotated type converters.");
                return;
            }
        }
        catch (Exception e) {
            throw new TypeConverterLoaderException("Cannot find package names to be used for classpath scanning for annotated type converters.", e);
        }
        if (packageNames.length == 1 && "org.apache.camel.core".equals(packageNames[0])) {
            LOG.debug("No additional package names found in classpath for annotated type converters.");
            return;
        }
        packageNames = AnnotationTypeConverterLoader.filterUnwantedPackage("org.apache.camel.core", (String[])packageNames);
        HashSet classes = new HashSet();
        packageNames = this.filterPackageNamesOnly(this.resolver, (String[])packageNames, classes);
        if (!classes.isEmpty()) {
            LOG.debug("Loaded {} @Converter classes", (Object)classes.size());
        }
        if (packageNames != null && packageNames.length > 0) {
            Set<Class<?>> scannedClasses;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found converter packages to scan: {}", (Object)String.join((CharSequence)", ", packageNames));
            }
            if ((scannedClasses = this.resolver.findAnnotated(Converter.class, (String[])packageNames)).isEmpty()) {
                throw new TypeConverterLoaderException("Cannot find any type converter classes from the following packages: " + Arrays.asList(packageNames));
            }
            LOG.debug("Found {} packages with {} @Converter classes to load", (Object)packageNames.length, (Object)scannedClasses.size());
            classes.addAll(scannedClasses);
        }
        for (Class clazz : classes) {
            if (!this.acceptClass(clazz)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loading converter class: {}", (Object)ObjectHelper.name(clazz));
            }
            this.loadConverterMethods(registry, clazz);
        }
        this.visitedClasses.clear();
        this.visitedURIs.clear();
    }

    protected String[] filterPackageNamesOnly(PackageScanClassResolver resolver, String[] packageNames, Set<Class<?>> classes) {
        if (packageNames == null || packageNames.length == 0) {
            return packageNames;
        }
        if (resolver.getClassLoaders().isEmpty()) {
            return packageNames;
        }
        ArrayList<String> packages = new ArrayList<String>();
        for (String name : packageNames) {
            if (StringHelper.isClassName(name)) {
                Class<?> clazz = null;
                for (ClassLoader loader : resolver.getClassLoaders()) {
                    try {
                        clazz = ObjectHelper.loadClass(name, loader);
                        if (clazz == null) break;
                        LOG.trace("Loaded {} as class {}", (Object)name, clazz);
                        classes.add(clazz);
                        break;
                    }
                    catch (Throwable throwable) {
                    }
                }
                if (clazz != null) continue;
                packages.add(name);
                continue;
            }
            packages.add(name);
        }
        return packages.toArray(new String[packages.size()]);
    }

    protected String[] findPackageNames() throws IOException {
        HashSet<String> packages = new HashSet<String>();
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        if (ccl != null) {
            this.findPackages(packages, ccl);
        }
        this.findPackages(packages, this.getClass().getClassLoader());
        return packages.toArray(new String[packages.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findPackages(Set<String> packages, ClassLoader classLoader) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(META_INF_SERVICES);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            String path = url.getPath();
            if (this.visitedURIs.contains(path)) continue;
            this.visitedURIs.add(path);
            LOG.debug("Loading file {} to retrieve list of packages, from url: {}", (Object)META_INF_SERVICES, (Object)url);
            BufferedReader reader = IOHelper.buffered(new InputStreamReader(url.openStream(), UTF8));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                    this.tokenize(packages, line);
                }
            }
            finally {
                IOHelper.close((Closeable)reader, null, LOG);
            }
        }
    }

    private void tokenize(Set<String> packages, String line) {
        StringTokenizer iter = new StringTokenizer(line, ",");
        while (iter.hasMoreTokens()) {
            String name = iter.nextToken().trim();
            if (name.length() <= 0) continue;
            packages.add(name);
        }
    }

    protected void loadConverterMethods(TypeConverterRegistry registry, Class<?> type) {
        if (this.visitedClasses.contains(type)) {
            return;
        }
        this.visitedClasses.add(type);
        try {
            Method[] methods = type.getDeclaredMethods();
            CachingInjector<?> injector = null;
            for (Method method : methods) {
                boolean fallback;
                if (!ObjectHelper.hasAnnotation(method, Converter.class, true)) continue;
                boolean allowNull = false;
                if (method.getAnnotation(Converter.class) != null) {
                    allowNull = method.getAnnotation(Converter.class).allowNull();
                }
                injector = (fallback = method.getAnnotation(Converter.class).fallback()) ? this.handleHasFallbackConverterAnnotation(registry, type, injector, method, allowNull) : this.handleHasConverterAnnotation(registry, type, injector, method, allowNull);
            }
            Class<?> superclass = type.getSuperclass();
            if (superclass != null && !superclass.equals(Object.class)) {
                this.loadConverterMethods(registry, superclass);
            }
        }
        catch (NoClassDefFoundError e) {
            boolean ignore = false;
            if (ObjectHelper.hasAnnotation(type, Converter.class, true) && type.getAnnotation(Converter.class) != null) {
                ignore = type.getAnnotation(Converter.class).ignoreOnLoadError();
            }
            if (ignore) {
                LOG.debug("Ignoring converter type: {} as a dependent class could not be found: {}", new Object[]{type.getCanonicalName(), e, e});
            }
            LOG.warn("Ignoring converter type: {} as a dependent class could not be found: {}", new Object[]{type.getCanonicalName(), e, e});
        }
    }

    protected boolean acceptClass(Class<?> clazz) {
        return true;
    }

    private CachingInjector<?> handleHasConverterAnnotation(TypeConverterRegistry registry, Class<?> type, CachingInjector<?> injector, Method method, boolean allowNull) {
        if (this.isValidConverterMethod(method)) {
            int modifiers = method.getModifiers();
            if (Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers)) {
                LOG.warn("Ignoring bad converter on type: {} method: {} as a converter method is not a public and concrete method", (Object)type.getCanonicalName(), (Object)method);
            } else {
                Class<?> toType = method.getReturnType();
                if (toType.equals(Void.class)) {
                    LOG.warn("Ignoring bad converter on type: {} method: {} as a converter method returns a void method", (Object)type.getCanonicalName(), (Object)method);
                } else {
                    Class<?> fromType = method.getParameterTypes()[0];
                    if (Modifier.isStatic(modifiers)) {
                        this.registerTypeConverter(registry, method, toType, fromType, new StaticMethodTypeConverter(method, allowNull));
                    } else {
                        if (injector == null) {
                            injector = new CachingInjector<Object>(registry, CastUtils.cast(type, Object.class));
                        }
                        this.registerTypeConverter(registry, method, toType, fromType, new InstanceMethodTypeConverter(injector, method, registry, allowNull));
                    }
                }
            }
        } else {
            LOG.warn("Ignoring bad converter on type: {} method: {} as a converter method should have one parameter", (Object)type.getCanonicalName(), (Object)method);
        }
        return injector;
    }

    private CachingInjector<?> handleHasFallbackConverterAnnotation(TypeConverterRegistry registry, Class<?> type, CachingInjector<?> injector, Method method, boolean allowNull) {
        if (this.isValidFallbackConverterMethod(method)) {
            int modifiers = method.getModifiers();
            if (Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers)) {
                LOG.warn("Ignoring bad fallback converter on type: {} method: {} as a fallback converter method is not a public and concrete method", (Object)type.getCanonicalName(), (Object)method);
            } else {
                Class<?> toType = method.getReturnType();
                if (toType.equals(Void.class)) {
                    LOG.warn("Ignoring bad fallback converter on type: {} method: {} as a fallback converter method returns a void method", (Object)type.getCanonicalName(), (Object)method);
                } else if (Modifier.isStatic(modifiers)) {
                    this.registerFallbackTypeConverter(registry, new StaticMethodFallbackTypeConverter(method, registry, allowNull), method);
                } else {
                    if (injector == null) {
                        injector = new CachingInjector<Object>(registry, CastUtils.cast(type, Object.class));
                    }
                    this.registerFallbackTypeConverter(registry, new InstanceMethodFallbackTypeConverter(injector, method, registry, allowNull), method);
                }
            }
        } else {
            LOG.warn("Ignoring bad fallback converter on type: {} method: {} as a fallback converter method should have one parameter", (Object)type.getCanonicalName(), (Object)method);
        }
        return injector;
    }

    protected void registerTypeConverter(TypeConverterRegistry registry, Method method, Class<?> toType, Class<?> fromType, TypeConverter typeConverter) {
        registry.addTypeConverter(toType, fromType, typeConverter);
    }

    protected boolean isValidConverterMethod(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes != null && (parameterTypes.length == 1 || parameterTypes.length == 2 && Exchange.class.isAssignableFrom(parameterTypes[1]));
    }

    protected void registerFallbackTypeConverter(TypeConverterRegistry registry, TypeConverter typeConverter, Method method) {
        boolean canPromote = false;
        if (method.getAnnotation(Converter.class) != null) {
            canPromote = method.getAnnotation(Converter.class).fallbackCanPromote();
        }
        registry.addFallbackTypeConverter(typeConverter, canPromote);
    }

    protected boolean isValidFallbackConverterMethod(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes != null && (parameterTypes.length == 3 || parameterTypes.length == 4 && Exchange.class.isAssignableFrom(parameterTypes[1]) && TypeConverterRegistry.class.isAssignableFrom(parameterTypes[parameterTypes.length - 1]));
    }

    protected static String[] filterUnwantedPackage(String name, String[] packageNames) {
        ArrayList<String> packages = new ArrayList<String>();
        for (String s : packageNames) {
            if (name.equals(s)) continue;
            packages.add(s);
        }
        return packages.toArray(new String[packages.size()]);
    }
}

