/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.SimpleRegistry;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;

public class DefaultRegistry
extends ServiceSupport
implements Registry,
CamelContextAware {
    protected CamelContext camelContext;
    protected List<BeanRepository> repositories;
    protected Registry fallbackRegistry = new SimpleRegistry();

    public DefaultRegistry() {
    }

    public DefaultRegistry(BeanRepository ... repositories) {
        if (repositories != null) {
            this.repositories = new ArrayList<BeanRepository>(Arrays.asList(repositories));
        }
    }

    public DefaultRegistry(Collection<BeanRepository> repositories) {
        if (repositories != null) {
            this.repositories = new ArrayList<BeanRepository>(repositories);
        }
    }

    public Registry getFallbackRegistry() {
        return this.fallbackRegistry;
    }

    public void setFallbackRegistry(Registry fallbackRegistry) {
        this.fallbackRegistry = fallbackRegistry;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public List<BeanRepository> getRepositories() {
        if (this.repositories == null) {
            return null;
        }
        return Collections.unmodifiableList(this.repositories);
    }

    @Override
    public void bind(String id, Class<?> type, Object bean) throws RuntimeCamelException {
        if (this.camelContext != null && bean instanceof CamelContextAware) {
            ((CamelContextAware)bean).setCamelContext(this.camelContext);
        }
        this.fallbackRegistry.bind(id, type, bean);
    }

    @Override
    public Object lookupByName(String name) {
        try {
            if (this.camelContext != null && !name.equals("properties")) {
                name = this.camelContext.resolvePropertyPlaceholders(name);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        if (this.repositories != null) {
            for (BeanRepository r : this.repositories) {
                Object answer = r.lookupByName(name);
                if (answer == null) continue;
                return this.unwrap(answer);
            }
        }
        return this.fallbackRegistry.lookupByName(name);
    }

    @Override
    public <T> T lookupByNameAndType(String name, Class<T> type) {
        try {
            if (this.camelContext != null && !name.equals("properties")) {
                name = this.camelContext.resolvePropertyPlaceholders(name);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        if (this.repositories != null) {
            for (BeanRepository r : this.repositories) {
                T answer = r.lookupByNameAndType(name, type);
                if (answer == null) continue;
                return (T)this.unwrap(answer);
            }
        }
        return this.fallbackRegistry.lookupByNameAndType(name, type);
    }

    @Override
    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        Map<String, T> found;
        LinkedHashMap<String, T> answer = new LinkedHashMap<String, T>();
        if (this.repositories != null) {
            for (BeanRepository r : this.repositories) {
                Map<String, T> found2 = r.findByTypeWithName(type);
                if (found2 == null || found2.isEmpty()) continue;
                answer.putAll(found2);
            }
        }
        if ((found = this.fallbackRegistry.findByTypeWithName(type)) != null && !found.isEmpty()) {
            answer.putAll(found);
        }
        return answer;
    }

    @Override
    public <T> Set<T> findByType(Class<T> type) {
        Set<T> found;
        LinkedHashSet<T> answer = new LinkedHashSet<T>();
        if (this.repositories != null) {
            for (BeanRepository r : this.repositories) {
                Set<T> found2 = r.findByType(type);
                if (found2 == null || found2.isEmpty()) continue;
                answer.addAll(found2);
            }
        }
        if ((found = this.fallbackRegistry.findByType(type)) != null && !found.isEmpty()) {
            answer.addAll(found);
        }
        return answer;
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.fallbackRegistry instanceof Closeable) {
            IOHelper.close((Closeable)((Object)this.fallbackRegistry));
        }
        ServiceHelper.stopAndShutdownService(this.fallbackRegistry);
    }
}

