/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.annotations.helpers;

import com.univocity.parsers.annotations.BooleanString;
import com.univocity.parsers.annotations.Convert;
import com.univocity.parsers.annotations.Format;
import com.univocity.parsers.annotations.LowerCase;
import com.univocity.parsers.annotations.NullString;
import com.univocity.parsers.annotations.Parsed;
import com.univocity.parsers.annotations.Replace;
import com.univocity.parsers.annotations.Trim;
import com.univocity.parsers.annotations.UpperCase;
import com.univocity.parsers.conversions.Conversion;
import com.univocity.parsers.conversions.Conversions;
import com.univocity.parsers.conversions.ObjectConversion;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class AnnotationHelper {
    private AnnotationHelper() {
    }

    private static String getNullValue(String defaultValue) {
        if (defaultValue.equals("null")) {
            return null;
        }
        if (defaultValue.equals("'null'")) {
            return "null";
        }
        return defaultValue;
    }

    private static String getNullWriteValue(Parsed parsed) {
        return AnnotationHelper.getNullValue(parsed.defaultNullWrite());
    }

    private static String getNullReadValue(Parsed parsed) {
        return AnnotationHelper.getNullValue(parsed.defaultNullRead());
    }

    private static String[] addNull(String[] strings) {
        String[] out = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            if ("null".equals(strings[i])) {
                out[i] = null;
            }
            if (!"'null'".equals(strings[i])) continue;
            out[i] = "null";
        }
        return strings;
    }

    public static Conversion getConversion(Field field, Annotation annotation) {
        try {
            Parsed parsed = field.getAnnotation(Parsed.class);
            Class<? extends Annotation> annType = annotation.annotationType();
            String nullRead = AnnotationHelper.getNullReadValue(parsed);
            String nullWrite = AnnotationHelper.getNullWriteValue(parsed);
            Class<?> fieldType = field.getType();
            if (annType == NullString.class) {
                String[] nulls = ((NullString)annotation).nulls();
                return Conversions.toNull(nulls);
            }
            if (annType == Trim.class) {
                return Conversions.trim();
            }
            if (annType == LowerCase.class) {
                return Conversions.toLowerCase();
            }
            if (annType == UpperCase.class) {
                return Conversions.toUpperCase();
            }
            if (annType == Replace.class) {
                Replace replace = (Replace)annotation;
                return Conversions.replace(replace.expression(), replace.replacement());
            }
            if (annType == BooleanString.class) {
                Boolean valueForNull;
                if (fieldType != Boolean.TYPE && fieldType != Boolean.class) {
                    throw new IllegalArgumentException("Invalid annotation: Field " + field.getName() + " has type " + fieldType.getName() + " instead of boolean.");
                }
                BooleanString boolString = (BooleanString)annotation;
                String[] falseStrings = AnnotationHelper.addNull(boolString.falseStrings());
                String[] trueStrings = AnnotationHelper.addNull(boolString.trueStrings());
                Boolean bl = valueForNull = nullRead == null ? null : Boolean.valueOf(nullRead);
                if (valueForNull == null && fieldType == Boolean.TYPE) {
                    valueForNull = Boolean.FALSE;
                }
                return Conversions.toBoolean(valueForNull, nullWrite, trueStrings, falseStrings);
            }
            if (annType == Format.class) {
                Format format = (Format)annotation;
                String[] formats = format.formats();
                if (fieldType == BigDecimal.class) {
                    BigDecimal defaultForNull = nullRead == null ? null : new BigDecimal(nullRead);
                    return Conversions.formatToBigDecimal(defaultForNull, nullWrite, formats);
                }
                if (Number.class.isAssignableFrom(fieldType)) {
                    return Conversions.formatToNumber(formats);
                }
                Date dateIfNull = null;
                if (nullRead != null) {
                    if (nullRead.equalsIgnoreCase("now")) {
                        dateIfNull = new Date();
                    } else {
                        if (formats.length == 0) {
                            throw new IllegalArgumentException("No format defined");
                        }
                        SimpleDateFormat sdf = new SimpleDateFormat(formats[0]);
                        dateIfNull = sdf.parse(nullRead);
                    }
                }
                if (Date.class == fieldType) {
                    return Conversions.toDate(dateIfNull, nullWrite, formats);
                }
                if (Calendar.class == fieldType) {
                    Calendar calendarIfNull = null;
                    if (dateIfNull != null) {
                        calendarIfNull = Calendar.getInstance();
                        calendarIfNull.setTime(dateIfNull);
                    }
                    return Conversions.toCalendar(calendarIfNull, nullWrite, formats);
                }
            } else if (annType == Convert.class) {
                Convert convert = (Convert)annotation;
                String[] args = convert.args();
                Class<? extends Conversion> conversionClass = convert.conversionClass();
                if (!Conversion.class.isAssignableFrom(conversionClass)) {
                    throw new IllegalArgumentException("Not a valid conversion class: '" + conversionClass.getName() + "'");
                }
                Constructor<? extends Conversion> constructor = conversionClass.getConstructor(String[].class);
                return constructor.newInstance(args);
            }
            return null;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static Conversion getDefaultConversion(Field field) {
        Parsed parsed = field.getAnnotation(Parsed.class);
        Class<?> fieldType = field.getType();
        String nullRead = AnnotationHelper.getNullReadValue(parsed);
        Comparable<Boolean> valueIfStringIsNull = null;
        ObjectConversion conversion = null;
        if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
            conversion = Conversions.toBoolean();
            valueIfStringIsNull = nullRead == null ? null : Boolean.valueOf(nullRead);
        } else if (fieldType == Character.class || fieldType == Character.TYPE) {
            conversion = Conversions.toChar();
            if (nullRead != null && nullRead.length() > 1) {
                throw new IllegalArgumentException("Invalid default value for character '" + nullRead + "'. It should contain one character only.");
            }
            valueIfStringIsNull = nullRead == null ? null : Character.valueOf(nullRead.charAt(0));
        } else if (fieldType == Byte.class || fieldType == Byte.TYPE) {
            conversion = Conversions.toByte();
            valueIfStringIsNull = nullRead == null ? null : Byte.valueOf(nullRead);
        } else if (fieldType == Short.class || fieldType == Short.TYPE) {
            conversion = Conversions.toShort();
            valueIfStringIsNull = nullRead == null ? null : Short.valueOf(nullRead);
        } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
            conversion = Conversions.toInteger();
            valueIfStringIsNull = nullRead == null ? null : Integer.valueOf(nullRead);
        } else if (fieldType == Float.class || fieldType == Float.TYPE) {
            conversion = Conversions.toFloat();
            valueIfStringIsNull = nullRead == null ? null : Float.valueOf(nullRead);
        } else if (fieldType == Double.class || fieldType == Double.TYPE) {
            conversion = Conversions.toDouble();
            valueIfStringIsNull = nullRead == null ? null : Double.valueOf(nullRead);
        } else if (fieldType == BigInteger.class) {
            conversion = Conversions.toBigInteger();
            valueIfStringIsNull = nullRead == null ? null : new BigInteger(nullRead);
        } else if (fieldType == BigDecimal.class) {
            conversion = Conversions.toBigDecimal();
            Comparable<BigDecimal> comparable = valueIfStringIsNull = nullRead == null ? null : new BigDecimal(nullRead);
        }
        if (conversion != null) {
            conversion.setValueIfStringIsNull(valueIfStringIsNull);
            conversion.setValueIfObjectIsNull(AnnotationHelper.getNullWriteValue(parsed));
        }
        return conversion;
    }
}

