/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.conversions;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.conversions.ObjectConversion;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;

public abstract class NumericConversion<T extends Number>
extends ObjectConversion<T> {
    private final DecimalFormat[] formatters;
    private final String[] formats;

    public NumericConversion(T valueIfStringIsNull, String valueIfObjectIsNull, String ... numericFormats) {
        super(valueIfStringIsNull, valueIfObjectIsNull);
        ArgumentUtils.noNulls("Numeric formats", numericFormats);
        this.formats = (String[])numericFormats.clone();
        this.formatters = new DecimalFormat[numericFormats.length];
        for (int i = 0; i < numericFormats.length; ++i) {
            String numericFormat = numericFormats[i];
            this.formatters[i] = new DecimalFormat(numericFormat);
            this.configureFormatter(this.formatters[i]);
        }
    }

    public NumericConversion(String ... numericFormats) {
        this((null), (String)null, numericFormats);
    }

    protected abstract void configureFormatter(DecimalFormat var1);

    @Override
    protected T fromString(String input) {
        for (DecimalFormat formatter : this.formatters) {
            try {
                return (T)formatter.parse(input);
            }
            catch (ParseException ex) {
            }
        }
        throw new IllegalArgumentException("Cannot parse '" + input + "' as a valid number. Supported formats are: " + Arrays.toString(this.formats));
    }

    @Override
    public String revert(T input) {
        if (input == null) {
            return super.revert((Object)input);
        }
        for (DecimalFormat formatter : this.formatters) {
            try {
                return formatter.format(input);
            }
            catch (Exception ex) {
            }
        }
        throw new IllegalStateException("Cannot format '" + input + "'. No valid formatters were defined.");
    }
}

