/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.univocity;

import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.common.AbstractWriter;
import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.CommonSettings;
import com.univocity.parsers.common.CommonWriterSettings;
import com.univocity.parsers.common.Format;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.univocity.HeaderRowProcessor;
import org.apache.camel.dataformat.univocity.Marshaller;
import org.apache.camel.dataformat.univocity.Unmarshaller;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.IOHelper;

public abstract class AbstractUniVocityDataFormat<F extends Format, CWS extends CommonWriterSettings<F>, W extends AbstractWriter<CWS>, CPS extends CommonParserSettings<F>, P extends AbstractParser<CPS>, DF extends AbstractUniVocityDataFormat<F, CWS, W, CPS, P, DF>>
implements DataFormat {
    protected String nullValue;
    protected Boolean skipEmptyLines;
    protected Boolean ignoreTrailingWhitespaces;
    protected Boolean ignoreLeadingWhitespaces;
    protected boolean headersDisabled;
    protected String[] headers;
    protected Boolean headerExtractionEnabled;
    protected Integer numberOfRecordsToRead;
    protected String emptyValue;
    protected String lineSeparator;
    protected Character normalizedLineSeparator;
    protected Character comment;
    protected boolean lazyLoad;
    protected boolean asMap;
    private volatile CWS writerSettings;
    private final Object writerSettingsToken = new Object();
    private volatile Marshaller<W> marshaller;
    private volatile ThreadLocal<CPS> parserSettings;
    private final Object parserSettingsToken = new Object();
    private volatile Unmarshaller<P> unmarshaller;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        if (this.writerSettings == null) {
            Object object = this.writerSettingsToken;
            synchronized (object) {
                if (this.writerSettings == null) {
                    this.writerSettings = this.createAndConfigureWriterSettings();
                    this.marshaller = new Marshaller(this.headers, this.headers == null);
                }
            }
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, IOHelper.getCharsetName((Exchange)exchange));){
            this.marshaller.marshal(exchange, body, this.createWriter(writer, this.writerSettings));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        if (this.parserSettings == null) {
            Object object = this.parserSettingsToken;
            synchronized (object) {
                if (this.parserSettings == null) {
                    this.parserSettings = new ThreadLocal<CPS>(){

                        @Override
                        protected CPS initialValue() {
                            return AbstractUniVocityDataFormat.this.createAndConfigureParserSettings();
                        }
                    };
                    this.unmarshaller = new Unmarshaller(this.lazyLoad, this.asMap);
                }
            }
        }
        try (InputStreamReader reader = new InputStreamReader(stream, IOHelper.getCharsetName((Exchange)exchange));){
            HeaderRowProcessor headerRowProcessor = new HeaderRowProcessor();
            CommonParserSettings settings = (CommonParserSettings)this.parserSettings.get();
            settings.setRowProcessor(headerRowProcessor);
            Object object = this.unmarshaller.unmarshal(reader, this.createParser(settings), headerRowProcessor);
            return object;
        }
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public DF setNullValue(String nullValue) {
        this.nullValue = nullValue;
        this.reset();
        return this.self();
    }

    public Boolean getSkipEmptyLines() {
        return this.skipEmptyLines;
    }

    public DF setSkipEmptyLines(Boolean skipEmptyLines) {
        this.skipEmptyLines = skipEmptyLines;
        this.reset();
        return this.self();
    }

    public Boolean getIgnoreTrailingWhitespaces() {
        return this.ignoreTrailingWhitespaces;
    }

    public DF setIgnoreTrailingWhitespaces(Boolean ignoreTrailingWhitespaces) {
        this.ignoreTrailingWhitespaces = ignoreTrailingWhitespaces;
        this.reset();
        return this.self();
    }

    public Boolean getIgnoreLeadingWhitespaces() {
        return this.ignoreLeadingWhitespaces;
    }

    public DF setIgnoreLeadingWhitespaces(Boolean ignoreLeadingWhitespaces) {
        this.ignoreLeadingWhitespaces = ignoreLeadingWhitespaces;
        this.reset();
        return this.self();
    }

    public boolean isHeadersDisabled() {
        return this.headersDisabled;
    }

    public DF setHeadersDisabled(boolean headersDisabled) {
        this.headersDisabled = headersDisabled;
        this.reset();
        return this.self();
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public DF setHeaders(String[] headers) {
        this.headers = headers;
        this.reset();
        return this.self();
    }

    public Boolean getHeaderExtractionEnabled() {
        return this.headerExtractionEnabled;
    }

    public DF setHeaderExtractionEnabled(Boolean headerExtractionEnabled) {
        this.headerExtractionEnabled = headerExtractionEnabled;
        this.reset();
        return this.self();
    }

    public Integer getNumberOfRecordsToRead() {
        return this.numberOfRecordsToRead;
    }

    public DF setNumberOfRecordsToRead(Integer numberOfRecordsToRead) {
        this.numberOfRecordsToRead = numberOfRecordsToRead;
        this.reset();
        return this.self();
    }

    public String getEmptyValue() {
        return this.emptyValue;
    }

    public DF setEmptyValue(String emptyValue) {
        this.emptyValue = emptyValue;
        this.reset();
        return this.self();
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public DF setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
        this.reset();
        return this.self();
    }

    public Character getNormalizedLineSeparator() {
        return this.normalizedLineSeparator;
    }

    public DF setNormalizedLineSeparator(Character normalizedLineSeparator) {
        this.normalizedLineSeparator = normalizedLineSeparator;
        this.reset();
        return this.self();
    }

    public Character getComment() {
        return this.comment;
    }

    public DF setComment(Character comment) {
        this.comment = comment;
        this.reset();
        return this.self();
    }

    public boolean isLazyLoad() {
        return this.lazyLoad;
    }

    public DF setLazyLoad(boolean lazyLoad) {
        this.lazyLoad = lazyLoad;
        this.reset();
        return this.self();
    }

    public boolean isAsMap() {
        return this.asMap;
    }

    public DF setAsMap(boolean asMap) {
        this.asMap = asMap;
        this.reset();
        return this.self();
    }

    protected abstract CWS createWriterSettings();

    protected void configureWriterSettings(CWS settings) {
        this.configureCommonSettings((CommonSettings<F>)settings);
        if (this.emptyValue != null) {
            ((CommonWriterSettings)settings).setEmptyValue(this.emptyValue);
        }
    }

    protected abstract W createWriter(Writer var1, CWS var2);

    protected abstract CPS createParserSettings();

    protected void configureParserSettings(CPS settings) {
        this.configureCommonSettings((CommonSettings<F>)settings);
        if (this.headerExtractionEnabled != null) {
            ((CommonParserSettings)settings).setHeaderExtractionEnabled(this.headerExtractionEnabled);
        }
        if (this.numberOfRecordsToRead != null) {
            ((CommonParserSettings)settings).setNumberOfRecordsToRead(this.numberOfRecordsToRead);
        }
    }

    protected abstract P createParser(CPS var1);

    protected void configureFormat(F format) {
        if (this.lineSeparator != null) {
            ((Format)format).setLineSeparator(this.lineSeparator);
        }
        if (this.normalizedLineSeparator != null) {
            ((Format)format).setNormalizedNewline(this.normalizedLineSeparator.charValue());
        }
        if (this.comment != null) {
            ((Format)format).setComment(this.comment.charValue());
        }
    }

    protected void reset() {
        this.writerSettings = null;
        this.marshaller = null;
        this.parserSettings = null;
        this.unmarshaller = null;
    }

    final CWS createAndConfigureWriterSettings() {
        CWS settings = this.createWriterSettings();
        this.configureWriterSettings(settings);
        this.configureFormat(((CommonSettings)settings).getFormat());
        return settings;
    }

    final CPS createAndConfigureParserSettings() {
        CPS settings = this.createParserSettings();
        this.configureParserSettings(settings);
        this.configureFormat(((CommonSettings)settings).getFormat());
        return settings;
    }

    private void configureCommonSettings(CommonSettings<F> settings) {
        if (this.nullValue != null) {
            settings.setNullValue(this.nullValue);
        }
        if (this.skipEmptyLines != null) {
            settings.setSkipEmptyLines(this.skipEmptyLines);
        }
        if (this.ignoreTrailingWhitespaces != null) {
            settings.setIgnoreTrailingWhitespaces(this.ignoreTrailingWhitespaces);
        }
        if (this.ignoreLeadingWhitespaces != null) {
            settings.setIgnoreLeadingWhitespaces(this.ignoreLeadingWhitespaces);
        }
        if (this.headersDisabled) {
            settings.setHeaders(null);
        } else if (this.headers != null) {
            settings.setHeaders(this.headers);
        }
    }

    private DF self() {
        return (DF)this;
    }
}

