/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.CommonSettings;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.input.CharAppender;
import com.univocity.parsers.common.input.CharInputReader;
import com.univocity.parsers.common.input.DefaultCharAppender;
import com.univocity.parsers.common.input.DefaultCharInputReader;
import com.univocity.parsers.common.input.concurrent.ConcurrentCharInputReader;
import com.univocity.parsers.common.processor.NoopRowProcessor;
import com.univocity.parsers.common.processor.RowProcessor;
import java.util.Map;

public abstract class CommonParserSettings<F extends Format>
extends CommonSettings<F> {
    private boolean headerExtractionEnabled = false;
    private RowProcessor rowProcessor;
    private boolean columnReorderingEnabled = true;
    private int inputBufferSize = 0x100000;
    private boolean readInputOnSeparateThread = Runtime.getRuntime().availableProcessors() > 1;
    private int numberOfRecordsToRead = -1;
    private boolean lineSeparatorDetectionEnabled = false;

    public boolean getReadInputOnSeparateThread() {
        return this.readInputOnSeparateThread;
    }

    public void setReadInputOnSeparateThread(boolean readInputOnSeparateThread) {
        this.readInputOnSeparateThread = readInputOnSeparateThread;
    }

    public boolean isHeaderExtractionEnabled() {
        return this.headerExtractionEnabled;
    }

    public void setHeaderExtractionEnabled(boolean headerExtractionEnabled) {
        this.headerExtractionEnabled = headerExtractionEnabled;
    }

    public RowProcessor getRowProcessor() {
        if (this.rowProcessor == null) {
            return NoopRowProcessor.instance;
        }
        return this.rowProcessor;
    }

    public void setRowProcessor(RowProcessor processor) {
        this.rowProcessor = processor;
    }

    CharInputReader newCharInputReader() {
        if (this.readInputOnSeparateThread) {
            if (this.lineSeparatorDetectionEnabled) {
                return new ConcurrentCharInputReader(((Format)this.getFormat()).getNormalizedNewline(), this.getInputBufferSize(), 10);
            }
            return new ConcurrentCharInputReader(((Format)this.getFormat()).getLineSeparator(), ((Format)this.getFormat()).getNormalizedNewline(), this.getInputBufferSize(), 10);
        }
        if (this.lineSeparatorDetectionEnabled) {
            return new DefaultCharInputReader(((Format)this.getFormat()).getNormalizedNewline(), this.getInputBufferSize());
        }
        return new DefaultCharInputReader(((Format)this.getFormat()).getLineSeparator(), ((Format)this.getFormat()).getNormalizedNewline(), this.getInputBufferSize());
    }

    public int getNumberOfRecordsToRead() {
        return this.numberOfRecordsToRead;
    }

    public void setNumberOfRecordsToRead(int numberOfRecordsToRead) {
        this.numberOfRecordsToRead = numberOfRecordsToRead;
    }

    public boolean isColumnReorderingEnabled() {
        return this.columnReorderingEnabled;
    }

    public void setColumnReorderingEnabled(boolean columnReorderingEnabled) {
        this.columnReorderingEnabled = columnReorderingEnabled;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    protected CharAppender newCharAppender() {
        return new DefaultCharAppender(this.getMaxCharsPerColumn(), this.getNullValue());
    }

    public final boolean isLineSeparatorDetectionEnabled() {
        return this.lineSeparatorDetectionEnabled;
    }

    public final void setLineSeparatorDetectionEnabled(boolean lineSeparatorDetectionEnabled) {
        this.lineSeparatorDetectionEnabled = lineSeparatorDetectionEnabled;
    }

    @Override
    protected void addConfiguration(Map<String, Object> out) {
        super.addConfiguration(out);
        out.put("Header extraction enabled", this.headerExtractionEnabled);
        out.put("Row processor", this.rowProcessor == null ? "none" : this.rowProcessor.getClass().getName());
        out.put("Column reordering enabled", this.columnReorderingEnabled);
        out.put("Input buffer size", this.inputBufferSize);
        out.put("Input reading on separate thread", this.readInputOnSeparateThread);
        out.put("Number of records to read", this.numberOfRecordsToRead == -1 ? "all" : Integer.valueOf(this.numberOfRecordsToRead));
        out.put("Line separator detection enabled", this.lineSeparatorDetectionEnabled);
    }
}

