/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.csv;

import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.TextParsingException;
import com.univocity.parsers.common.input.DefaultCharAppender;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParserSettings;

public class CsvParser
extends AbstractParser<CsvParserSettings> {
    private final boolean ignoreTrailingWhitespace;
    private final boolean ignoreLeadingWhitespace;
    private final boolean parseUnescapedQuotes;
    private final char delimiter;
    private final char quote;
    private final char quoteEscape;
    private final char escapeEscape;
    private final char newLine;
    private final DefaultCharAppender whitespaceAppender;

    public CsvParser(CsvParserSettings settings) {
        super(settings);
        this.ignoreTrailingWhitespace = settings.getIgnoreTrailingWhitespaces();
        this.ignoreLeadingWhitespace = settings.getIgnoreLeadingWhitespaces();
        this.parseUnescapedQuotes = settings.isParseUnescapedQuotes();
        CsvFormat format = (CsvFormat)settings.getFormat();
        this.delimiter = format.getDelimiter();
        this.quote = format.getQuote();
        this.quoteEscape = format.getQuoteEscape();
        this.escapeEscape = format.getCharToEscapeQuoteEscaping();
        this.newLine = format.getNormalizedNewline();
        this.whitespaceAppender = new DefaultCharAppender(settings.getMaxCharsPerColumn(), "");
    }

    @Override
    protected void parseRecord() {
        if (this.ch <= ' ' && this.ignoreLeadingWhitespace) {
            this.skipWhitespace();
        }
        while (this.ch != this.newLine) {
            this.parseField();
            if (this.ch == this.newLine) continue;
            this.ch = this.input.nextChar();
            if (this.ch != this.newLine) continue;
            this.output.emptyParsed();
        }
    }

    private void parseValue() {
        if (this.ignoreTrailingWhitespace) {
            while (this.ch != this.delimiter && this.ch != this.newLine) {
                this.output.appender.appendIgnoringWhitespace(this.ch);
                this.ch = this.input.nextChar();
            }
        } else {
            while (this.ch != this.delimiter && this.ch != this.newLine) {
                this.output.appender.append(this.ch);
                this.ch = this.input.nextChar();
            }
        }
    }

    private void parseQuotedValue(char prev) {
        this.ch = this.input.nextChar();
        while (prev != this.quote || this.ch > ' ' && this.ch != this.delimiter && this.ch != this.newLine) {
            if (this.ch != this.quote && this.ch != this.quoteEscape) {
                if (prev == this.quote) {
                    if (this.parseUnescapedQuotes) {
                        this.output.appender.append(this.quote);
                        this.output.appender.append(this.ch);
                        this.parseQuotedValue(this.ch);
                        break;
                    }
                    throw new TextParsingException((ParsingContext)this.context, "Unescaped quote character '" + this.quote + "' inside quoted value of CSV field. To allow unescaped quotes, set 'parseUnescapedQuotes' to 'true' in the CSV parser settings. Cannot parse CSV input.");
                }
                this.output.appender.append(this.ch);
                prev = this.ch;
            } else if (this.ch == this.quoteEscape && prev == this.escapeEscape && this.escapeEscape != '\u0000') {
                this.output.appender.append(this.ch);
                prev = '\u0000';
            } else if (prev == this.quoteEscape) {
                if (this.ch == this.quote) {
                    this.output.appender.append(this.quote);
                    prev = '\u0000';
                } else {
                    this.output.appender.append(prev);
                }
            } else {
                prev = this.ch;
            }
            this.ch = this.input.nextChar();
        }
        if (this.ch != this.delimiter && this.ch != this.newLine && this.ch <= ' ') {
            this.whitespaceAppender.reset();
            do {
                this.whitespaceAppender.append(this.ch);
                this.ch = this.input.nextChar();
                if (this.ch != this.newLine) continue;
                return;
            } while (this.ch <= ' ');
            if (this.ch != this.delimiter && this.parseUnescapedQuotes) {
                if (this.output.appender instanceof DefaultCharAppender) {
                    this.output.appender.append(this.quote);
                    ((DefaultCharAppender)this.output.appender).append(this.whitespaceAppender);
                }
                if (this.ch != this.quoteEscape) {
                    this.output.appender.append(this.ch);
                }
                this.parseQuotedValue(this.ch);
            }
        }
        if (this.ch != this.delimiter && this.ch != this.newLine) {
            throw new TextParsingException((ParsingContext)this.context, "Unexpected character '" + this.ch + "' following quoted value of CSV field. Expecting '" + this.delimiter + "'. Cannot parse CSV input.");
        }
    }

    private void parseField() {
        if (this.ch <= ' ' && this.ignoreLeadingWhitespace) {
            this.skipWhitespace();
        }
        if (this.ch == this.delimiter) {
            this.output.emptyParsed();
        } else {
            if (this.ch == this.quote) {
                this.parseQuotedValue('\u0000');
            } else {
                this.parseValue();
            }
            this.output.valueParsed();
        }
    }

    private void skipWhitespace() {
        while (this.ch <= ' ' && this.ch != this.delimiter && this.ch != this.newLine) {
            this.ch = this.input.nextChar();
        }
    }
}

