/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.urlrewrite;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.IsSingleton;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tuckey.web.filters.urlrewrite.Conf;
import org.tuckey.web.filters.urlrewrite.RewrittenUrl;
import org.tuckey.web.filters.urlrewrite.UrlRewriter;
import org.tuckey.web.filters.urlrewrite.utils.ModRewriteConfLoader;

public abstract class UrlRewriteFilter
extends ServiceSupport
implements CamelContextAware,
IsSingleton {
    private static final Logger LOG = LoggerFactory.getLogger(UrlRewriteFilter.class);
    protected CamelContext camelContext;
    protected Conf conf;
    protected UrlRewriter urlRewriter;
    protected String configFile;
    protected String modRewriteConfFile;
    protected String modRewriteConfText;
    protected boolean useQueryString;
    protected boolean useContext;
    protected String defaultMatchType;
    protected String decodeUsing;

    public String rewrite(String url, HttpServletRequest request) throws Exception {
        RewrittenUrl response = this.urlRewriter.processRequest(request, null);
        if (response != null) {
            String answer = response.getTarget();
            LOG.debug("Rewrite url: {} -> {}", (Object)url, (Object)answer);
            return answer;
        }
        LOG.trace("Rewrite using original url: {}", (Object)url);
        return url;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Conf getConf() {
        return this.conf;
    }

    public void setConf(Conf conf) {
        this.conf = conf;
    }

    public UrlRewriter getUrlRewriter() {
        return this.urlRewriter;
    }

    public void setUrlRewriter(UrlRewriter urlRewriter) {
        this.urlRewriter = urlRewriter;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getModRewriteConfText() {
        return this.modRewriteConfText;
    }

    public void setModRewriteConfText(String modRewriteConfText) {
        this.modRewriteConfText = modRewriteConfText;
    }

    public String getModRewriteConfFile() {
        return this.modRewriteConfFile;
    }

    public void setModRewriteConfFile(String modRewriteConfFile) {
        this.modRewriteConfFile = modRewriteConfFile;
    }

    public boolean isUseQueryString() {
        return this.useQueryString;
    }

    public void setUseQueryString(boolean useQueryString) {
        this.useQueryString = useQueryString;
    }

    public boolean isUseContext() {
        return this.useContext;
    }

    public void setUseContext(boolean useContext) {
        this.useContext = useContext;
    }

    public String getDefaultMatchType() {
        return this.defaultMatchType;
    }

    public void setDefaultMatchType(String defaultMatchType) {
        this.defaultMatchType = defaultMatchType;
    }

    public String getDecodeUsing() {
        return this.decodeUsing;
    }

    public void setDecodeUsing(String decodeUsing) {
        this.decodeUsing = decodeUsing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        if (this.conf == null) {
            if (this.modRewriteConfFile != null) {
                LOG.debug("Using mod rewrite config file: {} as config for urlRewrite", (Object)this.modRewriteConfFile);
                InputStream is = this.camelContext.getClassResolver().loadResourceAsStream(this.modRewriteConfFile);
                if (is == null) {
                    throw new IOException("Cannot load mod rewrite config file: " + this.modRewriteConfFile);
                }
                try {
                    String text = (String)this.camelContext.getTypeConverter().mandatoryConvertTo(String.class, (Object)is);
                    ModRewriteConfLoader loader = new ModRewriteConfLoader();
                    this.conf = new Conf();
                    loader.process(text, this.conf);
                }
                finally {
                    IOHelper.close((Closeable)is);
                }
            }
            if (this.modRewriteConfText != null) {
                LOG.debug("Using modRewriteConfText: {} as config for urlRewrite", (Object)this.modRewriteConfText);
                ModRewriteConfLoader loader = new ModRewriteConfLoader();
                this.conf = new Conf();
                loader.process(this.modRewriteConfText, this.conf);
            } else if (this.configFile != null) {
                LOG.debug("Using config file: {} as config for urlRewrite", (Object)this.configFile);
                InputStream is = this.camelContext.getClassResolver().loadResourceAsStream(this.configFile);
                if (is == null) {
                    throw new IOException("Cannot load config file: " + this.configFile);
                }
                try {
                    this.conf = new Conf(is, this.configFile);
                }
                finally {
                    IOHelper.close((Closeable)is);
                }
            }
            if (this.conf != null) {
                this.conf.setUseQueryString(this.isUseQueryString());
                this.conf.setUseContext(this.isUseContext());
                if (this.getDefaultMatchType() != null) {
                    this.conf.setDefaultMatchType(this.getDefaultMatchType());
                }
                if (this.getDecodeUsing() != null) {
                    this.conf.setDecodeUsing(this.getDecodeUsing());
                }
                this.conf.initialise();
            }
            if (this.conf == null || !this.conf.isOk()) {
                throw new IllegalStateException("Error configuring config file: " + this.configFile);
            }
        }
        if (this.urlRewriter == null) {
            this.urlRewriter = new UrlRewriter(this.conf);
        }
    }

    protected void doStop() throws Exception {
    }

    protected void doShutdown() throws Exception {
        LOG.debug("Shutting down urlRewrite");
        this.urlRewriter.destroy();
        this.conf = null;
        this.urlRewriter = null;
    }

    public boolean isSingleton() {
        return true;
    }
}

