/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.processor.validation.ValidatingProcessor;
import org.apache.camel.support.service.ServiceHelper;

public class ValidatorProducer
extends DefaultAsyncProducer {
    private final ValidatingProcessor validatingProcessor;

    public ValidatorProducer(Endpoint endpoint, ValidatingProcessor validatingProcessor) {
        super(endpoint);
        this.validatingProcessor = validatingProcessor;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        return this.validatingProcessor.process(exchange, callback);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object)this.validatingProcessor);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)this.validatingProcessor);
    }

    @Override
    protected void doShutdown() throws Exception {
        super.doStop();
        ServiceHelper.stopAndShutdownService(this.validatingProcessor);
    }
}

