/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resume;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.processor.resume.ResumableCompletion;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumableProcessor
extends AsyncProcessorSupport
implements Navigate<Processor>,
CamelContextAware,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(ResumableProcessor.class);
    private CamelContext camelContext;
    private final ResumeStrategy resumeStrategy;
    private final AsyncProcessor processor;
    private final LoggingLevel loggingLevel;
    private final boolean intermittent;
    private String id;
    private String routeId;

    public ResumableProcessor(ResumeStrategy resumeStrategy, Processor processor, LoggingLevel loggingLevel, boolean intermittent) {
        this.resumeStrategy = Objects.requireNonNull(resumeStrategy);
        this.processor = AsyncProcessorConverterHelper.convert(processor);
        this.loggingLevel = loggingLevel;
        this.intermittent = intermittent;
    }

    @Override
    protected void doStart() throws Exception {
        LOG.info("Starting the resumable strategy: {}", (Object)this.resumeStrategy.getClass().getSimpleName());
        this.resumeStrategy.start();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        LOG.info("Stopping the resumable strategy: {}", (Object)this.resumeStrategy.getClass().getSimpleName());
        this.resumeStrategy.stop();
        super.doStop();
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        ResumableCompletion onCompletion = new ResumableCompletion(this.resumeStrategy, this.loggingLevel, this.intermittent);
        exchange.adapt(ExtendedExchange.class).addOnCompletion(onCompletion);
        return this.processor.process(exchange, callback);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.processor);
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.processor != null;
    }
}

