/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.ProcessorExchangePair;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipientListProcessor
extends MulticastProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RecipientListProcessor.class);
    private static final String IGNORE_DELIMITER_MARKER = "false";
    private boolean ignoreInvalidEndpoints;
    private final Expression expression;
    private final String delimiter;
    private final ProducerCache producerCache;
    private int cacheSize;
    private Map<String, Object> txData;

    public RecipientListProcessor(CamelContext camelContext, Route route, Expression expression, String delimiter, ProducerCache producerCache, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean shutdownExecutorService, boolean streaming, boolean stopOnException, long timeout, Processor onPrepare, boolean shareUnitOfWork, boolean parallelAggregate) {
        super(camelContext, route, null, aggregationStrategy, parallelProcessing, executorService, shutdownExecutorService, streaming, stopOnException, timeout, onPrepare, shareUnitOfWork, parallelAggregate);
        this.expression = expression;
        this.delimiter = delimiter;
        this.producerCache = producerCache;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    @Override
    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) throws Exception {
        Object recipientList = exchange.removeProperty(ExchangePropertyKey.EVALUATE_EXPRESSION_RESULT);
        if (recipientList == null && this.expression != null) {
            recipientList = this.expression.evaluate(exchange, Object.class);
        }
        if (recipientList instanceof List) {
            List col = (List)recipientList;
            int size = col.size();
            ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>(size);
            int index = 0;
            for (int i = 0; i < size; ++i) {
                Object recipient = col.get(i);
                index = this.doCreateProcessorExchangePairs(exchange, recipient, result, index);
            }
            return result;
        }
        if (recipientList instanceof Collection) {
            Collection col = (Collection)recipientList;
            int size = col.size();
            ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>(size);
            int index = 0;
            for (Object recipient : col) {
                index = this.doCreateProcessorExchangePairs(exchange, recipient, result, index);
            }
            return result;
        }
        if (recipientList != null && recipientList.getClass().isArray()) {
            Object[] arr = (Object[])recipientList;
            int size = Array.getLength(recipientList);
            ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>(size);
            int index = 0;
            for (int i = 0; i < size; ++i) {
                Object recipient = arr[i];
                index = this.doCreateProcessorExchangePairs(exchange, recipient, result, index);
            }
            return result;
        }
        Iterator<?> iter = this.delimiter != null && this.delimiter.equalsIgnoreCase(IGNORE_DELIMITER_MARKER) ? ObjectHelper.createIterator(recipientList, null) : ObjectHelper.createIterator(recipientList, this.delimiter);
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>();
        int index = 0;
        while (iter.hasNext()) {
            index = this.doCreateProcessorExchangePairs(exchange, iter.next(), result, index);
        }
        return result;
    }

    private int doCreateProcessorExchangePairs(Exchange exchange, Object recipient, List<ProcessorExchangePair> result, int index) throws NoTypeConversionAvailableException {
        AsyncProducer producer;
        ExchangePattern pattern;
        Endpoint endpoint;
        boolean prototype = this.cacheSize < 0;
        try {
            recipient = RecipientListProcessor.prepareRecipient(exchange, recipient);
            Endpoint existing = RecipientListProcessor.getExistingEndpoint(exchange, recipient);
            if (existing == null) {
                endpoint = RecipientListProcessor.resolveEndpoint(exchange, recipient, prototype);
            } else {
                endpoint = existing;
                prototype = false;
            }
            pattern = this.resolveExchangePattern(recipient);
            producer = this.producerCache.acquireProducer(endpoint);
        }
        catch (Exception e) {
            if (this.isIgnoreInvalidEndpoints()) {
                LOG.debug("Endpoint uri is invalid: {}. This exception will be ignored.", recipient, (Object)e);
                return index;
            }
            throw e;
        }
        result.add(this.createProcessorExchangePair(index++, endpoint, producer, exchange, pattern, prototype));
        return index;
    }

    protected ProcessorExchangePair createProcessorExchangePair(int index, Endpoint endpoint, Producer producer, Exchange exchange, ExchangePattern pattern, boolean prototypeEndpoint) {
        Exchange copy = this.processorExchangeFactory.createCorrelatedCopy(exchange, false);
        copy.adapt(ExtendedExchange.class).setTransacted(exchange.isTransacted());
        if (exchange.isTransacted() && copy.getProperty("CamelTransactionContextData") == null) {
            if (this.txData == null) {
                this.txData = new ConcurrentHashMap<String, Object>();
            }
            copy.setProperty("CamelTransactionContextData", this.txData);
        }
        if (this.isShareUnitOfWork()) {
            this.prepareSharedUnitOfWork(copy, exchange);
        }
        RecipientListProcessor.setToEndpoint(copy, endpoint);
        Route route = ExchangeHelper.getRoute(exchange);
        Processor prepared = this.wrapInErrorHandler(route, copy, producer);
        if (this.onPrepare != null) {
            try {
                this.onPrepare.process(copy);
            }
            catch (Exception e) {
                copy.setException(e);
            }
        }
        return new RecipientProcessorExchangePair(index, this.producerCache, endpoint, producer, prepared, copy, pattern, prototypeEndpoint);
    }

    protected static Object prepareRecipient(Exchange exchange, Object recipient) throws NoTypeConversionAvailableException {
        if (recipient instanceof Endpoint || recipient instanceof NormalizedEndpointUri) {
            return recipient;
        }
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        }
        if (recipient != null) {
            ExtendedCamelContext ecc = (ExtendedCamelContext)exchange.getContext();
            String uri = recipient instanceof String ? (String)recipient : ecc.getTypeConverter().mandatoryConvertTo(String.class, exchange, recipient);
            return ecc.normalizeUri(uri);
        }
        return null;
    }

    protected static Endpoint getExistingEndpoint(Exchange exchange, Object recipient) {
        if (recipient instanceof Endpoint) {
            return (Endpoint)recipient;
        }
        if (recipient != null) {
            if (recipient instanceof NormalizedEndpointUri) {
                NormalizedEndpointUri nu = (NormalizedEndpointUri)recipient;
                ExtendedCamelContext ecc = (ExtendedCamelContext)exchange.getContext();
                return ecc.hasEndpoint(nu);
            }
            String uri = recipient.toString().trim();
            return exchange.getContext().hasEndpoint(uri);
        }
        return null;
    }

    protected static Endpoint resolveEndpoint(Exchange exchange, Object recipient, boolean prototype) {
        return prototype ? ExchangeHelper.resolvePrototypeEndpoint(exchange, recipient) : ExchangeHelper.resolveEndpoint(exchange, recipient);
    }

    protected ExchangePattern resolveExchangePattern(Object recipient) {
        String s = null;
        if (recipient instanceof NormalizedEndpointUri) {
            s = ((NormalizedEndpointUri)recipient).getUri();
        } else if (recipient instanceof String) {
            s = ((String)recipient).trim();
        }
        if (s != null) {
            return EndpointHelper.resolveExchangePatternFromUrl(s);
        }
        return null;
    }

    protected static void setToEndpoint(Exchange exchange, Endpoint endpoint) {
        exchange.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)endpoint.getEndpointUri());
    }

    @Override
    protected void doBuild() throws Exception {
        super.doBuild();
        ServiceHelper.buildService((Object)this.producerCache);
        RecipientProcessorExchangePair dummy = new RecipientProcessorExchangePair(0, null, null, null, null, null, null, false);
        LOG.trace("Loaded {}", (Object)dummy.getClass().getName());
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        ServiceHelper.initService((Object)this.producerCache);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object)this.producerCache);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.producerCache);
        super.doStop();
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.producerCache);
        super.doShutdown();
    }

    @Override
    public String getTraceLabel() {
        return "recipientList";
    }

    static final class RecipientProcessorExchangePair
    implements ProcessorExchangePair {
        private final int index;
        private final Endpoint endpoint;
        private final AsyncProducer producer;
        private Processor prepared;
        private final Exchange exchange;
        private final ProducerCache producerCache;
        private final ExchangePattern pattern;
        private volatile ExchangePattern originalPattern;
        private final boolean prototypeEndpoint;

        private RecipientProcessorExchangePair(int index, ProducerCache producerCache, Endpoint endpoint, Producer producer, Processor prepared, Exchange exchange, ExchangePattern pattern, boolean prototypeEndpoint) {
            this.index = index;
            this.producerCache = producerCache;
            this.endpoint = endpoint;
            this.producer = AsyncProcessorConverterHelper.convert(producer);
            this.prepared = prepared;
            this.exchange = exchange;
            this.pattern = pattern;
            this.prototypeEndpoint = prototypeEndpoint;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Exchange getExchange() {
            return this.exchange;
        }

        @Override
        public Producer getProducer() {
            return this.producer;
        }

        @Override
        public Processor getProcessor() {
            return this.prepared;
        }

        @Override
        public void begin() {
            LOG.trace("RecipientProcessorExchangePair #{} begin: {}", (Object)this.index, (Object)this.exchange);
            this.exchange.setProperty(ExchangePropertyKey.RECIPIENT_LIST_ENDPOINT, (Object)this.endpoint.getEndpointUri());
            MessageHelper.resetStreamCache(this.exchange.getIn());
            if (this.pattern != null) {
                this.originalPattern = this.exchange.getPattern();
                LOG.trace("Using exchangePattern: {} on exchange: {}", (Object)this.pattern, (Object)this.exchange);
                this.exchange.setPattern(this.pattern);
            }
        }

        @Override
        public void done() {
            LOG.trace("RecipientProcessorExchangePair #{} done: {}", (Object)this.index, (Object)this.exchange);
            try {
                if (this.originalPattern != null) {
                    this.exchange.setPattern(this.originalPattern);
                }
                this.producerCache.releaseProducer(this.endpoint, this.producer);
                if (this.prototypeEndpoint) {
                    ServiceHelper.stopAndShutdownService(this.endpoint);
                }
            }
            catch (Exception e) {
                LOG.debug("Error releasing producer: {}. This exception will be ignored.", (Object)this.producer, (Object)e);
            }
        }
    }
}

