/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.velocity;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.velocity.CamelVelocityClasspathResourceLoader;
import org.apache.camel.component.velocity.CamelVelocityDelegateClassLoader;
import org.apache.camel.component.velocity.VelocityComponent;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="1.2.0", scheme="velocity", title="Velocity", syntax="velocity:resourceUri", producerOnly=true, label="transformation")
public class VelocityEndpoint
extends ResourceEndpoint {
    private VelocityEngine velocityEngine;
    @UriParam(defaultValue="true")
    private boolean loaderCache = true;
    @UriParam
    private String encoding;
    @UriParam
    private String propertiesFile;

    public VelocityEndpoint() {
    }

    public VelocityEndpoint(String uri, VelocityComponent component, String resourceUri) {
        super(uri, (Component)component, resourceUri);
    }

    public boolean isSingleton() {
        return true;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "velocity:" + this.getResourceUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized VelocityEngine getVelocityEngine() throws Exception {
        if (this.velocityEngine == null) {
            this.velocityEngine = new VelocityEngine();
            this.velocityEngine.addProperty("CamelClassResolver", this.getCamelContext().getClassResolver());
            Properties properties = new Properties();
            properties.setProperty("file.resource.loader.cache", this.isLoaderCache() ? "true" : "false");
            properties.setProperty("resource.loader", "file, class");
            properties.setProperty("class.resource.loader.description", "Camel Velocity Classpath Resource Loader");
            properties.setProperty("class.resource.loader.class", CamelVelocityClasspathResourceLoader.class.getName());
            Logger velocityLogger = LoggerFactory.getLogger((String)"org.apache.camel.maven.Velocity");
            properties.setProperty("runtime.log.name", velocityLogger.getName());
            if (ObjectHelper.isNotEmpty((Object)this.getPropertiesFile())) {
                InputStream reader = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.getPropertiesFile());
                try {
                    properties.load(reader);
                    this.log.info("Loaded the velocity configuration file " + this.getPropertiesFile());
                }
                finally {
                    IOHelper.close((Closeable)reader, (String)this.getPropertiesFile(), (Logger)this.log);
                }
            }
            this.log.debug("Initializing VelocityEngine with properties {}", (Object)properties);
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                CamelVelocityDelegateClassLoader delegate = new CamelVelocityDelegateClassLoader(old);
                Thread.currentThread().setContextClassLoader(delegate);
                this.velocityEngine.init(properties);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public boolean isLoaderCache() {
        return this.loaderCache;
    }

    public void setLoaderCache(boolean loaderCache) {
        this.loaderCache = loaderCache;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setPropertiesFile(String file) {
        this.propertiesFile = file;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public VelocityEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        this.log.debug("Getting endpoint with URI: {}", (Object)newUri);
        return (VelocityEndpoint)this.getCamelContext().getEndpoint(newUri, VelocityEndpoint.class);
    }

    protected void onExchange(Exchange exchange) throws Exception {
        Reader reader;
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        String newResourceUri = (String)exchange.getIn().getHeader("CamelVelocityResourceUri", String.class);
        if (newResourceUri != null) {
            exchange.getIn().removeHeader("CamelVelocityResourceUri");
            this.log.debug("{} set to {} creating new endpoint to handle exchange", (Object)"CamelVelocityResourceUri", (Object)newResourceUri);
            VelocityEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
            newEndpoint.onExchange(exchange);
            return;
        }
        String content = (String)exchange.getIn().getHeader("CamelVelocityTemplate", String.class);
        if (content != null) {
            reader = new StringReader(content);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Velocity content read from header {} for endpoint {}", (Object)"CamelVelocityTemplate", (Object)this.getEndpointUri());
            }
            exchange.getIn().removeHeader("CamelVelocityTemplate");
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Velocity content read from resource {} with resourceUri: {} for endpoint {}", new Object[]{this.getResourceUri(), path, this.getEndpointUri()});
            }
            reader = this.getEncoding() != null ? new InputStreamReader(this.getResourceAsInputStream(), this.getEncoding()) : new InputStreamReader(this.getResourceAsInputStream());
        }
        StringWriter buffer = new StringWriter();
        String logTag = ((Object)((Object)this)).getClass().getName();
        Context velocityContext = (Context)exchange.getIn().getHeader("CamelVelocityContext", Context.class);
        if (velocityContext == null) {
            Map variableMap = ExchangeHelper.createVariableMap((Exchange)exchange);
            Map supplementalMap = (Map)exchange.getIn().getHeader("CamelVelocitySupplementalContext", Map.class);
            if (supplementalMap != null) {
                variableMap.putAll(supplementalMap);
            }
            velocityContext = new VelocityContext(variableMap);
        }
        VelocityEngine engine = this.getVelocityEngine();
        this.log.debug("Velocity is evaluating using velocity context: {}", (Object)velocityContext);
        engine.evaluate(velocityContext, (Writer)buffer, logTag, reader);
        Message out = exchange.getOut();
        out.setBody((Object)buffer.toString());
        out.setHeaders(exchange.getIn().getHeaders());
        out.setAttachments(exchange.getIn().getAttachments());
    }
}

