/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.node.AbstractExecutor;
import org.apache.velocity.util.introspection.Introspector;
import org.slf4j.Logger;

public class PublicFieldExecutor
extends AbstractExecutor {
    private final Introspector introspector;
    private Field field = null;

    public PublicFieldExecutor(Logger logger, Introspector introspector, Class clazz, String string) {
        this.log = logger;
        this.introspector = introspector;
        if (StringUtils.isNotEmpty(string)) {
            this.discover(clazz, string);
        }
    }

    @Override
    public boolean isAlive() {
        return this.getField() != null;
    }

    public Field getField() {
        return this.field;
    }

    protected void setField(Field field) {
        this.field = field;
    }

    protected Introspector getIntrospector() {
        return this.introspector;
    }

    protected void discover(Class clazz, String string) {
        try {
            this.setField(this.introspector.getField(clazz, string));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            String string2 = "Exception while looking for public field '" + string;
            this.log.error(string2, (Throwable)exception);
            throw new VelocityException(string2, exception);
        }
    }

    @Override
    public Object execute(Object object) throws IllegalAccessException, InvocationTargetException {
        return this.isAlive() ? this.getField().get(object) : null;
    }
}

