/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceCache;
import org.apache.velocity.runtime.resource.ResourceCacheImpl;
import org.apache.velocity.runtime.resource.ResourceFactory;
import org.apache.velocity.runtime.resource.ResourceManager;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.runtime.resource.loader.ResourceLoaderFactory;
import org.apache.velocity.util.ClassUtils;
import org.apache.velocity.util.ExtProperties;
import org.slf4j.Logger;

public class ResourceManagerImpl
implements ResourceManager {
    public static final int RESOURCE_TEMPLATE = 1;
    public static final int RESOURCE_CONTENT = 2;
    protected ResourceCache globalCache = null;
    protected final List<ResourceLoader> resourceLoaders = new ArrayList<ResourceLoader>();
    private final List<ExtProperties> sourceInitializerList = new ArrayList<ExtProperties>();
    private boolean isInit = false;
    private boolean logWhenFound = true;
    protected RuntimeServices rsvc = null;
    protected Logger log = null;

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void initialize(RuntimeServices runtimeServices) {
        void var4_9;
        void var4_7;
        Object object;
        String string;
        if (this.isInit) {
            this.log.debug("Re-initialization of ResourceLoader attempted and ignored.");
            return;
        }
        ResourceLoader resourceLoader = null;
        this.rsvc = runtimeServices;
        this.log = this.rsvc.getLog("loader");
        this.log.trace("ResourceManager initializing: {}", this.getClass());
        this.assembleResourceLoaderInitializers();
        for (ExtProperties object22 : this.sourceInitializerList) {
            string = StringUtils.trim(object22.getString("class"));
            object = (ResourceLoader)object22.get("instance");
            if (object != null) {
                resourceLoader = object;
            } else if (string != null) {
                resourceLoader = ResourceLoaderFactory.getLoader(this.rsvc, string);
            } else {
                String string2 = "Unable to find '" + object22.getString("_RESOURCE_LOADER_IDENTIFIER_") + ".resource.loader.class' specification in configuration. This is a critical value.  Please adjust configuration.";
                this.log.error(string2);
                throw new VelocityException(string2);
            }
            resourceLoader.commonInit(this.rsvc, object22);
            resourceLoader.init(object22);
            this.resourceLoaders.add(resourceLoader);
        }
        this.logWhenFound = this.rsvc.getBoolean("resource.manager.logwhenfound", true);
        String string3 = this.rsvc.getString("resource.manager.cache.class");
        Object var4_5 = null;
        if (StringUtils.isNotEmpty(string3)) {
            Object object2;
            try {
                object2 = ClassUtils.getNewInstance(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = "The specified class for ResourceCache (" + (String)string3 + ") does not exist or is not accessible to the current classloader.";
                this.log.error((String)object, (Throwable)classNotFoundException);
                throw new VelocityException((String)object, classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new VelocityException("Could not access class '" + (String)string3 + "'", illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new VelocityException("Could not instantiate class '" + (String)string3 + "'", instantiationException);
            }
            if (!(object2 instanceof ResourceCache)) {
                string = "The specified resource cache class (" + (String)string3 + ") must implement " + ResourceCache.class.getName();
                this.log.error(string);
                throw new RuntimeException(string);
            }
        }
        if (var4_7 == null) {
            ResourceCacheImpl resourceCacheImpl = new ResourceCacheImpl();
        }
        this.globalCache = (ResourceCache)var4_9;
        this.globalCache.initialize(this.rsvc);
        this.log.trace("Default ResourceManager initialization complete.");
    }

    private void assembleResourceLoaderInitializers() {
        Vector vector = this.rsvc.getConfiguration().getVector("resource.loader");
        ListIterator<String> listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            String string = StringUtils.trim((String)listIterator.next());
            listIterator.set(string);
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(".").append("resource.loader");
            ExtProperties extProperties = this.rsvc.getConfiguration().subset(stringBuilder.toString());
            if (extProperties == null) {
                this.log.debug("ResourceManager : No configuration information found for resource loader named '{}' (id is {}). Skipping it...", (Object)string, (Object)stringBuilder);
                continue;
            }
            extProperties.setProperty("_RESOURCE_LOADER_IDENTIFIER_", string);
            this.sourceInitializerList.add(extProperties);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Resource getResource(String string, int n, String string2) throws ResourceNotFoundException, ParseErrorException {
        String string3 = n + string;
        Resource resource = this.globalCache.get(string3);
        if (resource != null) {
            try {
                if (!resource.requiresChecking()) return resource;
                return this.refreshResource(resource, string2);
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                this.globalCache.remove(string3);
                return this.getResource(string, n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.log.error("ResourceManager.getResource() exception", (Throwable)runtimeException);
                throw runtimeException;
            }
        }
        try {
            resource = this.loadResource(string, n, string2);
            if (!resource.getResourceLoader().isCachingOn()) return resource;
            this.globalCache.put(string3, resource);
            return resource;
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            this.log.error("ResourceManager: unable to find resource '{}' in any resource loader.", (Object)string);
            throw resourceNotFoundException;
        }
        catch (ParseErrorException parseErrorException) {
            this.log.error("ResourceManager: parse exception: {}", (Object)parseErrorException.getMessage());
            throw parseErrorException;
        }
        catch (RuntimeException runtimeException) {
            this.log.error("ResourceManager.getResource() load exception", (Throwable)runtimeException);
            throw runtimeException;
        }
    }

    protected Resource createResource(String string, int n) {
        return ResourceFactory.getResource(string, n);
    }

    protected Resource loadResource(String string, int n, String string2) throws ResourceNotFoundException, ParseErrorException {
        Resource resource = this.createResource(string, n);
        resource.setRuntimeServices(this.rsvc);
        resource.setName(string);
        resource.setEncoding(string2);
        long l = 0L;
        for (ResourceLoader resourceLoader : this.resourceLoaders) {
            resource.setResourceLoader(resourceLoader);
            try {
                if (!resource.process()) continue;
                if (this.logWhenFound) {
                    this.log.debug("ResourceManager: found {} with loader {}", (Object)string, (Object)resourceLoader.getClassName());
                }
                l = resourceLoader.getLastModified(resource);
                break;
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
            }
        }
        if (resource.getData() == null) {
            throw new ResourceNotFoundException("Unable to find resource '" + string + "'");
        }
        resource.setLastModified(l);
        resource.setModificationCheckInterval(resource.getResourceLoader().getModificationCheckInterval());
        resource.touch();
        return resource;
    }

    protected Resource refreshResource(Resource resource, String string) throws ResourceNotFoundException, ParseErrorException {
        String string2;
        resource.touch();
        ResourceLoader resourceLoader = resource.getResourceLoader();
        if (this.resourceLoaders.size() > 0 && this.resourceLoaders.indexOf(resourceLoader) > 0 && resourceLoader != this.getLoaderForResource(string2 = resource.getName())) {
            return this.loadResource(string2, resource.getType(), string);
        }
        if (resource.isSourceModified()) {
            if (!StringUtils.equals(resource.getEncoding(), string)) {
                this.log.warn("Declared encoding for template '{}' is different on reload. Old = '{}' New = '{}'", new Object[]{resource.getName(), resource.getEncoding(), string});
                resource.setEncoding(string);
            }
            long l = resourceLoader.getLastModified(resource);
            String string3 = resource.getType() + resource.getName();
            Resource resource2 = ResourceFactory.getResource(resource.getName(), resource.getType());
            resource2.setRuntimeServices(this.rsvc);
            resource2.setName(resource.getName());
            resource2.setEncoding(resource.getEncoding());
            resource2.setResourceLoader(resourceLoader);
            resource2.setModificationCheckInterval(resourceLoader.getModificationCheckInterval());
            resource2.process();
            resource2.setLastModified(l);
            resource = resource2;
            this.globalCache.put(string3, resource2);
        }
        return resource;
    }

    @Override
    public String getLoaderNameForResource(String string) {
        ResourceLoader resourceLoader = this.getLoaderForResource(string);
        if (resourceLoader == null) {
            return null;
        }
        return resourceLoader.getClass().toString();
    }

    private ResourceLoader getLoaderForResource(String string) {
        for (ResourceLoader resourceLoader : this.resourceLoaders) {
            if (!resourceLoader.resourceExists(string)) continue;
            return resourceLoader;
        }
        return null;
    }
}

